local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local thisLevel, player, ValkyrieFight, SelectedAISet
local AISets = {
  "AI_3111",
  "AI_3121",
  "AI_3131",
  "AI_3211",
  "AI_3221",
  "AI_3231",
  "AI_3311",
  "AI_3321",
  "AI_3331",
  "AI_3112",
  "AI_3122",
  "AI_3132",
  "AI_3212",
  "AI_3222",
  "AI_3232",
  "AI_3312",
  "AI_3322",
  "AI_3332",
  "AI_3113",
  "AI_3123",
  "AI_3133",
  "AI_3213",
  "AI_3223",
  "AI_3233",
  "AI_3313",
  "AI_3323",
  "AI_3333"
}
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  SpawnValkyrie()
end
function OnPreStart(level)
  GameObjects.chest_legendary_tier6_nid310_1.LuaObjectScript.DisableCheckpointRequirement()
end
function OnEvaluateLoadGroup_LoadGroup_MazeAI()
  SelectedAISet = game.Level.GetVariable("NIF_SelectedAIMix")
  return tostring(AISets[SelectedAISet])
end
function SpawnValkyrie()
  if game.Wallets.GetResourceValue("HERO", "ValkyrieLoot07") == -1 then
    ValkyrieFight = EC.NewEncounter(thisLevel, "Niflheim: Valkyrie Encounter", {
      LeashZone = "LshZn_Nid310_01"
    })
    ValkyrieFight:AddWave({
      {
        spawners = "Spawn_Valkyrie00",
        spawnWad = "Nid310_NWRoom",
        markerID = "Valkyrie_Nid310",
        initialSpawnCooldown = 0.5,
        initialSpawnAmount = 1,
        maxActive = 1,
        totalSpawns = 1,
        spawnCooldown = 0
      }
    })
    ValkyrieFight:SetAlertZone(GameObjects.EntZn_Nid310NW_ValkyrieAlert)
    ValkyrieFight:SetStartZone(GameObjects.EntZn_Nid310NW_ValkyrieSpawn)
    ValkyrieFight:OnComplete(SetValkyrieKilled)
  end
end
function SetBackFightThisTrip_True()
  LD.SetEntityVariable("NIF_BackFightThisTrip", true)
end
function Trigger_Out_Of_Bounds()
  player:AddMarker("Out_Of_Bounds")
end
function Trigger_In_Bounds()
  player:RemoveMarker("Out_Of_Bounds")
end
function SetValkyrieKilled()
  LD.SetEntityVariable("NIF_ValkyrieDefeated", true)
  LD.SetEntityVariable("NIF_BackFightThisTrip", true)
end
