local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local thisLevel
local delayDestruction = false
local delayDestruction_T = {}
local LastMist = 0
local enc_LootRift_01, Prime_HealthMonitor
local RiftBanter_ArriveCount = 1
local RiftBanter_CompleteCount = 0
local RiftBanter_MistCost = {
  10000,
  15000,
  20000
}
local enc_LootRift_02, enc_LootRift_02_Support_Pwr, enc_LootRift_02_Support_Spd, enc_LootRift_03, SelectedAISet
local AISets = {
  "AI_3111",
  "AI_3121",
  "AI_3131",
  "AI_3211",
  "AI_3221",
  "AI_3231",
  "AI_3311",
  "AI_3321",
  "AI_3331",
  "AI_3112",
  "AI_3122",
  "AI_3132",
  "AI_3212",
  "AI_3222",
  "AI_3232",
  "AI_3312",
  "AI_3322",
  "AI_3332",
  "AI_3113",
  "AI_3123",
  "AI_3133",
  "AI_3213",
  "AI_3223",
  "AI_3233",
  "AI_3313",
  "AI_3323",
  "AI_3333"
}
function OnScriptLoaded(level)
  thisLevel = level
  FNC_LootRift_01()
  FNC_LootRift_02()
  FNC_LootRift_02_Support_Pwr()
  FNC_LootRift_02_Support_Spd()
  FNC_LootRift_03()
end
function OnFirstStart(level)
end
function OnStart(level)
  UpdateChests()
  if enc_LootRift_01 ~= nil and not enc_LootRift_01:IsComplete() and not enc_LootRift_01:IsRunning() then
    GameObjects.misc_legendary_tier4_nid400_1.LuaObjectScript.ResetCombatState()
  end
  if enc_LootRift_02 ~= nil and not enc_LootRift_02:IsComplete() and not enc_LootRift_02:IsRunning() then
    GameObjects.misc_legendary_tier5_nid400_1.LuaObjectScript.ResetCombatState()
  end
  if enc_LootRift_03 ~= nil and not enc_LootRift_03:IsComplete() and not enc_LootRift_03:IsRunning() then
    GameObjects.misc_legendary_tier6_nid400_1.LuaObjectScript.ResetCombatState()
  end
  Trophy_Fixup_DarknessAndFog()
end
function OnUpdate(level)
  if LastMist ~= game.Wallets.GetResourceValue("HERO", "NiflheimCurrency") then
    LastMist = game.Wallets.GetResourceValue("HERO", "NiflheimCurrency")
    UpdateChests()
  end
  UpdateCreatureDestruction()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    RiftBanter_ArriveCount = RiftBanter_ArriveCount,
    RiftBanter_CompleteCount = RiftBanter_CompleteCount
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  RiftBanter_ArriveCount = savedInfo.RiftBanter_ArriveCount
  RiftBanter_CompleteCount = savedInfo.RiftBanter_CompleteCount
end
function PlayBanter_RiftArrival()
  local currentResourceCount = game.Wallets.GetResourceValue("HERO", "NiflheimCurrency")
  local currentTearKeyCount = game.Wallets.GetResourceValue("HERO", "NiflheimTearKey")
  if RiftBanter_ArriveCount == 1 and RiftBanter_CompleteCount == 0 then
    if currentResourceCount >= RiftBanter_MistCost[RiftBanter_ArriveCount] and 0 < currentTearKeyCount then
      game.Audio.PlayBanter("Nif_RealmTear_01_Available")
      RiftBanter_ArriveCount = 2
    end
  elseif RiftBanter_ArriveCount == 2 and RiftBanter_CompleteCount == 1 then
    if currentResourceCount >= RiftBanter_MistCost[RiftBanter_ArriveCount] and 0 < currentTearKeyCount then
      game.Audio.PlayBanter("Nif_RealmTear_02_Available")
      RiftBanter_ArriveCount = 3
    end
  elseif RiftBanter_ArriveCount == 3 and RiftBanter_CompleteCount == 2 and currentResourceCount >= RiftBanter_MistCost[RiftBanter_ArriveCount] and 0 < currentTearKeyCount then
    game.Audio.PlayBanter("Nif_RealmTear_03_Available")
    RiftBanter_ArriveCount = 4
  end
end
function PlayBanter_RiftComplete()
  if RiftBanter_CompleteCount == 0 then
    game.Audio.PlayBanter("Nif_RealmTear_01_Complete")
    RiftBanter_CompleteCount = 1
    RiftBanter_ArriveCount = 2
  elseif RiftBanter_CompleteCount == 1 then
    game.Audio.PlayBanter("Nif_RealmTear_02_Complete")
    RiftBanter_CompleteCount = 2
    RiftBanter_ArriveCount = 3
  elseif RiftBanter_CompleteCount == 2 then
    game.Audio.PlayBanter("Nif_RealmTear_03_Complete")
    RiftBanter_CompleteCount = 3
    RiftBanter_ArriveCount = 4
  end
end
function UpdateChests()
  GameObjects.ResourceGate_Legendary_tier1_1.LuaObjectScript.SetupChest()
  GameObjects.ResourceGate_Legendary_tier2.LuaObjectScript.SetupChest()
  GameObjects.ResourceGate_Legendary_tier3.LuaObjectScript.SetupChest()
  GameObjects.ResourceGate_Legendary_tier4_1.LuaObjectScript.SetupChest()
  GameObjects.ResourceGate_Legendary_tier5.LuaObjectScript.SetupChest()
  GameObjects.ResourceGate_Rift_1.LuaObjectScript.SetupChest()
  GameObjects.ResourceGate_Rift_2.LuaObjectScript.SetupChest()
  GameObjects.ResourceGate_Rift_3.LuaObjectScript.SetupChest()
end
function OnEvaluateLoadGroup_LoadGroup_MazeAI()
  SelectedAISet = game.Level.GetVariable("NIF_SelectedAIMix")
  return tostring(AISets[SelectedAISet])
end
function Trophy_Fixup_DarknessAndFog()
  local required = 27
  local total = 0
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_5)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_2)
  total = total + IsChestLooted(GameObjects.coffin_tier2_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_4)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_1)
  total = total + IsChestLooted(GameObjects.coffin_tier5_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_8)
  total = total + IsChestLooted(GameObjects.chest_legendary_tier1_nid400_1)
  total = total + IsChestLooted(GameObjects.coffin_tier4_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_13)
  total = total + IsChestLooted(GameObjects.chest_legendary_tier2_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_legendary_tier3_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_12)
  total = total + IsChestLooted(GameObjects.chest_legendary_tier4_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_11)
  total = total + IsChestLooted(GameObjects.chest_legendary_tier5_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_10)
  total = total + IsChestLooted(GameObjects.coffin_tier3_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_9)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_3)
  total = total + IsChestLooted(GameObjects.coffin_tier1_nid400_1)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_7)
  total = total + IsChestLooted(GameObjects.chest_common_tier6_nid400_6)
  total = total + IsCorpseLooted(GameObjects.corpse_legendary_tier6_nid400_1)
  total = total + IsRiftLooted(GameObjects.misc_legendary_tier4_nid400_1)
  total = total + IsRiftLooted(GameObjects.misc_legendary_tier6_nid400_1)
  total = total + IsRiftLooted(GameObjects.misc_legendary_tier5_nid400_1)
  if required <= total then
    game.UnlockTrophy(35)
  end
end
function IsRiftLooted(obj)
  if obj ~= nil and obj.LuaObjectScript.IsOpen() == true then
    return 1
  end
  return 0
end
function IsChestLooted(obj)
  if obj ~= nil and obj.LuaObjectScript.GetState() == 4 then
    return 1
  end
  return 0
end
function IsCorpseLooted(obj)
  if obj ~= nil and obj.LuaObjectScript.GetState() == 3 then
    return 1
  end
  return 0
end
function NifQuest01Increment()
  game.QuestManager.IncrementQuestProgress("Quest_Sindri_Niflheim03_Objective01", 1)
  LD.CompleteQuest("Quest_Sindri_Niflheim03_Objective01a")
  IncrementTrophyCounter()
end
function NifQuest02Increment()
  game.QuestManager.IncrementQuestProgress("Quest_Sindri_Niflheim03_Objective01", 1)
  LD.CompleteQuest("Quest_Sindri_Niflheim03_Objective01b")
  IncrementTrophyCounter()
end
function NifQuest03Increment()
  game.QuestManager.IncrementQuestProgress("Quest_Sindri_Niflheim03_Objective01", 1)
  LD.CompleteQuest("Quest_Sindri_Niflheim03_Objective01c")
  IncrementTrophyCounter()
end
function FNC_LootRift_01()
  enc_LootRift_01 = EC.NewEncounter(thisLevel, "Niflheim: PocketRift 01 Encounter", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Nid400_01",
    StartMusic = "SND_MX_NIF_rift_fight1_in",
    StopMusic = "SND_MX_NIF_rift_fight1_out"
  })
  enc_LootRift_01:AddWave({
    {
      spawners = "Spawn_Jotunn10_Prime",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      markerID = "Prime",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  enc_LootRift_01:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Spawn_Jotunn10_PL7",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  enc_LootRift_01:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Spawn_Jotunn10_PL6",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  enc_LootRift_01:OnEnemySpawn(PocketRift_01_Health_Encounter, {markerID = "Prime"})
  enc_LootRift_01:OnComplete(Stop_FightRift_01)
  enc_LootRift_01:OnComplete(function()
    LD.SetMarkerState("Nif_400_RealmTear01", 0)
  end)
  enc_LootRift_01:OnStart(function()
    GameObjects.PktRft_Spawn_A.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Spawn_A.LuaObjectScript.SpawningDone()
    end, 5)
  end, 1)
  enc_LootRift_01:OnStart(function()
    GameObjects.PktRft_Spawn_B.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Spawn_B.LuaObjectScript.SpawningDone()
    end, 5)
  end, 2)
  enc_LootRift_01:OnStart(function()
    GameObjects.PktRft_Spawn_C.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Spawn_C.LuaObjectScript.SpawningDone()
    end, 5)
  end, 3)
  enc_LootRift_01:OnEnemySpawn(function()
    GameObjects.PktRft_Spawn_A.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 1})
  enc_LootRift_01:OnEnemySpawn(function()
    GameObjects.PktRft_Spawn_B.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 2})
  enc_LootRift_01:OnEnemySpawn(function()
    GameObjects.PktRft_Spawn_C.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 3})
end
function PocketRift_Cbt_CallBack_01()
  GameObjects.RespawnRift01Safety:ShowEntityVolume()
  timers.StartLevelTimer(2, function()
    enc_LootRift_01:Start()
  end)
  timers.StartLevelTimer(2, function()
    GameObjects.misc_legendary_tier4_nid400_1.LuaObjectScript.SpawningDone()
  end)
end
function RespawnRift01Fight()
  if enc_LootRift_01 ~= nil and enc_LootRift_01:IsRunning() == true then
    EncounterExplodeAI_enc01()
    enc_LootRift_01:DespawnEnemies()
    enc_LootRift_01:Reset()
    GameObjects.misc_legendary_tier4_nid400_1.LuaObjectScript.ResetCombatState()
  end
end
function EncounterExplodeAI_enc01()
  local minTime = 0
  local maxTime = 0.2
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies1 = enc_LootRift_01:GetActiveEnemies()
  for _, enemy in pairs(enemies1) do
    if enemy ~= nil then
      local enemyLastPos = enemy:GetWorldJointPosition(enemy:GetJointIndex("JOPelvis1"))
      timers.StartLevelTimer(randomFn(), function()
        local enemyVFX = game.FX.Spawn("BloodExplode", nil, {
          AutoDelete = true,
          EffectCreator = enemy,
          Scale = 1.5
        })
        enemyVFX:SetWorldPosition(enemyLastPos)
      end)
    end
  end
end
function PocketRift_01_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local Prime_Health = Enemy:GetHitPoints()
    Prime_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = Prime_Health * 0.9
    local Health_Phase_2 = Prime_Health * 0.6
    Prime_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      enc_LootRift_01:StartWave(2)
    end)
    Prime_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      enc_LootRift_01:StartWave(3)
    end)
  end
end
function FNC_LootRift_02()
  enc_LootRift_02 = EC.NewEncounter(thisLevel, "Niflheim: PocketRift 02 Encounter", {
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Nid400_01",
    StartMusic = "SND_MX_NIF_rift_fight2_in",
    StopMusic = "SND_MX_NIF_rift_fight2_out"
  })
  enc_LootRift_02:AddWave({
    {
      spawners = "Spawn_Golem_Prime",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  enc_LootRift_02:OnStart(function()
    enc_LootRift_02_Support_Pwr:Start()
    enc_LootRift_02_Support_Spd:Start()
  end)
  enc_LootRift_02:OnComplete(Stop_FightRift_02)
  enc_LootRift_02:OnComplete(function()
    NID_Despawn_EC_VFX(enc_LootRift_02_Support_Pwr)
    enc_LootRift_02_Support_Pwr:SetComplete()
    NID_Despawn_EC_VFX(enc_LootRift_02_Support_Spd)
    enc_LootRift_02_Support_Spd:SetComplete()
  end)
  enc_LootRift_02:OnStart(function()
    GameObjects.PktRft_Spawn_B.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Spawn_B.LuaObjectScript.SpawningDone()
    end, 5)
    LD.CallFunctionAfterDelay(function()
      enc_LootRift_02:AlertEnemies()
    end, 3)
  end, 1)
  enc_LootRift_02:OnEnemySpawn(function()
    GameObjects.PktRft_Spawn_B.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 1})
end
function PocketRift_Cbt_CallBack_02()
  GameObjects.RespawnRift02Safety:ShowEntityVolume()
  timers.StartLevelTimer(2, function()
    enc_LootRift_02:Start()
  end)
  timers.StartLevelTimer(2, function()
    GameObjects.misc_legendary_tier5_nid400_1.LuaObjectScript.SpawningDone()
  end)
end
function RespawnRift02Fight()
  if not (enc_LootRift_02:IsComplete() and enc_LootRift_02_Support_Pwr:IsComplete()) or not enc_LootRift_02_Support_Spd:IsComplete() then
    EncounterExplodeAI_enc02()
    GameObjects.misc_legendary_tier5_nid400_1.LuaObjectScript.ResetCombatState()
  end
  if enc_LootRift_02 ~= nil and enc_LootRift_02:IsRunning() == true then
    enc_LootRift_02:DespawnEnemies()
    enc_LootRift_02:Reset()
  end
  if enc_LootRift_02_Support_Pwr ~= nil and enc_LootRift_02_Support_Pwr:IsRunning() == true then
    enc_LootRift_02_Support_Pwr:DespawnEnemies()
    enc_LootRift_02_Support_Pwr:Reset()
  end
  if enc_LootRift_02_Support_Spd ~= nil and enc_LootRift_02_Support_Spd:IsRunning() == true then
    enc_LootRift_02_Support_Spd:DespawnEnemies()
    enc_LootRift_02_Support_Spd:Reset()
  end
end
function EncounterExplodeAI_enc02()
  local minTime = 0
  local maxTime = 0.2
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies1 = enc_LootRift_02:GetActiveEnemies()
  for _, enemy in pairs(enemies1) do
    if enemy ~= nil then
      local enemyLastPos = enemy:GetWorldJointPosition(enemy:GetJointIndex("JOPelvis1"))
      timers.StartLevelTimer(randomFn(), function()
        local enemyVFX = game.FX.Spawn("BloodExplode", nil, {
          AutoDelete = true,
          EffectCreator = enemy,
          Scale = 1.5
        })
        enemyVFX:SetWorldPosition(enemyLastPos)
      end)
    end
  end
  if enc_LootRift_02_Support_Pwr ~= nil and enc_LootRift_02_Support_Pwr:IsRunning() == true then
    enemies1 = enc_LootRift_02_Support_Pwr:GetActiveEnemies()
    for _, enemy in pairs(enemies1) do
      if enemy ~= nil then
        local enemyLastPos = enemy:GetWorldJointPosition(enemy:GetJointIndex("JOPelvis1"))
        timers.StartLevelTimer(randomFn(), function()
          local enemyVFX = game.FX.Spawn("BloodExplode", nil, {
            AutoDelete = true,
            EffectCreator = enemy,
            Scale = 1.5
          })
          enemyVFX:SetWorldPosition(enemyLastPos)
        end)
      end
    end
  end
  if enc_LootRift_02_Support_Spd ~= nil and enc_LootRift_02_Support_Spd:IsRunning() == true then
    enemies1 = enc_LootRift_02_Support_Spd:GetActiveEnemies()
    for _, enemy in pairs(enemies1) do
      if enemy ~= nil then
        local enemyLastPos = enemy:GetWorldJointPosition(enemy:GetJointIndex("JOPelvis1"))
        timers.StartLevelTimer(randomFn(), function()
          local enemyVFX = game.FX.Spawn("BloodExplode", nil, {
            AutoDelete = true,
            EffectCreator = enemy,
            Scale = 1.5
          })
          enemyVFX:SetWorldPosition(enemyLastPos)
        end)
      end
    end
  end
end
function FNC_LootRift_02_Support_Pwr()
  enc_LootRift_02_Support_Pwr = EC.NewEncounter(thisLevel, "Niflheim: PocketRift 02 Support - Power", {
    LeashZone = "LshZn_Nid400_01"
  })
  enc_LootRift_02_Support_Pwr:AddWave({
    {
      spawners = "Spawn_Wulver_Pwr_PL1",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 3
    }
  })
  enc_LootRift_02_Support_Pwr:AddWave({
    {
      spawners = "Spawn_Wulver_Pwr_PL2",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 7
    }
  })
  enc_LootRift_02_Support_Pwr:AddWave({
    {
      spawners = "Spawn_Wulver_Pwr_PL3",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 7
    }
  })
  enc_LootRift_02_Support_Pwr:AddWave({
    {
      spawners = "Spawn_Wulver_Pwr_PL4",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 7
    }
  })
  enc_LootRift_02_Support_Pwr:AddWave({
    {
      spawners = "Spawn_Wulver_Pwr_PL5",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 7
    }
  })
  enc_LootRift_02_Support_Pwr:AddWave({
    {
      spawners = "Spawn_Wulver_Pwr_PL6",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 7
    }
  })
  enc_LootRift_02_Support_Pwr:AddWave({
    {
      spawners = "Spawn_Wulver_Pwr_PL7",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 7
    }
  })
  enc_LootRift_02_Support_Pwr:AddWave({
    {
      spawners = "Spawn_Wulver_Pwr_PL8",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 7
    }
  })
  enc_LootRift_02_Support_Pwr:OnComplete(Stop_FightRift_02)
end
function FNC_LootRift_02_Support_Spd()
  enc_LootRift_02_Support_Spd = EC.NewEncounter(thisLevel, "Niflheim: PocketRift 02 Support - Speed", {
    LeashZone = "LshZn_Nid400_01"
  })
  enc_LootRift_02_Support_Spd:AddWave({
    {
      spawners = "Spawn_Wulver_Spd_PL1",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 1
    }
  })
  enc_LootRift_02_Support_Spd:AddWave({
    {
      spawners = "Spawn_Wulver_Spd_PL2",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 5
    }
  })
  enc_LootRift_02_Support_Spd:AddWave({
    {
      spawners = "Spawn_Wulver_Spd_PL3",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 5
    }
  })
  enc_LootRift_02_Support_Spd:AddWave({
    {
      spawners = "Spawn_Wulver_Spd_PL4",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 5
    }
  })
  enc_LootRift_02_Support_Spd:AddWave({
    {
      spawners = "Spawn_Wulver_Spd_PL5",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 5
    }
  })
  enc_LootRift_02_Support_Spd:AddWave({
    {
      spawners = "Spawn_Wulver_Spd_PL6",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 5
    }
  })
  enc_LootRift_02_Support_Spd:AddWave({
    {
      spawners = "Spawn_Wulver_Spd_PL7",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 5
    }
  })
  enc_LootRift_02_Support_Spd:AddWave({
    {
      spawners = "Spawn_Wulver_Spd_PL8",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      initialSpawnCooldown = 5
    }
  })
  enc_LootRift_02_Support_Spd:OnComplete(Stop_FightRift_02)
end
function NID_Despawn_Enemy_VFX()
  local minTime = 0
  local maxTime = 0.2
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies1 = enc_LootRift_02_Support_Spd:GetActiveEnemies()
  local enemies2 = enc_LootRift_02_Support_Pwr:GetActiveEnemies()
  for _, enemy in pairs(enemies1) do
    if enemy ~= nil then
      local enemyLastPos = enemy:GetWorldJointPosition(enemy:GetJointIndex("JOPelvis1"))
      timers.StartLevelTimer(randomFn(), function()
        local enemyVFX = game.FX.Spawn("Body_Fire_Explode", nil, {
          AutoDelete = true,
          EffectCreator = enemy,
          Scale = 1.5
        })
        enemyVFX:SetWorldPosition(enemyLastPos)
      end)
    end
  end
  for _, enemy in pairs(enemies2) do
    if enemy ~= nil then
      local enemyLastPos = enemy:GetWorldJointPosition(enemy:GetJointIndex("JOPelvis1"))
      timers.StartLevelTimer(randomFn(), function()
        local enemyVFX = game.FX.Spawn("Body_Fire_Explode", nil, {
          AutoDelete = true,
          EffectCreator = enemy,
          Scale = 1.5
        })
        enemyVFX:SetWorldPosition(enemyLastPos)
      end)
    end
  end
end
function NID_Despawn_EC_VFX(encounter)
  local minTime = 0
  local maxTime = 0.3
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies = encounter:GetActiveEnemies()
  for _, enemy in pairs(enemies) do
    if enemy ~= nil then
      if enemy:IsDoingSyncMove() == false then
        timers.StartLevelTimer(randomFn(), function()
          if enemy ~= nil then
            SpawnFXAtCreatureLocation(enemy)
            enemy:Destroy()
          end
        end)
      else
        CreatureInSyncMove_DelayDestruction(enemy)
      end
    end
  end
  encounter:ResetLivingEnemiesCount()
  encounter:ReportWaveDespawned(nil)
end
function SpawnFXAtCreatureLocation(creature)
  local fx = game.FX.Spawn("Body_Fire_Explode", nil, {
    AutoDelete = true,
    EffectCreator = creature,
    Scale = 1.5
  })
  local lastEnemyPos = creature:GetWorldJointPosition(creature:GetJointIndex("JOPelvis1"))
  fx:SetWorldPosition(lastEnemyPos)
end
function CreatureInSyncMove_DelayDestruction(creature)
  delayDestruction = true
  delayDestruction_T[creature] = true
end
function UpdateCreatureDestruction()
  if delayDestruction == true then
    local remaining = 0
    for creature, _ in pairs(delayDestruction_T) do
      if creature ~= nil and delayDestruction_T[creature] == true then
        if creature:IsDoingSyncMove() == false then
          SpawnFXAtCreatureLocation(creature)
          creature:Destroy()
          delayDestruction_T[creature] = nil
        else
          remaining = remaining + 1
        end
      end
    end
    if remaining == 0 then
      delayDestruction = false
      delayDestruction_T = {}
    end
  end
end
function FNC_LootRift_03()
  enc_LootRift_03 = EC.NewEncounter(thisLevel, "Niflheim: PocketRift 03 Encounter", {
    CheckpointOnComplete = true,
    LeashZone = "LshZn_Nid400_01",
    StartMusic = "SND_MX_NIF_rift_fight3_in",
    StopMusic = "SND_MX_NIF_rift_fight3_out"
  })
  enc_LootRift_03:AddWave({
    {
      spawners = "Spawn_Witch00_Flyers",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Spawn_Witch10_Poison",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Spawn_Witch20_Ice",
      spawnPattern = "Random",
      spawnWad = "Nid999_ValkyrieAI",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  enc_LootRift_03:OnComplete(Stop_FightRift_03)
  enc_LootRift_03:OnComplete(function()
    LD.SetMarkerState("Nif_400_RealmTear03", 0)
  end)
  enc_LootRift_03:OnStart(function()
    GameObjects.PktRft_Spawn_A.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Spawn_A.LuaObjectScript.SpawningDone()
    end, 4)
  end, 1)
  enc_LootRift_03:OnStart(function()
    GameObjects.PktRft_Spawn_B.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Spawn_B.LuaObjectScript.SpawningDone()
    end, 6)
  end, 1)
  enc_LootRift_03:OnStart(function()
    GameObjects.PktRft_Spawn_C.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PktRft_Spawn_C.LuaObjectScript.SpawningDone()
    end, 5)
  end, 1)
  enc_LootRift_03:OnEnemySpawn(function()
    GameObjects.PktRft_Spawn_A.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 1})
  enc_LootRift_03:OnEnemySpawn(function()
    GameObjects.PktRft_Spawn_B.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 1})
  enc_LootRift_03:OnEnemySpawn(function()
    GameObjects.PktRft_Spawn_C.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 1})
end
function PocketRift_Cbt_CallBack_03()
  GameObjects.RespawnRift03Safety:ShowEntityVolume()
  timers.StartLevelTimer(2, function()
    enc_LootRift_03:Start()
  end)
  timers.StartLevelTimer(2, function()
    GameObjects.misc_legendary_tier6_nid400_1.LuaObjectScript.SpawningDone()
  end)
end
function RespawnRift03Fight()
  if enc_LootRift_03 ~= nil and enc_LootRift_03:IsRunning() == true then
    EncounterExplodeAI_enc03()
    enc_LootRift_03:DespawnEnemies()
    enc_LootRift_03:Reset()
    GameObjects.misc_legendary_tier6_nid400_1.LuaObjectScript.ResetCombatState()
  end
end
function EncounterExplodeAI_enc03()
  local minTime = 0
  local maxTime = 0.2
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies1 = enc_LootRift_03:GetActiveEnemies()
  for _, enemy in pairs(enemies1) do
    if enemy ~= nil then
      local enemyLastPos = enemy:GetWorldJointPosition(enemy:GetJointIndex("JOPelvis1"))
      timers.StartLevelTimer(randomFn(), function()
        local enemyVFX = game.FX.Spawn("BloodExplode", nil, {
          AutoDelete = true,
          EffectCreator = enemy,
          Scale = 1.5
        })
        enemyVFX:SetWorldPosition(enemyLastPos)
      end)
    end
  end
end
function IncrementTrophyCounter()
  game.Wallets.AddResource("HERO", "NiflheimTrophyTracker", 1)
  if game.Wallets.GetResourceValue("HERO", "NiflheimTrophyTracker") == 27 then
    game.UnlockTrophy(35)
  end
  game.IncrementTrophyCounter(35, 27)
end
function Stop_FightRift_01()
  GameObjects.misc_legendary_tier4_nid400_1.LuaObjectScript.StopCombatState()
  GameObjects.RespawnRift01Safety:HideEntityVolume()
  LD.CallFunctionAfterDelay(function()
    PlayBanter_RiftComplete()
  end, 3)
end
function Stop_FightRift_02()
  if enc_LootRift_02:IsComplete() and enc_LootRift_02_Support_Pwr:IsComplete() and enc_LootRift_02_Support_Spd:IsComplete() then
    GameObjects.misc_legendary_tier5_nid400_1.LuaObjectScript.StopCombatState()
    GameObjects.RespawnRift02Safety:HideEntityVolume()
    LD.CallFunctionAfterDelay(function()
      PlayBanter_RiftComplete()
    end, 3)
    LD.SetMarkerState("Nif_400_RealmTear02", 0)
    game.World.StoreCheckpoint()
  end
end
function Stop_FightRift_03()
  GameObjects.misc_legendary_tier6_nid400_1.LuaObjectScript.StopCombatState()
  GameObjects.RespawnRift03Safety:HideEntityVolume()
  LD.CallFunctionAfterDelay(function()
    PlayBanter_RiftComplete()
  end, 3)
end
