local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local camShakeLarge = {
  EffectName = "FSE_shake_temp_Generic_Large",
  Duration = 1
}
local ForceFeedbackRumble = {
  EffectName = "FFB_HEAVY_ATTACK",
  Duration = 1
}
local SpinSpeed = 0
local SpeedIncrease_onHit = 1.1
local SubsequentHitModifier = 0.8
local SpinWheel1, SpinWheel2, SpinWheel3, BellObj1, BellObj2, BellObj3
function OnScriptLoaded(level, obj)
  BellObj1 = level:GetGameObject("SpinnerBell_01")
  BellObj1:FindSingleGOByName("BellTargetFront").LuaObjectScript.RegisterHitCallback(RingBell1CCW)
  BellObj1:FindSingleGOByName("BellTargetBack").LuaObjectScript.RegisterHitCallback(RingBell1CW)
  BellObj2 = level:GetGameObject("SpinnerBell_02")
  BellObj2:FindSingleGOByName("BellTargetFront").LuaObjectScript.RegisterHitCallback(RingBell2CCW)
  BellObj2:FindSingleGOByName("BellTargetBack").LuaObjectScript.RegisterHitCallback(RingBell2CW)
  BellObj3 = level:GetGameObject("SpinnerBell_03")
  BellObj3:FindSingleGOByName("BellTargetFront").LuaObjectScript.RegisterHitCallback(RingBell3CCW)
  BellObj3:FindSingleGOByName("BellTargetBack").LuaObjectScript.RegisterHitCallback(RingBell3CW)
  SpinWheel1 = level:GetGameObject("Wheel_01")
  SpinWheel2 = level:GetGameObject("Wheel_02")
  SpinWheel3 = level:GetGameObject("Wheel_03")
end
function RingBell1CW()
  HitClockwise(SpeedIncrease_onHit)
end
function RingBell1CCW()
  HitCounterClockwise(SpeedIncrease_onHit)
end
function RingBell2CW()
  HitClockwise(SpeedIncrease_onHit)
end
function RingBell2CCW()
  HitCounterClockwise(SpeedIncrease_onHit)
end
function RingBell3CW()
  HitClockwise(SpeedIncrease_onHit)
end
function RingBell3CCW()
  HitCounterClockwise(SpeedIncrease_onHit)
end
function HitClockwise(increase)
  if SpinSpeed < 0.02 then
    SpinSpeed = SpinSpeed + increase
  else
    SpinSpeed = SpinSpeed + increase * SubsequentHitModifier
  end
  UpdateSpin()
end
function HitCounterClockwise(increase)
  if 0.02 < SpinSpeed then
    SpinSpeed = SpinSpeed - increase
  else
    SpinSpeed = SpinSpeed - increase * SubsequentHitModifier
  end
  UpdateSpin()
end
function UpdateSpin()
  if SpinSpeed ~= 0 then
    if 0.02 < SpinSpeed then
      SpinSpeed = SpinSpeed - 0.02
    elseif SpinSpeed < -0.02 then
      SpinSpeed = SpinSpeed + 0.02
    else
      SpinSpeed = 0
    end
    SpinWheel1:PlayAnimCycle(SpinSpeed)
    SpinWheel2:PlayAnimCycle(SpinSpeed)
    SpinWheel3:PlayAnimCycle(SpinSpeed)
    timers.StartLevelTimer(0.5, UpdateSpin)
  end
end
function CutSpeed()
  ShakeRumble()
  if SpinSpeed ~= 0 then
    SpinSpeed = SpinSpeed / 2
    SpinWheel1:PlayAnimCycle(SpinSpeed)
    SpinWheel2:PlayAnimCycle(SpinSpeed)
    SpinWheel3:PlayAnimCycle(SpinSpeed)
  end
end
function ShakeRumble()
  game.FX.SubmitEffect(camShakeLarge)
  game.FX.SubmitEffect(ForceFeedbackRumble)
end
