local LD = require("design.LevelDesignLibrary")
function OnScriptLoaded(level)
  game.Audio.StartMusicMaster("SND_MX_PEAK_start_master")
end
function OnFirstStart(level)
end
local SND100Door, SND100Crawl
function SoundInit()
  SND100Door = GameObjects.SNDGrpPeak100_2:FindSingleSoundEmitterByName("SND100Door")
  SND100Crawl = GameObjects.SNDGrpEntPeak100_3:FindSingleSoundEmitterByName("SND100Crawl")
end
function statueEntranceMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 263 and game.Level.GetVariable("CompletedCineNumber") < 267 then
    game.Audio.StartMusic("SND_MX_PEAK_statue_entrance")
  end
  revisitMusic()
end
function cavernsEnterMusic()
  game.Audio.StartMusic("SND_MX_PEAK_caverns_enter")
  LD.PlaySound(SND100Door, "SND_AMB_Bed_Cavern_Airy_Whoosh_Peak120")
end
function crawlEnterMusic()
  game.Audio.StartMusic("SND_MX_PEAK_caverns_crawl")
end
function behindStatueMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_PEAK_statue_backside")
  LD.PlaySound(SND100Crawl, "SND_AMB_Bed_Cavern_Airy_Whoosh_Peak100")
end
function climbEnterMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 263 and game.Level.GetVariable("CompletedCineNumber") < 267 then
    game.Audio.StartMusic("SND_MX_PEAK_climb_to_chimney")
  end
end
function rollerEnterMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_PEAK_chimneylow_puzzle_in")
end
function bossCaveEnterMusic()
  game.Audio.StartMusic("SND_MX_PEAK_dragon_boss_cave_in")
end
function bossCaveExitMusic()
  game.Audio.StartMusic("SND_MX_PEAK_dragon_boss_cave_out")
end
function mimirApproachMusic()
  game.Audio.StartMusic("SND_MX_PEAK_mimir_approach")
end
function revisitMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 490 and not game.FindLevel("Peak205_ChiselArena") then
    game.Audio.StartCheckpointedMusic("SND_MX_PEAK_revisit_explore_in")
  end
end
function musicChiselIn()
  musicIdle()
end
function musicChiselOut()
  if game.Level.GetVariable("CompletedCineNumber") >= 490 then
    game.Audio.StartCheckpointedMusic("SND_MX_PEAK_revisit_explore_in")
  end
end
function musicIdle()
  game.Audio.StartMusic("SND_MX_TRANS_TO_IDLE")
end
