local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, son, sonPuppeteer
local boolPlayElevatorUnstableAnim = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
end
function OnStart(level, obj)
  BuildElevatorUnstableSequence()
end
function BuildElevatorUnstableSequence()
  local elevatorUnstableSeq = LD.CreateCineSequence(thisLevel, thisObj, "POI_ElevatorUnstable")
  elevatorUnstableSeq:WaitForFunctionTrue(function()
    return boolPlayElevatorUnstableAnim
  end)
  elevatorUnstableSeq:Do(PlayUnstableElevatorSequence)
  elevatorUnstableSeq:StartSequence()
end
function PlayUnstableElevatorSequence()
  sonPuppeteer = game.Puppeteer.NewForce(thisObj, "POI_UnstableElevator", son)
  sonPuppeteer:StartMove("MOV_ElevatorUnstableEnter")
  sonPuppeteer:OnComplete(CleanupPuppeteer)
end
function CleanupPuppeteer()
  if sonPuppeteer ~= nil then
    sonPuppeteer:DetachPuppet()
    sonPuppeteer = nil
  end
end
function OnUseWorld(level, obj)
end
function StartSonPOI()
  boolPlayElevatorUnstableAnim = true
end
