local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local cineEnterCamera_RopeStuckA, thisObj, thisLevel, sonActor, kratosActor, liftClaw, counterWeight, monolithStone, liftMechanics, wheelCrank
local ropeStuckAStarted = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function StartCineEnter_RopeStuckA()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_RopeStuckA = CCEC.CineEnterCamera.New("ENV_CineEnter_RopeStuckA", 7)
  cineEnterCamera_RopeStuckA:SetCallback(DestroyCineEnter_RopeStuckA)
  cineEnterCamera_RopeStuckA:Start()
end
function DestroyCineEnter_RopeStuckA()
  cineEnterCamera_RopeStuckA = nil
  game.SubObject.Sleep(thisObj)
end
function OnUpdate()
  if cineEnterCamera_RopeStuckA ~= nil then
    cineEnterCamera_RopeStuckA:Update()
  end
end
function PopulateVariables()
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  liftClaw = GameObjects.liftClaw00_P.Child
  counterWeight = GameObjects.liftCounterweight00_P.Child
  monolithStone = GameObjects.monolithStone00_P.Child
  liftMechanics = GameObjects.liftMechanics00_P.Child
  wheelCrank = GameObjects.WheelCrank_PeaksPass.Child
end
function BuildRopeStuckASeq()
  ropeStuckAStarted = true
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "RopeStuckA")
  local axeCheckSeq = ND.CreateCineSequence(thisLevel, thisObj, "axeCheckSeq")
  PopulateVariables()
  local actorTable = {
    {Actor = sonActor},
    {
      Obj = GameObjects.animDriver_Cine
    },
    {
      Obj = liftClaw,
      Anim = "poiPeakRopeStuckA"
    },
    {
      Obj = counterWeight,
      Anim = "poiPeakRopeStuckA1"
    },
    {
      Obj = monolithStone,
      Anim = "poiPeakRopeStuckA"
    },
    {
      Obj = liftMechanics,
      Anim = "poiPeakRopeStuckA"
    }
  }
  seq:SetPostSkipMusic("SND_MX_PEAK_start_master")
  seq:MarkAbleToSkip()
  seq:RequestCineModeAndWait(kratosActor, thisObj)
  seq:Do(StartCineEnter_RopeStuckA)
  seq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_RopeStuckA",
    ReferenceJoint = "RopeStuckA_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = true,
    prevent_path_eval = true,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  seq:ActorSync(kratosActor, {
    Slaves = actorTable,
    Branch = "BRA_RopeStuckA",
    ReferenceJoint = "RopeStuckA_SynchJoint"
  })
  seq:Do(PlayBreakPlatformAndStartFX)
  seq:Do(AnimSyncCrank)
  seq:BranchSequence(axeCheckSeq)
  axeCheckSeq:WaitUntilActorAnimPastPercentage(sonActor, 0.31)
  axeCheckSeq:Do(AxeUnembedCheck)
  seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  seq:SetCompletedCineNumber(267)
  seq:Do(function()
    GameObjects.NoGoZone_RopeStuckA_NavObstacle:Hide()
    local peak200 = game.FindLevel("peak200_ChimneyLow")
    peak200:CallScript("IdleContextZone_Switch")
  end)
  seq:Do(StopAnimSyncCrank)
  seq:StopPuppetingActor(sonActor)
  seq:StopPuppetingActor(kratosActor)
  seq:Do(ForceCrankSync)
  seq:Do(PeaksObj200)
  seq:StartSequence()
end
function AxeUnembedCheck()
  GameObjects.CrankSetupManager.LuaObjectScript.ForceRemoveAxeFromGears()
end
function PeaksObj200()
  game.QuestManager.ProposeQuestState("Quest_PeaksPass_Objective200", "Complete")
end
function PlayBreakPlatformAndStartFX()
  GameObjects.platform_rock_weight_break.Child:PlayAnimToEnd()
  LD.ShowFX(GameObjects.poiPeakRopeStuckA_FX)
  GameObjects.Collision_CollapseWall_Pristine:HideCollision()
  GameObjects.Collision_CollapseWall_Broken1:ShowCollision()
end
function AnimSyncCrank()
  game.GameObject.AnimSync(wheelCrank, liftMechanics, 1)
  LD.CallFunctionAfterDelay(function()
    GameObjects.CrankSetupManager.LuaObjectScript.SetState_SonCollapseCrank()
  end, 11)
end
function StopAnimSyncCrank()
  game.GameObject.AnimSync(wheelCrank)
  GameObjects.CrankSetupManager.LuaObjectScript.SetState_PostCollapse()
end
function ForceCrankSync()
  GameObjects.WheelCrank_PeaksPass.LuaObjectScript.DisablePlayerInput()
  LD.CallFunctionAfterDelay(function()
    GameObjects.WheelCrank_PeaksPass.LuaObjectScript.EnablePlayerInput()
  end, 0.5)
  GameObjects.WheelCrank_PeaksPass.LuaObjectScript.RequestInteractOverride("BRA_WheelCrank_EnterToIdleImmediate")
end
function PlayRopestuckBanter01()
  game.Audio.PlayBanter("163_CrackHints01")
end
function PlayRopestuckBanter02()
  game.Audio.PlayBanter("163_CrackHints02")
end
function CrankHints_Banter()
  timer.StartLevelTimer(45, function()
    if not ropeStuckAStarted then
      game.Audio.PlayBanterNonCritical("163_CrankHints01")
    end
  end)
  timer.StartLevelTimer(95, function()
    if not ropeStuckAStarted then
      game.Audio.PlayBanterNonCritical("163_CrankHints02")
    end
  end)
end
