LD = require("design.LevelDesignLibrary")
monitors = require("level.MonitorLibrary")
timer = require("level.timer")
local camCollisionCheck = require("camera.collisioncheck")
checkpoint = require("level.checkpoint")
thisObj = nil
player = nil
son = nil
thisLevel = nil
local camIsInFrame, sonTrackObject
local sonTrackTimer = timer.StartLevelTimer(1.8)
sonTrackTimer:Stop()
local craneStartedTimer = timer.StartLevelTimer(0.6)
craneStartedTimer:Stop()
local clawTrackTimer = timer.StartLevelTimer(6)
clawTrackTimer:Stop()
local finalCrankCamera, finalCrankCameraDriver
local trackingSon = false
local trackingSonFired = false
local bCartSuperHint = false
local beastInspected = false
local skyLanternFound = false
local recenter_ChainPull_DoorCart = {
  TimeStart = 0,
  TimeDuration = 2.4,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = -8,
  ReturnLeft = -10,
  ReturnRight = -12,
  TriggerRight = -14,
  PitchRange = -1,
  TriggerUp = -14,
  ReturnUp = -16,
  ReturnDown = -18,
  TriggerDown = -20
}
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  thisLevel = level
  sonTrackObject = level:GetGameObject("CamTargTempSon")
  finalCrankCamera = level:GetGameObject("ENV_CC_SolveItPullIt")
  finalCrankCameraDriver = level:GetGameObject("liftCounterweight00_P")
  game.GameObject.AnimSync(finalCrankCamera, finalCrankCameraDriver)
  SoundInit()
  GameObjects.ChainPull_DoorCart.LuaObjectScript.OverrideDefaultCameraRecenter(true, recenter_ChainPull_DoorCart)
  GameObjects.ChainPull_DoorCart.LuaObjectScript.OverrideDefaultCameraPitch(true, -17)
  GameObjects.ChainPull_DoorCart.LuaObjectScript.OverrideDefaultCameraYaw(true, -100)
end
function OnFirstStart(level)
  GameObjects.Zone_CA_ReturnBridge:HideEntityVolume()
  LD.HideFX(GameObjects.poiPeakRopeStuckA_FX)
  LeadTheWay_200CartGateOpen_Disable()
  GameObjects.Btr_Cart_LookAt:HideEntityVolume()
  GameObjects.NavObstacle_Cart_IsUp:HideNavObstacle()
end
function OnStart(level)
  SoundOnStart()
  if game.Level.GetVariable("CompletedCineNumber") > 270 then
    SCA_BrokenLantern02_Disable()
  end
  if game.Level.GetVariable("CompletedCineNumber") < 310 then
    GameObjects.Machine_01_broken:Hide()
  else
    GameObjects.Machine_01_broken:Show()
    GameObjects.liftMechanics00_P:Hide()
    GameObjects.liftMechanics00_P.Child:FindSingleGOByName("WheelCrank_PeaksPass").Child.LuaObjectScript.Disable()
    GameObjects.SCA_CrankStandby.LuaObjectScript.Disable()
    GameObjects.Zone_CrankStandBy_Toggle:HideEntityVolume()
    SCA_BackCornerSecret_Disable()
    GameObjects.liftCounterweight00_P.Child:JumpAnimToFrame(0)
    GameObjects.liftCounterweight00_P.Child:PauseAnim()
    GameObjects.NavObstacle_Cart_IsUp:HideNavObstacle()
  end
end
function OnUpdate(level)
  if game.World.IsInsideCameraZone(player.WorldPosition, "ZoneCamCrankKidWalk") and game.Level.GetVariable("craneState") == 0 then
    if craneStartedTimer.running == false then
      craneStartedTimer:Start()
    end
    if craneStartedTimer.fired == true then
      clawTrackTimer:Start()
    end
    camIsInFrame = camCollisionCheck.isTargetInFrustumUnobstructed(sonTrackObject:GetWorldPosition(), 0, 0, 0.1, false)
    if camIsInFrame == true then
      if sonTrackTimer.running == false then
        sonTrackTimer:Start()
        trackingSon = true
      end
      if trackingSon == true and sonTrackTimer.fired == false then
        game.Camera.SubmitCameraByName("PLYR_Interactive_ChainPull_Peak200_Stage0")
      end
    end
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "ZoneCamCrankStage01") and player:HasMarker("Cranking") and game.Level.GetVariable("craneState") == 1 then
    game.Camera.SubmitCameraByName("PLYR_Interactive_ChainPull_Peak200_Stage1_Stuck")
  end
  if clawTrackTimer.running == true and clawTrackTimer.fired == false and game.World.IsInsideCameraZone(player.WorldPosition, "ZoneCamCrankKidWalk") then
    game.Camera.SubmitCameraByName("ENV_CC_WeightExchange")
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "ZoneCamCrankStage01") and player:HasMarker("Cranking") and game.Level.GetVariable("craneState") == 2 then
    game.Camera.SubmitCameraByName("ENV_CC_SolveItPullIt")
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "ZoneRollerOutsideFinalPosition") and bCartSuperHint == false and player:HasMarker("Cranking") then
    bCartSuperHint = true
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "ZoneRollerOutsideHint") then
    game.Camera.SubmitCameraByName("PLYR_Peak_RollerPush_030_SuperHint")
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "ZoneDoorSwitchRENO") and player:HasMarker("Cranking") then
    local cart = GameObjects.Door_Cart
    if cart.AnimFrame > 75 then
      game.Camera.SubmitCameraByName("PLYR_Crank_Chain_Peak200_GateOpen_HINT")
    end
  end
end
function LoadCheck_Peak380()
  game.UI.LoadCheck("Peak380_BigElevator")
end
function BrokenLantern_SonUnavailable()
  local peak200 = game.FindLevel("peak200_ChimneyLow")
  peak200:CallScript("BrokenLantern_SonUnavailable200")
end
function BrokenLantern_SonAvailable()
  local peak200 = game.FindLevel("peak200_ChimneyLow")
  peak200:CallScript("BrokenLantern_SonAvailable200")
end
function BoulderPushed()
  PeaksObj250()
  game.Level.SetVariable("PEAK_BoulderPushed", true)
end
function PeaksObj250()
  LD.CompleteQuest("Quest_PeaksPass_Objective250")
end
function RopeDrop_Enable_200()
  local peak200 = game.FindLevel("peak200_ChimneyLow")
  peak200:CallScript("RopeDrop_Enable")
  print("ENABLE ROPE FROM 080")
end
function CartClawElevatorON()
  if GameObjects.CrankSetupManager.LuaObjectScript.GetState() == GameObjects.CrankSetupManager.LuaObjectScript.STATE_CART_ATTACHED then
    GameObjects.pushCart00_P.Child:FindSingleGOByName("Col_ExitWall"):ShowCollision()
    GameObjects.pushCart00_P.Child:FindSingleGOByName("Col_StaticWalls"):ShowCollision()
    GameObjects.pushCart00_P.Child:FindSingleGOByName("TraversePath_BuddyBoost"):HideTraversePath()
    GameObjects.pushCart00_P.Child:FindSingleGOByName("TraversePath_BuddyDrop"):ShowTraversePath()
    SCA_CartRideUpElevator_Ready_Disable()
    GameObjects.pushCart00_P.Child:FindSingleGOByName("SCA_CartClaw_OnTop").LuaObjectScript.Enable()
    game.Compass.SetDesignerForcedHide(true)
  end
end
function CartClawElevatorOFF()
  GameObjects.pushCart00_P.Child:FindSingleGOByName("Col_ExitWall"):HideCollision()
  GameObjects.pushCart00_P.Child:FindSingleGOByName("Col_StaticWalls"):HideCollision()
  GameObjects.pushCart00_P.Child:FindSingleGOByName("TraversePath_BuddyBoost"):ShowTraversePath()
  GameObjects.pushCart00_P.Child:FindSingleGOByName("TraversePath_BuddyDrop"):HideTraversePath()
  GameObjects.SCA_CartRideUpElevator_Ready.LuaObjectScript.Enable()
  GameObjects.pushCart00_P.Child:FindSingleGOByName("SCA_CartClaw_OnTop").LuaObjectScript.Disable()
  game.Compass.SetDesignerForcedHide(false)
end
function SkyLanternFound()
  skyLanternFound = true
  SCA_GateChainArea_Enable()
end
function Btr_Cart_LookAt_Enable()
  GameObjects.Btr_Cart_LookAt:ShowEntityVolume()
end
function DisableSummon()
  son:AddMarker("DisableSummon")
end
function EnableSummon()
  son:RemoveMarker("DisableSummon")
end
function SCA_BeastInspect_Triggered()
  beastInspected = true
end
function SCA_BeastInspect_Enable()
  if beastInspected == false then
    GameObjects.SCA_BeastInspect.LuaObjectScript.Enable()
  end
end
function SCA_BeastInspect_Disable()
  GameObjects.SCA_BeastInspect.LuaObjectScript.Disable()
end
function SCA_TrackInvestigate_Disable()
  GameObjects.SCA_TrackInvestigate.LuaObjectScript.Interrupt()
  GameObjects.SCA_TrackInvestigate.LuaObjectScript.Disable()
end
function SCA_ClawInvestigate_Disable()
  GameObjects.SCA_ClawInvestigate.LuaObjectScript.Interrupt()
  GameObjects.SCA_ClawInvestigate.LuaObjectScript.Disable()
end
function SCA_BrokenLantern02_Enable()
  if skyLanternFound == false then
    GameObjects.SCA_BrokenLantern02.LuaObjectScript.Enable()
  end
end
function SCA_BrokenLantern02_Disable()
  GameObjects.SCA_BrokenLantern02.LuaObjectScript.Disable()
end
function SCA_DebrisLift_NavHelper_Enable()
  GameObjects.SCA_DebrisLift_NavHelper.LuaObjectScript.Enable()
end
function SCA_OneWayGate_NavHelper_Enable()
  GameObjects.SCA_OneWayGate_NavHelper.LuaObjectScript.Enable()
end
function SCA_GateChainArea_Enable()
  if skyLanternFound == true then
    GameObjects.SCA_GateChainArea.LuaObjectScript.Enable()
  end
end
function SCA_GateChainArea_Disable()
  GameObjects.SCA_GateChainArea.LuaObjectScript.Disable()
end
function SCA_MonolithStone_Enable()
  GameObjects.SCA_MonolithStone.LuaObjectScript.Enable()
end
function SCA_MonolithStone_Disable()
  GameObjects.SCA_MonolithStone.LuaObjectScript.Disable()
end
function SCA_GateLookThru_Disable()
  GameObjects.SCA_GateLookThru.LuaObjectScript.Disable()
end
function SCA_CartRideUpElevator_Ready_Enable()
  GameObjects.SCA_CartRideUpElevator_Ready.LuaObjectScript.Enable()
end
function SCA_CartRideUpElevator_Ready_Disable()
  GameObjects.SCA_CartRideUpElevator_Ready.LuaObjectScript.Disable()
end
function SCA_BackCornerSecret_Disable()
  GameObjects.SCA_BackCornerSecret.LuaObjectScript.Interrupt()
  GameObjects.SCA_BackCornerSecret.LuaObjectScript.Disable()
  GameObjects.SCA_ExpressElevator_Area.LuaObjectScript.Disable()
end
function CA_Observe_RuneRead_Disable_080()
  GameObjects.CA_Observe_RuneRead.LuaObjectScript.Disable()
end
function LeadTheWay_210LowFloor_Enable()
  GameObjects.LeadTheWay_210LowFloor.LuaObjectScript.Enable()
end
function LeadTheWay_210LowFloor_Disable()
  GameObjects.LeadTheWay_210LowFloor.LuaObjectScript.Disable()
end
function LeadTheWay_210TopRoom_Enable()
  GameObjects.LeadTheWay_210TopRoom.LuaObjectScript.Enable()
end
function LeadTheWay_210TopRoom_Disable()
  GameObjects.LeadTheWay_210TopRoom.LuaObjectScript.Disable()
end
function LeadTheWay_210CartUpDownA_Enable()
  GameObjects.LeadTheWay_210CartUpDownA.LuaObjectScript.Enable()
end
function LeadTheWay_210CartUpDownA_Disable()
  GameObjects.LeadTheWay_210CartUpDownA.LuaObjectScript.Disable()
end
function LeadTheWay_210CartUpDownB_Enable()
  GameObjects.LeadTheWay_210CartUpDownB.LuaObjectScript.Enable()
end
function LeadTheWay_210CartUpDownB_Disable()
  GameObjects.LeadTheWay_210CartUpDownB.LuaObjectScript.Disable()
end
function LeadTheWay_210HallwayToChain_Enable()
  GameObjects.LeadTheWay_210HallwayToChain.LuaObjectScript.Enable()
  print("LIFT SIDE A")
end
function LeadTheWay_210HallwayToChain_Disable()
  GameObjects.LeadTheWay_210HallwayToChain.LuaObjectScript.Disable()
  print("LIFT SIDE B")
end
function LeadTheWay_200CartJumpA_Enable()
  GameObjects.LeadTheWay_200CartJumpA.LuaObjectScript.Enable()
end
function LeadTheWay_200CartJumpA_Disable()
  GameObjects.LeadTheWay_200CartJumpA.LuaObjectScript.Disable()
end
function LeadTheWay_200CartJumpB_Enable()
  GameObjects.LeadTheWay_200CartJumpB.LuaObjectScript.Enable()
end
function LeadTheWay_200CartJumpB_Disable()
  GameObjects.LeadTheWay_200CartJumpB.LuaObjectScript.Disable()
end
function LeadTheWay_200CartGateClosed_Enable()
  GameObjects.LeadTheWay_GateClosed.LuaObjectScript.Enable()
end
function LeadTheWay_200CartGateOpen_Enable()
  GameObjects.LeadTheWay_GateClosed.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_200CartGateOpen.LuaObjectScript.Enable()
end
function LeadTheWay_200CartGateOpen_Disable()
  GameObjects.LeadTheWay_200CartGateOpen.LuaObjectScript.Disable()
end
function LeadTheWay_200PathTo260_Enable()
  GameObjects.LeadTheWay_200PathTo260.LuaObjectScript.Enable()
end
function Son_LeadTheWay_Disable()
  GameObjects.LeadTheWay.LuaObjectScript.Disable()
  print("Lead the Way Disable")
end
function GoUp_Lvl2()
  Enable_SCA_GoUp_Lvl2()
  SCA_BeastInspect_Disable()
  Disable_SCA_GoDown_Lvl1()
  Enable_Zone_GoDown_Lvl1()
  Disable_Zone_GoUp_Lvl2()
  SCA_GateChainArea_Enable()
  print("KRATOS UP TOP > SON FOLLOW UP")
end
function GoDown_Lvl1()
  Enable_SCA_GoDown_Lvl1()
  Disable_SCA_GoUp_Lvl2()
  SCA_BeastInspect_Enable()
  Enable_Zone_GoUp_Lvl2()
  SCA_GateChainArea_Disable()
  print("KRATOS DOWN BELOW > SON FOLLOW DOWN")
end
function GoOver_Bridge()
  Disable_SCA_GoUp_Lvl2()
  GameObjects.Zone_CA_ReturnBridge:ShowEntityVolume()
  GameObjects.Zone_CA_OverBridge:HideEntityVolume()
  print("GO OVER BRIDGE")
end
function GoOver_ReturnBridge()
  Enable_SCA_GoUp_Lvl2()
  GameObjects.Zone_CA_ReturnBridge:HideEntityVolume()
  GameObjects.Zone_CA_OverBridge:ShowEntityVolume()
  print("GO RETURN BRIDGE")
end
function GoUp_Lvl2_Alt()
  SCA_BeastInspect_Disable()
  Disable_Zone_GoDown_Lvl1()
  SCA_GateChainArea_Enable()
  print("KRATOS UP TOP > SON FOLLOW UP ALT ALT ALT")
end
function GoDown_Lvl1_Alt()
  SCA_BeastInspect_Enable()
  Enable_Zone_GoUp_Lvl2()
  SCA_GateChainArea_Disable()
  print("KRATOS DOWN BELOW > SON FOLLOW DOWN ALT ALT ALT")
end
function Enable_Zone_GoUp_Lvl2()
  GameObjects.Zone_GoUp_Lvl2:ShowEntityVolume()
end
function Disable_Zone_GoUp_Lvl2()
  GameObjects.Zone_GoUp_Lvl2:HideEntityVolume()
end
function Enable_Zone_GoDown_Lvl1()
  GameObjects.Zone_GoDown_Lvl1:ShowEntityVolume()
  print("ENABLE GO DOWN ZONE")
end
function Disable_Zone_GoDown_Lvl1()
  GameObjects.Zone_GoDown_Lvl1:HideEntityVolume()
end
function Enable_SCA_GoDown_Lvl1()
end
function Enable_SCA_GoUp_Lvl2()
end
function Disable_SCA_GoUp_Lvl2()
end
function Disable_SCA_GoDown_Lvl1()
end
function RopeTugShake()
  game.FX.SubmitEffect({
    EffectName = "FSE_SWAY_ROPETUG",
    Duration = 1
  })
end
function PlayRopeTugShake()
  timer.StartLevelTimer(0.3, RopeTugShake)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    skyLanternFound = skyLanternFound,
    beastInspected = beastInspected
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  skyLanternFound = savedInfo.skyLanternFound
  beastInspected = savedInfo.beastInspected
end
function Peak080_CraneCartPuzzleSolved()
  GameObjects.CrankSetupManager.LuaObjectScript.Debug_PuzzleSolved_CartAttached()
  GameObjects.Door_Cart:JumpAnimToFrame(GameObjects.Door_Cart.AnimLengthFrames)
  GameObjects.ChainPull_DoorCart.LuaObjectScript.Lock()
  GameObjects.RopeBreak:Hide()
  GameObjects.RopeBreak:HideCollision()
  GameObjects.Cart:Hide()
  GameObjects.Cart:HideCollision()
  GameObjects.platform_rock_weight_break:Hide()
  GameObjects.peak200_rock_slide_break:Hide()
  GameObjects.CollapseWall:HideCollision()
  GameObjects.InteractZone_SonReleaseCrank.Child.LuaObjectScript.Disable()
end
function Peak080_DisableCrank200()
  GameObjects.CrankSetupManager.LuaObjectScript.Debug_Crank_Lock()
end
function ChainOnPauseEvent()
  PlayDoorCartStopSound()
end
local ropeSoundEmitter, RopeTautAnimMonitor, RopeBreakAnimMonitor, doorCartEmitter
local soundTrilobyte02_Emitters = {}
local Door_CartSoundOverrides = {
  OnAttach = "",
  OnAttachFrame = -1,
  OnDetach = "",
  OnDetachFrame = -1,
  OnStart = "",
  OnStartFrame = -1,
  OnReturnToStart = "SND_DOOR_Gate_Wooden_Lift_Latch",
  OnReturnToStartFrame = -1,
  OnForward = "SND_DOOR_Gate_Wooden_Lift_LP",
  OnForwardFrame = -1,
  OnBackward = "SND_DOOR_Gate_Wooden_Lift_LP",
  OnBackwardFrame = -1,
  OnFastForward = "SND_DOOR_Gate_Wooden_Lift_LP",
  OnFastForwardFrame = -1,
  OnRewind = "SND_DOOR_Gate_Wooden_Lift_LP",
  OnRewindFrame = -1,
  OnStartFromEnd = "",
  OnStartFromEndFrame = -1,
  OnEnd = "SND_DOOR_Gate_Wooden_Lift_Latch",
  OnEndFrame = -1,
  OnStuckAtEnd = "",
  OnStuckAtEndFrame = -1,
  OnStuckAtStart = "",
  OnStuckAtStartFrame = -1,
  OnJammed = "",
  OnJammedFrame = -1,
  OnStuckWhileJammed = "",
  OnStuckWhileJammedFrame = -1,
  OnUnlocked = "",
  OnUnlockedFrame = -1,
  OnLocked = "",
  OnLockedFrame = -1,
  OnStuckWhileLocked = "",
  OnStuckWhileLockedFrame = -1
}
function SoundInit()
  local breakRope = GameObjects.pushCartRope00_P.Child
  ropeSoundEmitter = breakRope:FindSingleSoundEmitterByName("SNDRope")
  doorCartEmitter = GameObjects.Door_Cart:FindSingleSoundEmitterByName("SNDDoor_Cart")
  RopeTautAnimMonitor = monitors.CreateAnimFrameMonitor(breakRope)
  RopeBreakAnimMonitor = monitors.CreateAnimFrameMonitor(GameObjects.s_hook_breakable_Cart.Child)
  RopeTautAnimMonitor:OnFrameForward(30, PlayRopeTautSound)
  RopeBreakAnimMonitor:OnFrameForward(1, PlayRopeBreakSound)
end
function SoundOnStart()
  GameObjects.ChainPull_DoorCart.LuaObjectScript.DrivenObjectSoundSetup(Door_CartSoundOverrides)
  soundTrilobyte02_Emitters = GameObjects.TrilobyteGroup_02.SoundEmitters
end
function PlayRopeTautSound()
  if not game.Level.GetVariable("PEAK_RopeBroken") then
    LD.PlaySound(ropeSoundEmitter, "SND_MECH_Wooden_Cart_Large_PushPull_Stuck")
  end
end
function PlayRopeBreakSound()
  LD.PlaySound(ropeSoundEmitter, "SND_EVNT_Beast_Sled_Break_Leash")
  RopeTautAnimMonitor = nil
  RopeBreakAnimMonitor = nil
end
function PlayDoorCartStopSound()
  LD.PlaySound(doorCartEmitter, "SND_DOOR_Gate_Wooden_Lift_Stop")
end
function RopeBroken()
  GameObjects.TrilobyteGroup_02:PlayAnimToEnd()
  PlaySoundTrilobyteScurry_02()
end
function PlaySoundTrilobyteScurry_02()
  for _, v in ipairs(soundTrilobyte02_Emitters) do
    LD.PlaySound(v, "SND_AMB_EMIT_Bats_Squeak_OneOff")
  end
end
