local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local playedBtr = {
  played01 = false,
  played02 = false,
  played03 = false,
  played04 = false,
  played05 = false,
  played06 = false,
  played07 = false,
  played08 = false,
  played09 = false,
  played10 = false,
  solved02 = false,
  solved03 = false
}
local puzzleDone = false
local crystal01Lit = false
local crystal02Lit = false
local crystal01Socketed = true
local crystal02Socketed = false
local crystalFound = false
local ONE_SOCKETED = 0
local TWO_SOCKETED_UNLIT = 1
local TWO_SOCKETED_LIT = 2
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  local BreakablePlanks = level:FindSingleGameObject("BreakablePlanks"):FindSingleGOByName("Peak100_alcove_ceiling_up")
  if BreakablePlanks ~= nil then
    BreakablePlanks = BreakablePlanks:GetBreakable()
    if BreakablePlanks.Broken == true then
      crystalFound = true
    end
  end
end
function OnSaveCheckpoint(level, obj)
  return {playedBtr = playedBtr, puzzleDone = puzzleDone}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedBtr = savedInfo.playedBtr
  puzzleDone = savedInfo.puzzleDone
end
function PuzzleStagStatue_SandBowlHint_Banter()
  if not playedBtr.PuzzleStagStatue_SandBowlHint then
    game.Audio.PlayBanter("030_PuzzleStagStatue_SandBowlHint")
    playedBtr.PuzzleStagStatue_SandBowlHint = true
  end
end
function SandBowlHint_Cancel()
  GameObjects.BtrTimer_RuneBowlHint01.LuaObjectScript.Cancel()
end
function PuzzleStagStatue_Riddle_Banter()
  if not playedBtr.PuzzleStagStatue_Riddle then
    game.Audio.PlayBanter("030_PuzzleStagStatue_Riddle")
    playedBtr.PuzzleStagStatue_Riddle = true
  end
end
function PuzzleStagStatue_RiddleAfter_Banter()
  if not playedBtr.PuzzleStagStatue_RiddleAfter then
    game.Audio.PlayBanter("030_PuzzleStagStatue_RiddleAfter")
    playedBtr.PuzzleStagStatue_RiddleAfter = true
  end
end
function PuzzleStagStatue01_Banter()
  if not playedBtr.played01 and not playedBtr.played02 and not playedBtr.played03 and not playedBtr.played06 and not puzzleDone then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanterNonCritical("030_PuzzleStagStatue01")
      playedBtr.played01 = true
    end, 1)
  end
end
function PuzzleStagStatue02_Banter()
  if not playedBtr.played02 then
    playedBtr.played02 = true
    timers.StartLevelTimer(1, PuzzleStagStatue02_BanterActual)
  end
end
function PuzzleStagStatue02_BanterActual()
  if not puzzleDone then
    game.Audio.PlayBanterNonCritical("030_PuzzleStagStatue02")
  end
end
function BreakablePlanksDestroyed_Banter()
  crystalFound = true
  print("CRYSTAL FOUND")
end
function PuzzleStagStatue03_Banter()
  if not playedBtr.played03 and not puzzleDone then
    playedBtr.played03 = true
    timers.StartLevelTimer(1.5, PuzzleStagStatue03_BanterActual)
    if crystalFound == false then
      timers.StartLevelTimer(7, PuzzleStagStatue03b_BanterActual)
    end
  end
end
function PuzzleStagStatue03_BanterActual()
  if not puzzleDone then
    game.Audio.PlayBanterNonCritical("030_PuzzleStagStatue03")
  end
end
function PuzzleStagStatue03b_BanterActual()
  if not crystalFound then
    game.Audio.PlayBanterNonCritical("030_PuzzleStagStatue03b")
  end
end
function Should_PuzzleStagStatue06_Play()
  return not playedBtr.played06 and not playedBtr.played07 and not puzzleDone
end
function PuzzleStagStatue06_Played()
  playedBtr.played06 = true
end
function PlayPSS07()
  timers.StartLevelTimer(3, PuzzleStagStatue07_Banter)
end
function PuzzleStagStatue07_Banter()
  if not playedBtr.played07 and not puzzleDone then
    game.Audio.PlayBanterNonCritical("030_PuzzleStagStatue07", function()
      playedBtr.played07 = true
    end)
  end
end
function PuzzleStagStatue08_Banter()
  if not playedBtr.played08 and not puzzleDone then
    game.Audio.PlayBanterNonCritical("030_PuzzleStagStatue08")
    playedBtr.played08 = true
  end
end
function PuzzleStagStatue09_Banter()
  if not playedBtr.played09 then
    playedBtr.played09 = true
    timers.StartLevelTimer(1, PuzzleStagStatue09_BanterActual)
  end
end
function PuzzleStagStatue09_BanterActual()
  if not puzzleDone then
    game.Audio.PlayBanterNonCritical("030_PuzzleStagStatue09")
  end
end
function PuzzleStagStatue10_Banter()
  if not playedBtr.played10 and not puzzleDone then
    timers.StartLevelTimer(1, PuzzleStagStatue10_BanterActual)
    playedBtr.played10 = true
  end
end
function PuzzleStagStatue10_BanterActual()
  if not puzzleDone then
    game.Audio.PlayBanterNonCritical("030_PuzzleStagStatue10")
  end
end
function StagSandSolved01_Banter()
  if not puzzleDone then
    puzzleDone = true
    game.Audio.PlayBanterNonCritical("040_StagSandSolved01")
  end
end
function SonArrivesRuneBowl()
  StagSandSolved02_Banter()
end
function StagSandSolved02_Banter()
  if not playedBtr.solved02 then
    game.Audio.PlayBanter("040_StagSandSolved02")
    playedBtr.solved02 = true
  end
end
function StatueSpottingPlayed()
  playedBtr.statueSpotting = true
end
function ShouldLeavingAlreadyPlay()
  local verdict = _G.IsPuzzleEntered() == true and playedBtr.statueSpotting and not playedBtr.leavingAlready and game.Level.GetVariable("CompletedCineNumber") < 267
  if verdict then
    playedBtr.leavingAlready = true
  end
  return verdict
end
function CrankAtEnd()
  if not puzzleDone then
    if CheckPuzzleStatus() == ONE_SOCKETED then
      PuzzleStagStatue02_Banter()
    elseif CheckPuzzleStatus() == TWO_SOCKETED_UNLIT then
      PuzzleStagStatue09_Banter()
    elseif CheckPuzzleStatus() == TWO_SOCKETED_LIT then
      StagSandSolved01_Banter()
    end
  end
end
function CheckPuzzleStatus()
  if not (not crystal01Socketed or crystal02Socketed) or not crystal01Socketed and crystal02Socketed then
    return ONE_SOCKETED
  elseif crystal01Socketed and crystal02Socketed and (not crystal01Lit or not crystal02Lit) then
    return TWO_SOCKETED_UNLIT
  elseif crystal01Socketed and crystal02Socketed and crystal01Lit and crystal02Lit then
    return TWO_SOCKETED_LIT
  end
end
function Crystal01Socketed()
  crystal01Socketed = true
  if crystal02Socketed then
    PuzzleStagStatue08_Banter()
  end
end
function Crystal01Unsocketed()
  crystal01Socketed = false
  crystal01Lit = false
end
function Crystal02Socketed()
  crystal02Socketed = true
  if crystal01Socketed then
    PuzzleStagStatue08_Banter()
  end
end
function Crystal02Unsocketed()
  crystal02Socketed = false
  crystal02Lit = false
end
function Crystal01Lit()
  crystal01Lit = true
  PuzzleStagStatue03_Banter()
  if crystal02Lit then
    PuzzleStagStatue10_Banter()
  end
end
function Crystal02Lit()
  crystal02Lit = true
  PuzzleStagStatue03_Banter()
  if crystal01Lit then
    PuzzleStagStatue10_Banter()
  end
end
