local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, kraActor, sonActor, modiActor
local modiReturnsZoneStr = "CineZone_ModiReturns"
local modiSpawnZoneStr = "CineZone_ModiSpawn"
local synchJointStr = "ModiReturns_SynchJoint"
local kraStartJointStr = "Kra_StartJoint"
local sonStartJointStr = "Son_StartJoint"
local modiStartJointStr = "Modi_StartJoint"
local modiReturnsIdleBranchStr = "BRA_ModiReturnsIdle"
local modiReturnsBranchStr = "BRA_ModiReturnsCine"
local cameraCineEnter, cine_lights_460
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.SetForgetOnCheckpoint(thisObj)
  player = game.Player.FindPlayer()
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_Peak100_StairwayToModi", 7.3, nil)
  cameraCineEnter:SetObjectToSleep(obj)
end
function OnStart(level, obj)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 460 and 450 <= cineNum then
    SetupActors()
    SetupCineSequence()
  end
  if CanSeqFire() == true then
    HideCameraZones()
  end
  GameObjects.NoGo_ModiReturns:Hide()
  cine_lights_460 = GameObjects.Cine_Start_460
  HideCineLights()
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("MODI RETURNS: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("MODI RETURNS: Son Actor", game.AI.FindSon)
  modiActor = actor.Actor.New("MODI RETURNS: Modi Actor")
  modiActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_ModiReturns", "Modi_StartJoint", "CRT_Modi00", "BRA_Spawn", "Modi")
  end)
  SpawnModi()
end
function SpawnModi()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Spawn Modi")
  cineSeq:SpawnActorAndWait(modiActor)
  cineSeq:ActorSync(modiActor, {
    Branch = "BRA_ModiReturnsIdle",
    ReferenceJoint = synchJointStr
  })
  cineSeq:StartSequence()
end
function SetupCineSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Modi Returns Sequence")
  local slaveTab = {
    {Actor = sonActor},
    {Actor = modiActor}
  }
  local kraJointFace = thisObj:GetWorldJointForward(thisObj:GetJointIndex(kraStartJointStr))
  local kraJointPos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex(kraStartJointStr))
  cineSeq:SetPostSkipMusic("SND_MX_PEAK_start_master", nil, nil, nil, nil, "SND_MX_PEAK2_explore1_in")
  cineSeq:WaitForFunctionTrue(CanSeqFire)
  cineSeq:Do(function()
    GameObjects.NoGo_ModiReturns:Show()
    LD.UnlockMagniModiBoatLore()
    LD.UnlockGoodFellowsBoatLore()
  end)
  cineSeq:WaitForActorInZone(kraActor, modiSpawnZoneStr)
  cineSeq:Do(function()
    game.Wallets.AddResource("HERO", "SonKnifeUnlock2", 1, "NO_TELEMETRY")
  end)
  cineSeq:WaitForActorInZone(kraActor, modiReturnsZoneStr)
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:Do(function()
    cineSeq:MarkAbleToSkip()
  end)
  cineSeq:Do(StartPreCineCamera)
  cineSeq:Do(PlayCineLights)
  cineSeq:Do(function()
    game.Player.FindPlayer():SetAccelerationOverride(1.2)
  end)
  cineSeq:Do(function()
    game.Player.FindPlayer():SetDecelerationOverride(1.2)
  end)
  cineSeq:Do(HeroDropCrystal)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = modiReturnsBranchStr,
    ReferenceJoint = synchJointStr,
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius,
    weapon_state = "bare"
  })
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = modiReturnsBranchStr,
    ReferenceJoint = synchJointStr
  })
  cineSeq:WaitForActorFinishMove(sonActor, "MOV_ModiReturnsCine")
  cineSeq:StopPuppetingActor(modiActor)
  cineSeq:DespawnActor(modiActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:Do(function()
    timers.StartLevelTimer(0.25, function()
      game.AI.FindSon():CallScript("EnterBehaviorContext", "FRUSTRATED_CONTEXT_CONFIG")
    end)
  end)
  cineSeq:Do(ShowCameraZones)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:Do(function()
    GameObjects.NoGo_ModiReturns:Hide()
  end)
  cineSeq:Do(function()
    game.Player.FindPlayer():ClearAccelerationOverride()
  end)
  cineSeq:Do(function()
    game.Player.FindPlayer():ClearDecelerationOverride()
  end)
  cineSeq:SetCompletedCineNumber(460)
  cineSeq:Do(function()
    GameObjects.SpreadDoor_Rock6m1.LuaObjectScript.Lock()
  end)
  cineSeq:Do(function()
    GameObjects.SCA_PreModiCine.LuaObjectScript.Disable()
    GameObjects.SCA_VibrateDoorTrip2.LuaObjectScript.Enable()
  end)
  cineSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  cineSeq:Do(HideCineLights)
  cineSeq:StartSequence()
end
function HeroDropCrystal()
  player:CallScript("AttemptToDropCurrentCarry")
end
function PlayCineLights()
  cine_lights_460:Show()
  cine_lights_460:JumpAnimToFrame(0)
  cine_lights_460:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_460:Hide()
end
function CanSeqFire()
  return game.Level.GetVariable("CompletedCineNumber") < 460 and game.Level.GetVariable("CompletedCineNumber") >= 450
end
function StartPreCineCamera()
  cameraCineEnter:Start()
end
function SetCameraZoneVisibility(zonename, bVisible)
  local camzone = thisLevel:GetGameObject(zonename)
  if bVisible == true then
    camzone:ShowCameraVolume()
  else
    camzone:HideCameraVolume()
  end
end
function HideCameraZones()
  SetCameraZoneVisibility("IndoorWideNav_Peak100", false)
end
function ShowCameraZones()
  SetCameraZoneVisibility("IndoorWideNav_Peak100", true)
end
