local LD = require("design.LevelDesignLibrary")
local thisObj, thisLevel, player, son, doorObject
function OnScriptLoaded(level, obj)
  thisObj = obj
  doorObject = obj:FindSingleGOByName("Magical_HingeDoor")
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  SoundOnStart()
end
function RevealDoor()
  thisObj:PlayAnimToEnd()
  thisObj:OnAnimDone(thisObj, "Quest_PeaksPass_Objective100")
end
function Enable()
  doorObject.LuaObjectScript.Enable()
end
function ForceReveal()
  thisObj:JumpAnimToFrame(thisObj.AnimLengthFrames)
  doorObject.LuaObjectScript.ForceDoorOpen()
  doorObject.LuaObjectScript.Disable()
end
local soundEvents = {
  OnInteractForward_Center = "",
  OnInteractForward_Left = "SND_DOOR_Stone_Double_Door_Push_Open_L",
  OnInteractForward_Right = "SND_DOOR_Stone_Double_Door_Push_Open_R",
  OnInteractBackward_Center = "",
  OnInteractBackward_Left = "",
  OnInteractBackward_Right = "",
  OnInteractClose_Center = "",
  OnInteractClose_Left = "",
  OnInteractClose_Right = ""
}
function SoundOnStart()
  doorObject.LuaObjectScript.SoundSetup(soundEvents)
end
function Quest_PeaksPass_Objective100()
  LD.CompleteQuest("Quest_PeaksPass_Objective100")
end
