local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local timer = require("level.timer")
local checkpoint = require("level.checkpoint")
local player, thisLevel
local puzzleEntered = false
local ZM_EC1_Start, ZM_EC2_Start, Area_1_Encounter_1, Area_2_Encounter_1, Area_2_Encounter_3, PowerBodyAlertMonitor
local rafterBreakableBroken = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  JumpDownDraugr_Area_1_Fight_1()
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.PathBlockers_DeerScene:HideCollision()
  GameObjects.alcove_ceiling_static:Hide()
  GameObjects.Chris_modi_bloodDecal:Hide()
  GameObjects.Peak100_Entrance_Zone_2:HideEntityVolume()
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") >= 450 and game.Level.GetVariable("CompletedCineNumber") <= 460 then
    GameObjects.SCA_VibrateDoorTrip1.LuaObjectScript.Disable()
    GameObjects.SCA_PostModiCine.LuaObjectScript.Enable()
    GameObjects.LeadTheWay_100Hall.LuaObjectScript.Disable()
    GameObjects.LeadTheWay_100HallReturn.LuaObjectScript.Enable()
    GameObjects.IdleContextZone_LookAround.LuaObjectScript.Disable()
    GameObjects.Chris_modi_bloodDecal:Show()
  end
  if game.Level.GetVariable("CompletedCineNumber") ~= 460 then
    GameObjects.SpreadDoor_Rock6m1.LuaObjectScript.Unlock()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 470 then
    GameObjects.LeadTheWay_100Hall.LuaObjectScript.Enable()
    GameObjects.LeadTheWay_100HallReturn.LuaObjectScript.Disable()
  end
  if rafterBreakableBroken then
    GameObjects.alcove_ceiling_static:Show()
  end
  SetBaseLoS()
end
function SetBaseLoS()
  if GameObjects.CarryBifrostLight_LeftBase.LuaObjectScript.SetBaseLineOfSightTrue then
    GameObjects.CarryBifrostLight_LeftBase.LuaObjectScript.SetBaseLineOfSightTrue()
  end
  if GameObjects.CarryBifrostLight_RightBase.LuaObjectScript.SetBaseLineOfSightTrue then
    GameObjects.CarryBifrostLight_RightBase.LuaObjectScript.SetBaseLineOfSightTrue()
  end
end
function LoadCheck_Peak180()
  game.UI.LoadCheck("Peak180_EntToChimneyLH")
end
function LoadCheck_Peak120()
  game.UI.LoadCheck("Peak120_CaveScareLH")
end
function LoadCheck_Peak170()
  game.UI.LoadCheck("Peak170_CaveCrawl")
end
function EnableStagRuneRead()
  GameObjects.SonReadRune:FindSingleGOByName("GenericSonInteract").LuaObjectScript.Enable()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
end
function ToggleLoadZonesPeaksEnter()
  GameObjects.Peak100_Entrance_Zone_1:HideEntityVolume()
  GameObjects.Peak100_Entrance_Zone_2:ShowEntityVolume()
end
function ToggleLoadZonesPeaksExit()
  GameObjects.Peak100_Entrance_Zone_1:ShowEntityVolume()
  GameObjects.Peak100_Entrance_Zone_2:HideEntityVolume()
  print("Toggle Load 1 ON / Load 2 OFF")
end
function Btr_PlayLibraryIntroBanter()
  game.Audio.PlayBanterNonCritical("scroll_peak100_intro")
end
function Zone_BlockCarryableDrop_Reset()
  GameObjects.Zone_BlockCarryableDrop:HideEntityVolume()
  timer.StartLevelTimer(0.1, function()
    GameObjects.Zone_BlockCarryableDrop:ShowEntityVolume()
  end)
  print("TOGGLE ZONE CARRYABLE)")
end
function LoadCheck_Foothills_Door()
  game.UI.LoadCheck("Foot075_Lighting")
end
function LoadCheck_Foothills_Vista()
  game.UI.LoadCheck("Foot100_Base", "Foot095_FrontDoor")
end
function Endgame_Checkpoint()
  local CompletedCineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 310 <= CompletedCineNumber and CompletedCineNumber <= 450 or 470 <= CompletedCineNumber then
    game.World.StoreCheckpoint()
  end
end
function Peak100_Entered()
  GameObjects.IdleContextZone_LookAround.LuaObjectScript.Enable()
  puzzleEntered = true
  GameObjects.LeadTheWay_100Enter.LuaObjectScript.Enable()
  GameObjects.LeadTheWay_100Intro.LuaObjectScript.Disable()
end
function IsPuzzleEntered()
  return puzzleEntered
end
function Spline100Enter_Enable()
  if puzzleEntered then
    GameObjects.LeadTheWay_100Enter.LuaObjectScript.Enable()
  else
    GameObjects.LeadTheWay_100Intro.LuaObjectScript.Enable()
  end
end
function Spline100Enter_Disable()
  GameObjects.LeadTheWay_100Enter.LuaObjectScript.Disable()
  GameObjects.LeadTheWay_100Intro.LuaObjectScript.Disable()
end
function SCA_ExitPeak_Enable()
  GameObjects.SCA_PreModiCine.LuaObjectScript.Disable()
  GameObjects.SCA_ExitPeak.LuaObjectScript.Enable()
  GameObjects.CA_PrePeaks.LuaObjectScript.Enable()
end
function SCA_PreDoorEnable()
  GameObjects.CA_PrePeaks.LuaObjectScript.Enable()
end
function SCA_ExitPeak_Disable()
  if game.Level.GetVariable("CompletedCineNumber") == 450 then
    GameObjects.SCA_PreModiCine.LuaObjectScript.Enable()
  end
  GameObjects.SCA_ExitPeak.LuaObjectScript.Interrupt()
  GameObjects.SCA_ExitPeak.LuaObjectScript.Disable()
  GameObjects.CA_PrePeaks.LuaObjectScript.Disable()
end
function SCA_PreChasmLook_Disable()
  GameObjects.SCA_PreChasmLook.LuaObjectScript.Disable()
end
function SCA_MagicDoor_Enable()
  game.AI.FindSon():ClearMaxSpeedOverride()
  GameObjects.SCA_MagicDoor.LuaObjectScript.Enable()
  GameObjects.IdleContextZone_LookAround.LuaObjectScript.Disable()
end
function SCA_MagicDoor_Disable()
  GameObjects.SCA_MagicDoor.LuaObjectScript.Disable()
end
function SCA_To120_Enable()
  GameObjects.SCA_To120.LuaObjectScript.Enable()
  GameObjects.SCA_To120_UseNavMesh.LuaObjectScript.Enable()
end
function SCA_To120_Disable()
  GameObjects.SCA_To120.LuaObjectScript.Disable()
  GameObjects.SCA_To120_UseNavMesh.LuaObjectScript.Disable()
end
function SCA_SpreadDoor180_Enable()
  GameObjects.SCA_SpreadDoor180_Combat.LuaObjectScript.Enable()
end
function SCA_SpreadDoor100_Enable()
  GameObjects.SCA_SpreadDoor180_Combat.LuaObjectScript.Interrupt()
  GameObjects.SCA_SpreadDoor180_Combat.LuaObjectScript.Disable()
  GameObjects.SCA_SpreadDoor100.LuaObjectScript.Enable()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
end
function SCA_VibrateDoorTrip1_Disable()
  GameObjects.SCA_VibrateDoorTrip1.LuaObjectScript.Disable()
end
function SCA_VibrateDoorTrip2_Disable()
  GameObjects.SCA_VibrateDoorTrip2.LuaObjectScript.Interrupt()
  GameObjects.SCA_VibrateDoorTrip2.LuaObjectScript.Disable()
end
function SCA_WaitForRuneReveal_Enable()
  GameObjects.SCA_WaitForRuneReveal.LuaObjectScript.Enable()
end
function SCA_WaitForRuneReveal_Disable()
  GameObjects.SCA_WaitForRuneReveal.LuaObjectScript.Disable()
end
function SCA_WaitForRuneReveal_Disable()
  GameObjects.SCA_WaitForRuneReveal.LuaObjectScript.Disable()
end
function SCA_PostModiCine_Disable()
  timer.StartLevelTimer(5, function()
    GameObjects.SCA_PostModiCine.LuaObjectScript.Interrupt()
    GameObjects.SCA_PostModiCine.LuaObjectScript.Disable()
  end)
end
function SCA_SpreadDoor180_Combat_Disable()
  GameObjects.SCA_SpreadDoor180_Combat.LuaObjectScript.Interrupt()
  GameObjects.SCA_SpreadDoor180_Combat.LuaObjectScript.Disable()
end
function DraugrJumpDown()
  rafterBreakableBroken = true
  PlaySoundCeilingBreak()
  game.Blender.Trigger({
    Name = "FSE_SHAKE_SPARKS",
    Duration = 1.67,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.8}
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_LOW",
    Duration = 1.67,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.5},
    Priority = 2
  })
  if game.Combat.GetCombatStatus() ~= true then
    LD.CallFunctionAfterDelay(function()
      GameObjects.Reaction_Interest_CrystalFall.LuaObjectScript.Trigger()
    end, 0.7)
  end
end
function Trigger2DraugrJump()
end
function DraugrScare()
end
function FindEnchantIntro()
  local peak180 = game.FindLevel("Peak180_EntToChimneyLH")
  if peak180 ~= nil then
    peak180:CallScript("StartEnchantIntro")
  end
end
function JumpDownDraugr_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Intro Leg Draugr Peak100", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone100"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_3_LEG_SPLA",
      spawnLocators = "A1_Loc_R_1",
      useSpawnLocatorsOnly = true,
      markerID = "IntroBehavior",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_3_LEG_SPLA",
      spawnLocators = "A1_Loc_R_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_1_Encounter_Start"), {
    cineRequirement = {0, 295}
  })
  Area_1_Encounter_1:OnComplete(function()
    timer.StartLevelTimer(2.5, function()
      local peak180 = game.FindLevel("Peak180_EntToChimneyLH")
      if peak180 ~= nil then
        peak180:GetGameObject("Btr_SapBackside"):CallScript("SapDiscovered_Show")
      end
    end)
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Legs")
  end)
  PowerBodyAlertMonitor = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_1_Encounter_Attack)
  PowerBodyAlertMonitor:OnEnter(function()
  end)
end
function SurpriseDraugr_Area_2()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "2 Surprise Jump Down Draugr", {CheckpointOnComplete = true})
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Draugr_SFA",
      spawnLocators = "A2_Loc_O_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_2_SH_SFA",
      spawnLocators = "A2_Loc_O_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_2_Encounter_Start"), {
    cineRequirement = {0, 295}
  })
end
function ScareDraugr_Area_1()
  Area_2_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Scare Enemy Peak100", {CheckpointOnComplete = true})
  Area_2_Encounter_3:AddWave({
    {
      spawners = "Draugr_1_ARM",
      maxActive = 1,
      markerID = "IntroBehavior",
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_3:SetStartZone(thisLevel:GetGameObject("EntZn_2_Encounter_Spawn"), {
    cineRequirement = {0, 295}
  })
end
function WakeSleeping(encounter)
  local waveXEnemies = encounter:GetActiveEnemies(1)
  local delay = math.random()
  for key, enemy in ipairs(waveXEnemies) do
    timer.StartLevelTimer(math.random(key * 0.25 + 2), function()
      WakeMe(enemy)
    end)
  end
end
function WakeMe(enemy)
  enemy:TriggerMoveEvent("kLEAlert")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    puzzleEntered = puzzleEntered,
    rafterBreakableBroken = rafterBreakableBroken
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  puzzleEntered = savedInfo.puzzleEntered
  rafterBreakableBroken = savedInfo.rafterBreakableBroken
end
local SNDCeilingBreak
local OverrideSoundEvents = {
  isLooping = false,
  OnInteractForward_Center = "",
  OnInteractForward_Left = "SND_DOOR_Wood_Double_Pry_Apart_Seq_L",
  OnInteractForward_Right = "SND_DOOR_Wood_Double_Pry_Apart_Seq_R",
  OnInteractBackward_Center = "",
  OnInteractBackward_Left = "SND_DOOR_Wood_Double_Pry_Apart_Seq_L",
  OnInteractBackward_Right = "SND_DOOR_Wood_Double_Pry_Apart_Seq_R"
}
function SoundInit()
  SNDCeilingBreak = GameObjects.SNDCeilingBreakGrp:FindSingleSoundEmitterByName("SNDCeilingBreak")
  GameObjects.SpreadDoor_Rock6m1.LuaObjectScript.SoundSetup(OverrideSoundEvents)
end
function PlaySoundCeilingBreak()
  LD.PlaySound(SNDCeilingBreak, "SND_BRK_Wood_Ceiling_Smash_Peak100")
end
function Bookmark_AfterDeerPuzzle()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "09_PeaksPass_012_AfterDeerPuzzle"]
  tableEntry.OverrideObject = GameObjects.CO_AfterDeerPuzzle.Child
  timer.StartLevelTimer(0.1, function()
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
end
