local timers = require("level.timer")
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  banterPlayed = savedInfo.banterPlayed
end
function BifrostTorchLit()
  if not banterPlayed.BifrostTorch and game.Level.GetVariable("CompletedCineNumber") < 450 then
    timers.StartLevelTimer(1.2, function()
      game.Audio.PlayBanterNonCritical("055_AlfheimTorch_End")
    end)
    banterPlayed.BifrostTorch = true
  end
end
function DownFirst_Banter()
  if not banterPlayed.DownFirst then
    timers.StartLevelTimer(0.5, function()
      game.Audio.PlayBanterNonCritical("060_DownFirst")
    end)
    banterPlayed.DownFirst = true
  end
end
