local EC = require("design.Encounter")
local collisionCheck = require("camera.collisioncheck")
local uiCalls = require("ui.uicalls")
local LD = require("design.LevelDesignLibrary")
local Area_1_Encounter_1
player = nil
local thisLevel
local warpoffset = engine.Vector.New(2, 0, 2)
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") > 263 then
    GameObjects.IdleContextZone_Panicked.LuaObjectScript.Disable()
    GameObjects.IdleContextZone_Reset.LuaObjectScript.Disable()
    GameObjects.IdleContextZone_Alert.LuaObjectScript.Disable()
  end
end
function LoadCheckPeak140()
  game.UI.LoadCheck("Peak140_CavernDark")
end
function LoadCheckPeak100()
  game.UI.LoadCheck("Peak100_Entrance")
end
function EnableDropDownZone()
  GameObjects.Zone_SonDropDown:ShowEntityVolume()
end
function EnableSonDropDown()
  GameObjects.Zone_SonDropDown:HideEntityVolume()
  GameObjects.CA_boostdropdown_5m.LuaObjectScript.Enable()
  GameObjects.Zone_SonDropDown:HideEntityVolume()
end
function DisableDropDown()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_boostdropdown_5m.LuaObjectScript.Disable()
    GameObjects.Zone_SonDropDown:HideEntityVolume()
  end, 0.5)
end
function DropCarryBlock(markerGameObject, markerId)
  print("mARKER ID.......", markerGameObject, markerId)
  if markerGameObject ~= nil then
    markerGameObject:CallScript("StartCarryExit")
  end
end
function SCA_ExitCrackClimb_Enable()
  GameObjects.SCA_ExitCrackClimb.LuaObjectScript.Enable()
end
function SCA_ExitCrackClimbRev_Enable()
  GameObjects.SCA_ExitCrackClimbRev.LuaObjectScript.Enable()
end
function SCA_ExitCaveCrawl_Enable()
  GameObjects.SCA_ExitCaveCrawl.LuaObjectScript.Enable()
end
function SCA_ExitCaveCrawl_Disable()
  GameObjects.SCA_ExitCaveCrawl.LuaObjectScript.Disable()
  GameObjects.SCA_Crossroads1.LuaObjectScript.Disable()
end
function SCA_ExitCaveCrawlReturn_Enable()
  GameObjects.SCA_ExitCaveCrawlReturn.LuaObjectScript.Enable()
  GameObjects.SCA_Crossroads1.LuaObjectScript.Enable()
end
function Spline_120SecretHall_Enable()
  GameObjects.LeadTheWay_120SecretHall.LuaObjectScript.Enable()
end
function ScareDraugr_Area_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Scare Enemy Peak120", {CheckpointOnComplete = true})
  Area_1_Encounter_1:AddWave({
    prioritizeOffScreenSpawners = true,
    prioritizeSpawnersInRange = {4, 10},
    {
      spawners = "Draugr_SURPRISE",
      spawnLocators = "A1_O_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
end
