LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
checkpoint = require("level.checkpoint")
local player, son, thisLevel
local loot140 = 0
local firstVisit = true
local Area_1_Encounter_1, Area_4_Encounter_1, Area_2_Encounter_1, Area_2_Encounter_2, Area_2_Encounter_3, Area_2_Encounter_4, Area_5_Encounter_1
local encounter2Active = false
local WitchAlertZoneMonitor, PatrolDespawnZoneMonitor, Area_1_Patrol_1, Area_2_Encounter_1_WakeMid, Area_2_Encounter_2_WakeLBack, Area_2_Encounter_3_WakeRBack, Area_2_Encounter_4_WakeUpper, Area1AlertStatueZoneMonitor, Area2AlertStatueZoneMonitor
local bCam140Lockout = false
function OnPreStart(level)
  GameObjects.coffin_tier3_peak140_1.LuaObjectScript.DisableCheckpointRequirement()
end
function OnScriptLoaded(level)
  LD.GiveLightArrow()
  player = game.Player.FindPlayer()
  thisLevel = level
  Witch_Area_1_Fight_1()
  Witch_Draugr_Patrol_1()
  Turrets_Area_1_Mid()
  Draugrs_Area_2_LeftBack()
  Draugrs_Area_2_RightBack()
  Draugrs_Area_2_Upper()
  Area_4_Fight_1()
  Area_5_Fight_1()
end
function OnStartGameFromThisLevel(level)
  if game.AI.FindSon() ~= nil then
    LD.GiveBifrost()
    LD.GiveLightArrow()
  end
end
function OnFirstStart(level, obj)
  GameObjects.TraverseLink_3m_Boost:HideTraverseLink()
end
function OnStart(level, obj)
  local Zipline_TopPOS = thisLevel:GetGameObject("Zipline_Top")
  local Zipline_BottomPOS = thisLevel:GetGameObject("Zipline_Bottom")
  local Zipline_fromShipVis = thisLevel:GetGameObject("zipline_Peak140").Child
  Zipline_fromShipVis:SetZiplineStartAndEnd(Zipline_TopPOS:GetWorldPosition(), Zipline_BottomPOS:GetWorldPosition())
  SoundOnStart()
end
function TraverseLink_Mantle_Enable()
  GameObjects.TraverseLink_3m_Boost:ShowTraverseLink()
  GameObjects.TraversePath_BuddyBoost:HideTraversePath()
end
function TraversePath_BuddyBoost_Enable()
  GameObjects.TraversePath_BuddyBoost:ShowTraversePath()
  GameObjects.TraverseLink_3m_Boost:HideTraverseLink()
end
function LootCollect140_Increment()
  loot140 = loot140 + 1
  print("loot140 = " .. tostring(loot140))
end
function ShouldStagRoomRedux4_Play()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 460 <= cineNum and cineNum < 500 and loot140 == 9 then
    return true
  end
end
function ShouldStagRoomRedux5_Play()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 460 <= cineNum and cineNum < 500 then
    return true
  end
end
function LoadCheck_Peak120()
  game.UI.LoadCheck("Peak120_CaveScareLH")
end
function LoadCheck_Peak170()
  game.UI.LoadCheck("Peak170_CaveCrawl")
end
function SCA_BuddyBoost_Enable()
  GameObjects.SCA_BuddyBoost_Helper.LuaObjectScript.Enable()
end
function SCA_DebrisLiftFwd_Enable()
  if firstVisit == true then
    GameObjects.SCA_DebrisLiftFwd_Alert.LuaObjectScript.Enable()
    firstVisit = false
  else
    GameObjects.SCA_DebrisLiftFwd.LuaObjectScript.Enable()
  end
  GameObjects.SCA_DebrisLiftRev.LuaObjectScript.Disable()
  local peak120 = game.FindLevel("Peak120_CaveScareLH")
  if peak120 ~= nil then
    peak120:CallScript("SCA_ExitCaveCrawl_Disable")
  end
end
function SCA_DebrisLiftRev_Enable()
  GameObjects.SCA_DebrisLiftRev.LuaObjectScript.Enable()
  GameObjects.SCA_DebrisLiftFwd.LuaObjectScript.Disable()
  GameObjects.SCA_DebrisLiftFwd_Alert.LuaObjectScript.Disable()
end
function SCA_LookBridgeSecret_Disable()
  GameObjects.LookBridgeSecret.LuaObjectScript.Disable()
end
function Spline140_MagicBridge1_Enable()
  GameObjects.LeadTheWay_MagicBridge1.LuaObjectScript.Enable()
end
function Spline140_MagicBridge2_Enable()
  GameObjects.LeadTheWay_MagicBridge2.LuaObjectScript.Enable()
end
function Spline140_BigBridge_Enable()
  GameObjects.LeadTheWay_BigBridge.LuaObjectScript.Enable()
end
function Spline140_BigBridge_Disable()
  GameObjects.LeadTheWay_BigBridge.LuaObjectScript.Disable()
end
function BifrostBridge01_CollisionOFF()
  GameObjects.BifrostBridge01_Collision:HideCollision()
end
function BifrostBridge02_CollisionOFF()
  GameObjects.BifrostBridge02_Collision:HideCollision()
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
function ShowDebugTable()
  local debugTable = {}
  debugTable.Title = "Peak140 Cavern Dark Info"
  debugTable.X = 150
  debugTable.Y = 10
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  debugTable[1] = {
    "encounter2Active: ",
    encounter2Active
  }
  engine.DrawDebugTable(debugTable)
end
function SetBool_Peak140RecenterLockout()
  bCam140Lockout = true
end
function GetBool_Peak140RecenterLockout()
  return bCam140Lockout
end
function DbgFallChest()
  GameObjects.FallingChest:PlayAnimToEnd()
  GameObjects.WallBreak_Platforms1:PlayAnimToEnd()
end
function Endgame_Checkpoint()
  local CompletedCineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 310 <= CompletedCineNumber and CompletedCineNumber <= 450 or 470 <= CompletedCineNumber then
    game.World.StoreCheckpoint()
  end
end
function Crystal140_Mid()
end
function Crystal140_LeftBack()
end
function Crystal140_RightBack()
end
function Crystal140_Upper()
end
function Witch_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Intro Witch Flyer Spawner Peak140", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone140",
    StartMusic = "SND_MX_PEAK_caverns_fight_witch_in",
    StopMusic = "SND_MX_PEAK_caverns_fight_witch_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "W_Witch_N_SRFC",
      maxActive = 1,
      spawnLocators = "A1_Loc_O_1",
      spawnWad = "Peak140_AI_CavernDark_01",
      useSpawnLocatorsOnly = true,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("Entz_Encounter_1_Start"), {
    cineRequirement = {0, 295}
  })
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Revenant_Spawner")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Fire")
  end)
end
function Witch_Draugr_Patrol_1()
  Area_1_Patrol_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Patrolling Draugr Above Peak140", {CheckpointOnComplete = false})
  Area_1_Patrol_1:AddWave({
    {
      spawners = "Draugr_Patrol_Walk1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_Patrol_Walk2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Patrol_1:SetStartZone(thisLevel:GetGameObject("Entz_Encounter_0_Start"), {
    cineRequirement = {0, 295}
  })
  PatrolDespawnZoneMonitor = monitors.CreateEntityZoneMonitor(player, GameObjects.Entz_Encounter_1_Start)
  PatrolDespawnZoneMonitor:SetTriggerCountLimit(1)
  PatrolDespawnZoneMonitor:OnEnter(function()
    if Area_1_Patrol_1 ~= nil then
      timers.StartLevelTimer(20, function()
        Area_1_Patrol_1:DespawnEnemies()
      end)
    end
  end)
end
function Peak140CombatCheckpoint()
  if Area_2_Encounter_1:IsComplete() and Area_2_Encounter_2:IsComplete() and Area_2_Encounter_3:IsComplete() then
    game.World.StoreCheckpoint()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Legs")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Dual")
  end
end
function Turrets_Area_1_Mid()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:2 Turret Mid Peak140", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone140"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "U_Draugr_L2_PATROL",
      maxActive = 1,
      totalSpawns = 1,
      spawnLocators = "A2_Loc_O_1",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("Entz_Encounter_2_Start"), {
    cineRequirement = {0, 295}
  })
  Area_2_Encounter_1:OnComplete(Peak140CombatCheckpoint)
end
function Draugrs_Area_2_LeftBack()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "Peak140 Area 3 Sleeping Draugr Left Back", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone140"
  })
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Draugr_L_SLEEP",
      maxActive = 1,
      totalSpawns = 1,
      spawnLocators = "A3_Loc_O_1",
      markerID = "StatueDra02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1
    }
  })
  Area_2_Encounter_2:SetStartZone(thisLevel:GetGameObject("Entz_Encounter_2_Start"), {
    cineRequirement = {0, 295}
  })
  Area_2_Encounter_2:OnComplete(Peak140CombatCheckpoint)
  Area1AlertStatueZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("Entz_Encounter_2_WakeLBack"))
  Area1AlertStatueZoneMonitor:OnEnter(function()
    local statueDra2 = LD.FindSingleAIByMarker("StatueDra02")
    if statueDra2 ~= nil then
      statueDra2:TriggerMoveEvent("kLEAlert")
    end
  end)
  Area1AlertStatueZoneMonitor:SetTriggerCountLimit(1)
end
function Draugrs_Area_2_RightBack()
  Area_2_Encounter_3 = EC.NewEncounter(thisLevel, "Peak140 Area 3 Sleeping Draugr Right Back", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone140"
  })
  Area_2_Encounter_3:AddWave({
    {
      spawners = "U_Draugr_P_SLEEP",
      maxActive = 1,
      totalSpawns = 1,
      spawnLocators = "A3_Loc_O_2",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "DW_Draugr_H_PATROL",
      maxActive = 1,
      totalSpawns = 1,
      spawnLocators = "A3_Loc_O_6",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_3:SetStartZone(thisLevel:GetGameObject("Entz_Encounter_2_Start"), {
    cineRequirement = {0, 295}
  })
  Area_2_Encounter_3:OnComplete(Peak140CombatCheckpoint)
end
function Draugrs_Area_2_Upper()
  Area_2_Encounter_4 = EC.NewEncounter(thisLevel, "Peak140 Area 3 Sleeping Draugr Upper", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone140"
  })
  Area_2_Encounter_4:AddWave({
    {
      spawners = "Draugr_L_SLEEP",
      maxActive = 1,
      totalSpawns = 1,
      spawnLocators = "A3_Loc_O_7",
      markerID = "StatueDra03",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_4:SetStartZone(thisLevel:GetGameObject("Entz_Encounter_3_Start"), {
    cineRequirement = {0, 295}
  })
  Area_2_Encounter_4_WakeUpper = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("Entz_Encounter_2_WakeUpper"))
  Area_2_Encounter_4_WakeUpper:OnEnter(function()
    local statueDra3 = LD.FindSingleAIByMarker("StatueDra03")
    if statueDra3 ~= nil then
      statueDra3:TriggerMoveEvent("kLEAlert")
    end
  end)
  Area_2_Encounter_4_WakeUpper:SetTriggerCountLimit(1)
end
function Area_4_Fight_1()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "Peak140 Area 4 Encounter", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone140"
  })
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Draugr_L_SFG",
      spawnLocators = "A4_Loc_O_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0.5, 1}
    },
    {
      spawners = "U_Draugr_P_SFG",
      spawnLocators = "A4_Loc_O_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0.8, 1.5}
    }
  })
  Area_4_Encounter_1:SetStartZone(thisLevel:GetGameObject("Zone_SpawnBridgeDraugr"), {
    cineRequirement = {0, 295}
  })
end
function Area_5_Fight_1()
  Area_5_Encounter_1 = EC.NewEncounter(thisLevel, "Peak140 Area 5 Peak Return", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone140"
  })
  Area_5_Encounter_1:AddWave({
    {
      spawners = "DW_Draugr_6_PATROL",
      maxActive = 1,
      totalSpawns = 1,
      spawnLocators = "A3_Loc_O_6",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "U_Draugr_P_SLEEP",
      maxActive = 1,
      totalSpawns = 1,
      spawnLocators = "A2_Loc_O_2",
      markerID = "StatueDra01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    }
  })
  Area_5_Encounter_1:SetStartZone(thisLevel:GetGameObject("Zone_SpawnReturnDraugr"), {
    cineRequirement = {450, 900}
  })
end
function WakeSleeping(encounter)
  local waveXEnemies = encounter:GetActiveEnemies(1)
  local delay = math.random()
  for key, enemy in ipairs(waveXEnemies) do
    timers.StartLevelTimer(math.random(key * 0.25 + 2), function()
      WakeMe(enemy)
    end)
  end
end
function WakeMe(enemy)
  enemy:TriggerMoveEvent("kLEAlert")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    encounter2Active = encounter2Active,
    firstVisit = firstVisit
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  firstVisit = savedInfo.firstVisit
end
function Peak140_FirstTripComplete()
  Area_1_Encounter_1:SetComplete()
  Area_2_Encounter_1:SetComplete()
  Area_2_Encounter_2:SetComplete()
  Area_2_Encounter_3:SetComplete()
  Area_2_Encounter_4:SetComplete()
  Area_4_Encounter_1:SetComplete()
end
function SoundOnStart()
  GameObjects.InkTotem:FindSingleGOByName("pSonReadRune").LuaObjectScript.LoreMarkerRuneReadSoundSetup()
end
