local LD = require("design.LevelDesignLibrary")
local Timer = require("level.timer")
local player, enabled, interactZone, traversePath
local identifier = "Skeleton"
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  enabled = true
  game.SubObject.Sleep(obj)
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  enabled = savedInfo.enabled
end
function OnStart(level, obj)
  if enabled == true then
    interactZone = LD.CreateInteractZone_Standard_180(obj, "promptJoint")
    interactZone:SetInteractFrontPlayerFrontAngleWeight(1)
    interactZone:SetInteractFrontPlayerFrontAngle(180)
    interactZone:SetHintXZRange(2)
    if interactZone.SetInteractTraversalAllowed then
      interactZone:SetInteractTraversalAllowed(true)
    end
    traversePath = level:FindTraversePath("TraversePath_CaveCrawlEnter")
    traversePath:Disable(identifier)
  end
end
function OnUseWorld(level, obj)
  if interactZone and interactZone:PlayerCanInteract() then
    player:RequestInteract(obj, interactZone)
  end
end
function OnInteractStart(level, obj, creature)
  local branch = "BRA_Peak170_Skeleton"
  local joint = "syncJoint"
  local playerPuppeteer = game.Puppeteer.NewForce(obj, identifier, player)
  local sonPuppeteer
  local slaves = {}
  local son = game.AI.FindSon()
  if son then
    sonPuppeteer = game.Puppeteer.NewForce(obj, identifier, son)
    sonPuppeteer:AcceptSync()
    table.insert(slaves, {Slave = sonPuppeteer, Branch = branch})
  end
  playerPuppeteer:Sync(branch, true, slaves, joint)
  Timer.StartLevelTimer(0.65, function()
    LD.BreakObject(obj)
    playerPuppeteer = nil
    sonPuppeteer = nil
    Disable()
    player:EndInteract()
    traversePath:Enable(identifier)
  end)
end
function Disable()
  enabled = false
  if interactZone then
    interactZone:Disable()
  end
end
function OnSaveCheckpoint(level, obj)
  return {enabled = enabled}
end
