local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local bCanFire02 = false
local runeTerrorPlayed = false
local momKnew_shown = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if momKnew_shown == false then
    MomKnew_Hide()
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    bCanFire02 = bCanFire02,
    runeTerrorPlayed = runeTerrorPlayed,
    momKnew_shown = momKnew_shown
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bCanFire02 = savedInfo.bCanFire02
  runeTerrorPlayed = savedInfo.runeTerrorPlayed
  momKnew_shown = savedInfo.momKnew_shown
end
function PlayLookingForCrack01()
  if game.Level.GetVariable("CompletedCineNumber") < 270 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("140_LookingForCrack01", function()
        MomKnew_Show()
      end)
    end, 1.8)
    bCanFire02 = true
  end
end
function RuneTerror_Banter()
  if not runeTerrorPlayed then
    game.Audio.PlayBanter("148_RuneTerror")
    runeTerrorPlayed = true
  end
end
function MomKnew_Hide()
  GameObjects.Btr_MomKnew:Hide()
end
function MomKnew_Show()
  timers.StartLevelTimer(1, function()
    GameObjects.Btr_MomKnew:Show()
    momKnew_shown = true
  end)
end
