local bSapDiscovered = false
local sapDiscovered_shown = false
local sapBackside_shown = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if sapDiscovered_shown == false then
    SapDiscovered_Hide()
  end
  if sapBackside_shown == false then
    SapBackside_Hide()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.bSapDiscovered = bSapDiscovered
  savedInfo.sapBackside_shown = sapBackside_shown
  savedInfo.sapDiscovered_shown = sapDiscovered_shown
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  sapDiscovered_shown = savedInfo.sapDiscovered_shown
  bSapDiscovered = savedInfo.bSapDiscovered
  sapBackside_shown = savedInfo.sapBackside_shown
end
function SapDiscovered()
  bSapDiscovered = true
end
function PlaySapBackside()
  if game.Level.GetVariable("CompletedCineNumber") < 270 then
    if bSapDiscovered then
      game.Audio.PlayBanter("145_SapBacksideB")
    else
      game.Audio.PlayBanter("145_SapBacksideA")
    end
  end
end
function SapDiscovered_Hide()
  GameObjects.Btr_SapDiscovered:Hide()
end
function SapDiscovered_Show()
  GameObjects.Btr_SapDiscovered:Show()
  sapDiscovered_shown = true
end
function SapBackside_Hide()
  GameObjects.Btr_SapBackside:HideEntityVolume()
end
function SapBackside_Show()
  GameObjects.Btr_SapBackside:ShowEntityVolume()
  sapBackside_shown = true
end
