local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local thisObj, thisLevel, son, sonActor, brokenLantern
local speedControlOff = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  HideLitTorchesObjs()
end
function OnStart(level, obj)
  brokenLantern = GameObjects.lanternBroken1_Prop.Child
  brokenLantern:StartAnim("poiPeakBrokenLantern1Scene")
  brokenLantern:JumpAnimToFrame(0)
  brokenLantern:PauseAnim()
  if speedControlOff then
    Disable_BrokenLantern_SpeedControl()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.speedControlOff = speedControlOff
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  speedControlOff = savedInfo.speedControlOff
end
function CreateActors()
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function BrokenLantern1Seq()
  CreateActors()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "BrokenLantern1")
  local actor_table = {
    {
      Obj = brokenLantern,
      Anim = "poiPeakBrokenLantern1Scene"
    }
  }
  cineSeq:WaitForFunctionTrue(function()
    return son:IsPlayingMove("MOV_Crack_Climb_HOD_Right_Down_Exit")
  end)
  cineSeq:WaitForFunctionTrue(function()
    return not son:IsPlayingMove("MOV_Crack_Climb_HOD_Right_Down_Exit")
  end)
  cineSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_BrokenLantern1",
    ReferenceJoint = "BrokenLantern1_SynchJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.RunArrivalRadius
  })
  cineSeq:ActorSync(sonActor, {
    Slaves = actor_table,
    Branch = "BRA_BrokenLantern1",
    ReferenceJoint = "BrokenLantern1_SynchJoint"
  })
  cineSeq:Do(function()
    game.Audio.PlayBanter("230_BrokenLantern1", ShowLitTorchesObjs)
  end)
  cineSeq:Do(SonOccupied)
  cineSeq:WaitForActorPuppeteerComplete(sonActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:Do(Disable_BrokenLantern_SpeedControl)
  cineSeq:Do(function()
    game.AI.FindSon():CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
    local peak190 = game.FindLevel("peak190_ChimneyEnter")
    peak190:CallScript("SCA_SkyLanternTransition_Enable")
    SonUnoccupied()
  end)
  cineSeq:StartSequence()
end
function HideLitTorchesObjs()
  GameObjects.Btr_LitTorchesA:Hide()
  GameObjects.Btr_LitTorchesB:Hide()
end
function Disable_BrokenLantern_SpeedControl()
  GameObjects.SpeedControlZones_BrokenLantern1:Hide()
  speedControlOff = true
end
function ShowLitTorchesObjs()
  LD.CallFunctionAfterDelay(function()
    GameObjects.Btr_LitTorchesA:Show()
    GameObjects.Btr_LitTorchesB:Show()
  end, 1)
end
function SonOccupied()
  local availabilityState = {Unoccupied = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function SonUnoccupied()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
