local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local timers = require("level.timer")
local thisObj, thisLevel, kraActor, sonActor
local boolFirstSawClawPlayed = false
local cineEnterCameraObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  cineEnterCameraObj = CCEC.CineEnterCamera.New("ENV_CineEnter_poiFirstSawClaw", 4)
  cineEnterCameraObj:SetObjectToSleep(obj)
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  HideEntityZones()
end
function OnUpdate(level, obj)
  if cineEnterCameraObj ~= nil then
    cineEnterCameraObj:Update()
  end
end
function CreateActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function BuildFirstSawClawSeq()
  CreateActors()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "First Saw Claw - POI")
  local actorTable = {
    {Actor = sonActor}
  }
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(function()
    game.SubObject.Wake(thisObj)
  end)
  seq:Do(function()
    cineEnterCameraObj:Start()
  end)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_FirstSawClaw",
    ReferenceJoint = "FirstSawClaw_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius,
    weapon_state = "bare"
  })
  seq:ActorSync(kraActor, {
    Slaves = actorTable,
    Branch = "BRA_FirstSawClaw",
    ReferenceJoint = "FirstSawClaw_SynchJoint"
  })
  seq:Do(CloseBigDoor)
  seq:WaitSeconds(3)
  seq:Do(function()
    game.Audio.PlayBanter("160_FirstSawClaw")
  end)
  seq:Do(function()
    boolFirstSawClawPlayed = true
  end)
  seq:WaitForAndCompleteCineMode(sonActor, thisObj)
  seq:StopPuppetingActor(sonActor)
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:Do(function()
    game.FindLevel("Peak080_Global"):GetGameObject("Cine_RopeStuckA"):CallScript("CrankHints_Banter")
  end)
  seq:StopPuppetingActor(kraActor)
  seq:Do(CompletePPObj101)
  seq:Do(TurnOnGateClosedSpline)
  seq:Do(function()
    game.SubObject.Sleep(thisObj)
  end)
  seq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "09_PeaksPass_020_ChimneyLow"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  seq:StartSequence()
end
function HideEntityZones()
  thisObj:HideEntityVolume()
end
function ShowEntityZones()
  thisObj:ShowEntityVolume()
end
function TurnOnGateClosedSpline()
  local LM = require("level.loadmonitor")
  local loadMonitorPeak080 = LM.CreateLoadMonitor()
  loadMonitorPeak080:AddCallback({
    Wads = {
      "Peak080_Global"
    },
    Functions = {
      EnableDoorClosedSpline
    }
  })
end
function EnableDoorClosedSpline(wads)
  wads.Peak080_Global:CallScript("LeadTheWay_200CartGateClosed_Enable")
end
function CompletePPObj101()
  LD.CompleteQuest("Quest_PeaksPass_Objective101")
end
function CloseBigDoor()
  timers.StartLevelTimer(11.7, function()
    local peak200 = game.FindLevel("Peak200_ChimneyLow")
    peak200:CallScript("GateEntrance_Close")
  end)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.boolFirstSawClawPlayed = boolFirstSawClawPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boolFirstSawClawPlayed = savedInfo.boolFirstSawClawPlayed
end
