local checkpoint = require("level.checkpoint")
local discoveredSecretArea = false
function OnPreStart(level)
  GameObjects.chest_common_tier3_peak190_1.LuaObjectScript.DisableCheckpointRequirement()
end
player = game.Player.FindPlayer()
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    discoveredSecretArea = discoveredSecretArea
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  discoveredSecretArea = savedInfo.discoveredSecretArea
end
function OnEvaluateLoadGroup_AIWads()
  if game.Level.GetVariable("PEAK_ChimneyPhase") == 1 and game.Level.GetVariable("CompletedCineNumber") < 450 then
    return "AIWadsFirstEntry"
  elseif game.Level.GetVariable("PEAK_ChimneyPhase") == 2 and game.Level.GetVariable("CompletedCineNumber") < 450 then
    return "AIWadsRoller"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 450 then
    return "AIWadsReturn"
  end
end
function SCA_SkyLanternTransition_Enable()
  GameObjects.SCA_SkyLanternTransition.LuaObjectScript.Enable()
end
function SonSyncOff()
  local availabilityState = {AvailableForSync = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function SonSyncOn()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function RopeDropSecret_Enable()
  GameObjects.RopeDropSecret.Child.LuaObjectScript.EnablePlayerInteract()
end
function SCA_RopeWait_Enable()
  GameObjects.SCA_RopeWait.LuaObjectScript.Enable()
end
function SCA_RopeWait_Disable()
  GameObjects.SCA_RopeWait.LuaObjectScript.Interrupt()
  GameObjects.SCA_RopeWait.LuaObjectScript.Disable()
end
function TriggerVolume190_Hide()
  GameObjects.TVSmallSha:HideTriggerVolume()
end
function TriggerVolume190_Show()
  GameObjects.TVSmallSha:ShowTriggerVolume()
end
function Endgame_Checkpoint()
  local CompletedCineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 310 <= CompletedCineNumber and CompletedCineNumber <= 450 or 470 <= CompletedCineNumber then
    game.World.StoreCheckpoint()
  end
end
function LoadCheck_Peak180()
  game.UI.LoadCheck("Peak180_EntToChimneyLH")
end
function LoadCheck_Peak200()
  game.UI.LoadCheck("Peak200_ChimneyLow")
end
function killAllEnemies()
  local activeEnemies = player:FindEnemies(1000)
  for _, enemy in pairs(activeEnemies) do
    if enemy ~= nil then
      enemy:Destroy()
    end
  end
end
