timers = require("level.timer")
LD = require("design.LevelDesignLibrary")
monitors = require("level.MonitorLibrary")
EC = require("design.Encounter")
uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local thisLevel, player, son, frostTroll
HM_A2 = nil
local ZM_A1_E3_Attack, ZM_A3_E4_Attack, ZM_A3_E5_Attack, ZM_A3_E6_Attack, Troll_HealthMonitor, AfterHallway, BeforeIcePush, AfterGateEncounter03, Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3, Area_1_Encounter_4, Area_2_Encounter_1, Area_3_Encounter_1, Area_3_Encounter_2, Area_3_Encounter_3, Area_3_Encounter_4, Area_3_Encounter_5, Area_3_Encounter_6, Area_4_Encounter_1, Area_5_Encounter_1, Area_6_Encounter_1, Area_6_Encounter_2, Area_6_Encounter_3, HelwalkerAlertZoneMonitor, Flyer200AlertZoneMonitor, Flyer210AlertZoneMonitor, Flyer260AlertZoneMonitor, Area1DespawnZoneMonitor, Area3AlertWaveZoneMonitor
local firstTrollFightStart = false
local peak200TrollMusic = false
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  Area_1_Fight_2()
  Troll_Area_1_Fight_4()
  Area_3_Fight_1()
  TurretAmbush_Area_3_Fight_3()
  EnhancedDraugrs_Area_3_Fight_4()
  EnhancedDraugrs_2_Area_3_Fight_4()
  Draugr_Patrol_Fight()
  Wolf_Patrol_Fight()
  Wolf_Fight_Repop()
end
function OnSaveCheckpoint(level, obj)
  return {firstTrollFightStart = firstTrollFightStart}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  firstTrollFightStart = savedInfo.firstTrollFightStart
end
function OnStart(level, obj)
  GameObjects.DespawnTriggers200:HideEntityVolume()
end
function StartFight_PostRocksCrumbled()
  Area_1_Encounter_2:Start()
  timers.StartLevelTimer(1, function()
    Area_1_Encounter_2:AlertEnemies()
  end)
end
function TriggerTrollFight_PostBoulderPush()
  if Area_1_Encounter_4:IsComplete() == false and game.Level.GetVariable("PEAK_BoulderPushed") == true and game.Level.GetVariable("CompletedCineNumber") <= 295 then
    Area_1_Encounter_4:Start()
  end
end
function AlertTrollEncounter_PlayerReEnteredFightSpace()
  if Area_1_Encounter_4:IsRunning() then
    Area_1_Encounter_4:AlertEnemies()
  end
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Flyers Peak200", {CheckpointOnComplete = false})
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Flyers_SUHANG",
      spawnLocators = "A7_Loc_H_1",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyers_SUHANG",
      spawnLocators = "A7_Loc_H_2",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Draugr Chest Intro & Projectiles Peak200", {
    CheckpointOnComplete = true,
    AutoResetOnReload = true,
    LeashZone = "LeashZone200_1",
    StartMusic = "SND_MX_PEAK_chimneylow_fight_1_in",
    StopMusic = "SND_MX_PEAK_chimneylow_fight_1_out"
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Draugr_PB_JUMPOUT",
      spawnLocators = "A1_Loc_R_1",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.6
    },
    {
      spawners = "Draugr_PB_PATROL01",
      spawnLocators = "A1_Loc_R_2",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_PB_PATROL02",
      spawnLocators = "A1_Loc_R_4",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_3_TURRET",
      spawnLocators = "A1_Loc_R_3",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 12
    },
    {
      spawners = "Draugr_3_TURRET",
      spawnLocators = "A1_Loc_R_5",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 18
    }
  })
  Area_1_Encounter_2:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_PB_SFG",
      spawnLocators = "A1_Loc_R_7",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_2:SetAlertZone(GameObjects.EntZn_FirstFight_AlertZone)
  Area_1_Encounter_2:OnEnemyDeath(function()
    Area_1_Encounter_2:StartWave(2)
  end, {count = 3})
  Area_1_Encounter_2:OnComplete(Area_1_Encounter_2_Complete)
end
function Area_1_Encounter_2_Complete()
  timers.StartLevelTimer(3, function()
    TUT.SkillPointReminder_Tutorial()
  end)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Body")
end
function Troll_Area_1_Fight_4()
  Area_1_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 1]EC:4 Troll Fight Peak200", {
    AutoResetOnReload = true,
    CheckpointOnComplete = true,
    LeashZone = "LeashZone200_6"
  })
  Area_1_Encounter_4:AddWave({
    {
      spawners = "Troll00_BR_A",
      markerID = "Troll_Peak200",
      spawnLocators = "A1_Loc_OL_1",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_4:AddWave({
    prioritizeOnScreenSpawners = true,
    prioritizeSpawnersInRange = {11, 30},
    {
      spawners = "Draugr_PB_SFG",
      spawnLocators = "A1_Loc_O_*",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_PB_SFG",
      spawnLocators = "A1_Loc_O_*",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_1_Encounter_4:AddWave({
    prioritizeOnScreenSpawners = true,
    prioritizeSpawnersInRange = {8, 40},
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_2_ENCH_SFG",
      spawnLocators = "A1_Loc_O_*",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_2_ENCH_SFG",
      spawnLocators = "A1_Loc_O_*",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_1_Encounter_4:OnEnemySpawn(Troll_Health_Monitor, {
    markerID = "Troll_Peak200"
  })
  Area_1_Encounter_4:OnStart(function()
    if firstTrollFightStart == false then
      firstTrollFightStart = true
      game.Combat.TurnOnAndLockCombatStatus()
    end
    game.Compass.SetDesignerForcedHide(true)
  end)
  Area_1_Encounter_4:OnStart(function()
    timers.StartLevelTimer(5, function()
      Area_1_Encounter_4:AlertEnemies()
    end)
  end)
  Area_1_Encounter_4:OnComplete(Area_1_Encounter_4_Complete_Btr)
  Area_1_Encounter_4:OnEnemyDeath(peak200TrollDead, {
    markerID = "Troll_Peak200"
  })
  Area_1_Encounter_4:OnCombatStart(CheckCombatStateForTrollStartMusic)
end
function Area_1_Encounter_4_Complete_Btr()
  game.Compass.SetDesignerForcedHide(false)
  peak200TrollDead()
  game.World.StoreCheckpoint()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Weapon")
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Troll_Jarn_Fotr")
  local peak080 = game.FindLevel("Peak080_Global")
  if peak080 ~= nil then
    local banterScript = peak080:FindSingleGameObject("Peak080_Banter")
    if banterScript ~= nil then
      timers.StartLevelTimer(1.5, function()
        banterScript:CallScript("WheelReminder_Banter")
      end)
    end
  end
end
function Troll_Health_Monitor(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Troll_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.5
    local Health_Phase_2 = EnemyHealth * 0.25
    game.Audio.SetWwiseSwitch(Enemy, "CHR_Variation", "CHR_Variation_03")
    Troll_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_1_Encounter_4:StartWave(2)
    end)
    Troll_HealthMonitor:OnHealthLessThan(Health_Phase_2, function()
      Area_1_Encounter_4:StartWave(3)
    end)
  end
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Helwalkers in trap area Peak260", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone200_2"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Helwalker_S_DEAD_01",
      spawnLocators = "A2_Loc_O_3",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalker_S_DEAD_01",
      spawnLocators = "A2_Loc_O_4",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_2_Spawn"), {
    cineRequirement = {0, 295}
  })
  Flyer260AlertZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_2_Alert"))
  Flyer260AlertZoneMonitor:OnEnter(function()
    Area_2_Encounter_1:AlertEnemies()
    GameObjects.FlyerGeo2:HideCollision()
  end)
  Flyer260AlertZoneMonitor:SetTriggerCountLimit(1)
end
function Area_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 3]EC:1 Power Chest Draugr Statues Peak200", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone200_3",
    LoadCheck = true
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Draugr_DW_PB_STATUE",
      spawnLocators = "A3_Loc_O_2",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      markerID = "PowerBodyStatue",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_DW_PB_STATUE",
      spawnLocators = "A3_Loc_O_1",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      markerID = "PowerBodyStatue",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_3_Encounter_1:SetStartZone(thisLevel:GetGameObject("Zone_SpawnEnterRolleroom"), {
    cineRequirement = {0, 295}
  })
  Area_3_Encounter_1:SetAlertZone(GameObjects.Zone_SpawnTurretDraugr)
  Area_3_Encounter_1:OnStart(function()
    Area_1_Encounter_2:DespawnEnemies()
    Area_1_Encounter_2:SetComplete()
  end)
  Area_3_Encounter_1:OnComplete(Area_3_Encounter1_Complete)
  Area3AlertWaveZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("Zone_SpawnTurretDraugr"))
  Area3AlertWaveZoneMonitor:OnEnter(function()
    local wulverEat = LD.FindSingleAIByMarker("PowerBodyStatue")
    if wulverEat ~= nil then
      wulverEat:TriggerMoveEvent("kLEAlert")
    end
  end)
  Area3AlertWaveZoneMonitor:SetTriggerCountLimit(1)
end
function Area_3_Encounter1_Complete()
  if Area_3_Encounter_3:IsComplete() and Area_3_Encounter_1:IsComplete() then
    local peak080 = game.FindLevel("peak080_Global")
    peak080:CallScript("Btr_Cart_LookAt_Enable")
    peak080:CallScript("LeadTheWay_210LowFloor_Enable")
    print("ENCOUNTER COMPLETE")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Body")
    game.World.StoreCheckpoint()
  end
end
function TurretAmbush_Area_3_Fight_3()
  Area_3_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 3]EC:3 Ambush Peak200", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone200_3"
  })
  Area_3_Encounter_3:AddWave({
    {
      spawners = "Ambush_Draugr_PT_S_0",
      spawnLocators = "A3_Loc_U_5",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_3_Encounter_3:SetStartZone(thisLevel:GetGameObject("Zone_SpawnTurretDraugr"), {
    cineRequirement = {0, 295}
  })
  Area_3_Encounter_3:OnComplete(Area_3_Encounter1_Complete)
end
function EnhancedDraugrs_Area_3_Fight_4()
  Area_3_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 3]EC:4 Enhanced Enemies Peak200", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone200_7",
    LodLow = 70,
    LodHigh = 80
  })
  Area_3_Encounter_4:AddWave({
    {
      spawners = "Draugr_1_ENCH_PATROL",
      spawnLocators = "A3_Loc_U_4",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "Draugr_DW_STATUE",
      spawnLocators = "A3_Loc_U_8",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    }
  })
  Area_3_Encounter_4:SetStartZone(thisLevel:GetGameObject("EntZn_Area_3_EC_4_Spawn"), {
    cineRequirement = {0, 295}
  })
  Area_3_Encounter_4:SetAlertZone(GameObjects.EntZn_Area_3_EC_4_Alert)
  Area_3_Encounter_4:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Dual")
  end)
end
function EnhancedDraugrs_2_Area_3_Fight_4()
  Area_3_Encounter_5 = EC.NewEncounter(thisLevel, "[Area 3]EC:4 DualWield Draugr Peak200", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone200_7",
    LodLow = 70,
    LodHigh = 80
  })
  Area_3_Encounter_5:AddWave({
    {
      spawners = "Draugr_DW_STATUE",
      spawnLocators = "A3_Loc_U_6",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      markerID = "EDraugr",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_DW_STATUE",
      spawnLocators = "A3_Loc_U_7",
      spawnWad = "Peak200_AI_ChimneyLow_01",
      useSpawnLocatorsOnly = true,
      markerID = "EDraugr",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_3_Encounter_5:SetStartZone(thisLevel:GetGameObject("Zone_SpawnDWDraugr"), {
    cineRequirement = {0, 295}
  })
  Area_3_Encounter_5:SetAlertZone(GameObjects.Zone_SpawnAlertRolleroom02)
  Area_3_Encounter_5:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Dual")
  end)
end
function BanterAndCheckpoint()
  if Area_6_Encounter_1:IsComplete() and Area_6_Encounter_3:IsComplete() then
    GameObjects.Peak200_Banter.LuaObjectScript.ChimneyRoomRedux4_Banter()
    son:CallScript("LuaHook_ResetEnraged")
    game.World.StoreCheckpoint()
  end
end
function Draugr_Patrol_Fight()
  Area_6_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 3]EC:4 Draugr Patrol Peak200", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone200_5"
  })
  Area_6_Encounter_1:AddWave({
    {
      spawners = "Draugr_4_IDLE_STATUE",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      spawnLocators = "A1_Loc_P_1",
      useSpawnLocatorsOnly = true,
      markerID = "KillTarget",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4
    },
    {
      spawners = "Draugr_5_DW_PATROL",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      spawnLocators = "A1_Loc_P_3",
      useSpawnLocatorsOnly = true,
      markerID = "KillTarget",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.3
    },
    {
      spawners = "Draugr_4_DW_STATUE",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      spawnLocators = "A1_Loc_P_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_6_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Return_MainZone"), {
    cineRequirement = {450, 500}
  })
  Area_6_Encounter_1:SetAlertZone(GameObjects.EntZn_Return_AlertZone)
  Area_6_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Dual")
  end)
  Area_6_Encounter_1:OnComplete(BanterAndCheckpoint)
end
function Wolf_Patrol_Fight()
  Area_6_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 3]EC:4 Wolf Patrol Peak200", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone200_4"
  })
  Area_6_Encounter_3:AddWave({
    {
      spawners = "Wolf_4_EATING",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_3_POIS_EATING",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_6_Encounter_3:SetStartZone(thisLevel:GetGameObject("EntZn_Return_MainZone"), {
    cineRequirement = {450, 500}
  })
  Area_6_Encounter_3:SetAlertZone(GameObjects.EntZn_Return_AlertZone)
  Area_6_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Rabid")
  end)
  Area_6_Encounter_3:OnComplete(BanterAndCheckpoint)
end
function Wolf_Fight_Repop()
  Area_6_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 3]EC:4 Wolf Repopulation Peak200", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone200_4",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 3]EC:4 Wolf Patrol Peak200",
      "[Area 3]EC:4 Draugr Patrol Peak200"
    }
  })
  Area_6_Encounter_2:AddWave({
    {
      spawners = "Wolf_7_UNAWARE",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_8_UNAWARE",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Wolf_6_LAYING",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_6_Encounter_2:SetStartZone(thisLevel:GetGameObject("EntZn_Return_MainZone"), {
    cineRequirement = {450, 900}
  })
end
function Crawler_Return_Fight_TrapRoom()
  Area_6_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 3]EC:4 Crawler Return Trap Room Peak200", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone200_1"
  })
  Area_6_Encounter_3:AddWave({
    {
      spawners = "Crawler10_S",
      spawnLocators = "A8_Ret_Craw_3",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Crawler10_S",
      spawnLocators = "A8_Ret_Craw_4",
      spawnWad = "Peak200_AI_ChimneyLow_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_6_Encounter_3:SetStartZone(thisLevel:GetGameObject("EntZn_Return_Crawler210"), {
    cineRequirement = {450, 500}
  })
end
local combatEntered = 0
function CheckCombatStateForTrollStartMusic()
  combatEntered = combatEntered + 1
  if 1 < combatEntered and Area_1_Encounter_4:WavesComplete(1) == false then
    LD.StartCombatMusic("SND_MX_PEAK_big_troll_fight_in", "SND_fake_id")
  end
end
function peak200TrollDead()
  if peak200TrollMusic == false then
    game.Audio.StartMusic("SND_MX_PEAK_big_troll_fight_out")
    peak200TrollMusic = true
  end
end
function peak200TrollCS()
  if peak200TrollMusic == false then
    game.Audio.StartMusic("SND_MX_PEAK_big_troll_fight_cs_kill")
    peak200TrollMusic = true
  end
end
function peak200spawnclimbhole()
  if Area_1_Encounter_4:WavesComplete(1) == false then
    LD.StartCombatMusic("SND_MX_PEAK_big_troll_fight_in", "SND_fake_id")
  end
end
function DisableFirstVisitFights()
end
