local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local banterPlayed = {}
local ropeRoomReturn_Enabled = false
local crankClear = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  GameObjects.Btr_RopeRoomReturn01:HideEntityVolume()
end
function OnStart(level, obj)
  if ropeRoomReturn_Enabled and not banterPlayed.ropeRoomReturn02 and not banterPlayed.ropeRoomReturn03 then
    Enable_Btr_RopeRoomReturn02()
  else
    Disable_Btr_RopeRoomReturn02()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  savedInfo.ropeRoomReturn_Enabled = ropeRoomReturn_Enabled
  savedInfo.crankClear = crankClear
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
    ropeRoomReturn_Enabled = savedInfo.ropeRoomReturn_Enabled
    crankClear = savedInfo.crankClear
  end
end
function Btr_RopeRoomReturn01_Enable()
  GameObjects.Btr_RopeRoomReturn01:ShowEntityVolume()
  print("Show Banter Zone")
end
function EnableRopeRoomReturn()
  ropeRoomReturn_Enabled = true
  Enable_Btr_RopeRoomReturn02()
end
function Should_RopeRoomReturn01_Play()
  return ropeRoomReturn_Enabled and not banterPlayed.ropeRoomReturn03
end
function StartTimer_RopeRoomReturn02()
  timer.StartLevelTimer(60, function()
    if not banterPlayed.ropeRoomReturn03 and not banterPlayed.ropeRoomReturn02 then
      game.Audio.PlayBanterNonCritical("280_RopeRoomReturn02", function()
        banterPlayed.ropeRoomReturn02 = true
      end)
    end
  end)
end
function Enable_Btr_RopeRoomReturn02()
  GameObjects.Btr_RopeRoomReturn02:ShowEntityVolume()
end
function Disable_Btr_RopeRoomReturn02()
  GameObjects.Btr_RopeRoomReturn02:HideEntityVolume()
end
function RopeRoomReturn03_Played()
  banterPlayed.ropeRoomReturn03 = true
end
function CranePuzzleComplete()
  CranePuzzleComplete = true
end
function Disable_CartPeek()
  banterPlayed.foundCart = true
end
function Should_CartPeek_Play()
  if banterPlayed.foundCart then
    return false
  else
    return true
  end
end
function Should_ChimneyPeek_Play()
  if ropeRoomReturn_Enabled then
    return false
  else
    return true
  end
end
function OpenExit()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if not banterPlayed.OneMoreTry and not crankClear and 267 <= cineNum and cineNum < 270 then
    game.Audio.PlayBanter("175_OneMoreTry")
    banterPlayed.OneMoreTry = true
  end
end
function PullCrank()
  if not banterPlayed.ropeRoomReturn03 and game.Level.GetVariable("CompletedCineNumber") >= 267 then
    if not banterPlayed.RopeStuckB_Intro then
      timer.StartLevelTimer(1, function()
        game.Audio.PlayBanter("180_RopeStuckB_Intro")
        banterPlayed.RopeStuckB_Intro = true
      end)
    elseif not banterPlayed.RopeStuckB_SecondTry then
      timer.StartLevelTimer(1, function()
        game.Audio.PlayBanter("180_RopeStuckB_SecondTry")
        banterPlayed.RopeStuckB_SecondTry = true
      end)
    elseif not banterPlayed.RopeStuckB_ThirdTry then
      timer.StartLevelTimer(1, function()
        game.Audio.PlayBanter("180_RopeStuckB_ThirdTry")
        banterPlayed.RopeStuckB_ThirdTry = true
      end)
    end
  end
end
function ShouldRopeStuckCPlay()
  return not banterPlayed.ropeRoomReturn03 and game.Level.GetVariable("CompletedCineNumber") >= 267
end
function ShouldBrokenCrankPeak_Play()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 310 <= cineNum and cineNum < 500 then
    return true
  end
end
function PlayRopeStuckCOutro()
  if not banterPlayed.RopeStuckB_Intro then
    game.Audio.PlayBanter("210_RopeStuckC_UnclearPassage")
  else
    game.Audio.PlayBanter("210_RopeStuckC_ClearPassage")
  end
end
function ChimneyRoomRedux4_Banter()
  if not banterPlayed.ChimneyRoomRedux4 then
    game.Audio.PlayBanter("090_ChimneyRoomRedux4")
    banterPlayed.ChimneyRoomRedux4 = true
  end
end
