local LD = require("design.LevelDesignLibrary")
local CCOS = require("camera.camera_oneshot")
uiCalls = require("ui.uicalls")
local thisLevel, player, peak205, ChiselElevator, ElevatorManager, pad, camOneShot_LimitedUp
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  pad = player.Pad
  SoundInit()
  ChiselElevator = level:GetGameObject("ChiselDungeon_Elevator")
  ElevatorManager = ChiselElevator:FindSingleGOByName("ElevatorManager")
end
function OnFirstStart(level)
  GameObjects.Peak203_ChiselArena_Up:HideEntityVolume()
  GameObjects.Peak203_ChiselArena_Down:HideEntityVolume()
end
function OnStart(level)
  SoundOnStart()
end
function OnUpdate(level)
  if camOneShot_LimitedUp ~= nil then
    camOneShot_LimitedUp:Update()
  end
end
function DestroyOneShot_LimitedUp()
  camOneShot_LimitedUp = nil
end
function StartCamera_LimitedUp()
  camOneShot_LimitedUp = CCOS.OneShotCamera.New("PLYR_Elevator_LimitedUp", 30)
  camOneShot_LimitedUp:SetCallback(DestroyOneShot_LimitedUp)
  camOneShot_LimitedUp:Start()
end
function LoadCheckPeak200()
  game.UI.LoadCheck("Peak200_ChimneyLow")
end
function LoadCheckPeak205()
  game.UI.LoadCheck("Peak205_ChiselArena")
end
function ClearSlowWalk()
  player:ClearMaxSpeedOverride()
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function JumpElevator()
  ElevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  ElevatorManager.LuaObjectScript.JumpToTopFloor()
end
function ElevatorGoingDown()
  StartCamera_LimitedUp()
  GameObjects.Peak203_ArenaPreload:HideEntityVolume()
  GameObjects.Peak203_ChiselArena_Up:HideEntityVolume()
  GameObjects.Peak203_ChiselArena_Down:ShowEntityVolume()
end
function ElevatorGoingUp()
  StartCamera_LimitedUp()
  GameObjects.Peak203_ArenaPreload:ShowEntityVolume()
  GameObjects.Peak203_ChiselArena_Up:ShowEntityVolume()
  GameObjects.Peak203_ChiselArena_Down:HideEntityVolume()
end
function OnEvaluateLoadGroup_AIWads()
  if game.Level.GetVariable("PEAK_ChimneyPhase") == 1 and game.Level.GetVariable("CompletedCineNumber") < 450 then
    return "AIWadsFirstEntry"
  elseif game.Level.GetVariable("PEAK_ChimneyPhase") == 2 and game.Level.GetVariable("CompletedCineNumber") < 450 then
    return "AIWadsRoller"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 450 then
    return "AIWadsReturn"
  end
end
function Peak205_LTW_Enable()
  local peak205 = game.FindLevel("Peak205_ChiselArena")
  if peak205 ~= nil then
    peak205:CallScript("LTW_Lobby_Enable", "CA_Lobby_Enable")
  end
end
function Peak205_LTW_Disable()
  local peak205 = game.FindLevel("Peak205_ChiselArena")
  if peak205 ~= nil then
    peak205:CallScript("LTW_Lobby_Disable", "CA_Lobby_Disable")
  end
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Peakspass Chisel Dungeon")
  ChiselLabor()
end
function ChiselLabor()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Open_Peaks")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Open_Peaks")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Open", 1)
  end
end
local elevatorManagerObject
local elevatorSoundOverride = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1
}
function SoundInit()
  elevatorManagerObject = thisLevel:GetGameObject("ElevatorManager")
  elevatorSoundOverride.SoundEmitter = elevatorManagerObject.Parent:FindSingleSoundEmitterByName("SNDChiselElevator")
end
function SoundOnStart()
  elevatorManagerObject.LuaObjectScript.SoundSetup(elevatorSoundOverride)
end
