local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local EC = require("design.Encounter")
local thisLevel, player, enc_Valkyrie_Evader, Valkyrie_Evader_monitor
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  Fnc_Valkyrie_Fight()
end
function Fnc_Valkyrie_Fight()
  enc_Valkyrie_Evader = EC.NewEncounter(thisLevel, "[Arena]EC: Valkyrie Fight Peak205", {
    CheckpointOnComplete = false,
    LoadCheck = false,
    LeashZone = "LshZn_Peak205_Valk"
  })
  enc_Valkyrie_Evader:AddWave({
    {
      spawners = "Valkyrie00_Defender_SSD",
      spawnWad = "Peak205_ChiselArena",
      markerID = "Valkyrie_Peak205",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  enc_Valkyrie_Evader:OnComplete(function()
    _G.SetEncounterComplete()
    _G.CA_Arena_Enable()
    _G.LTW_Lobby_Enable()
    GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Disable()
  end)
  enc_Valkyrie_Evader:SetStartZone(GameObjects.EntZn_Valkyrie_Spawn)
  enc_Valkyrie_Evader:SetAlertZone(GameObjects.EntZn_Valkyrie_Alert)
end
