local LD = require("design.LevelDesignLibrary")
checkpoint = require("level.checkpoint")
local thisLevel, player, camZoneRollerExitHint, camZoneRollerOutsideHint
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  camZoneRollerExitHint = level:GetGameObject("CamZoneRollerExitHint")
  camZoneRollerOutsideHint = level:GetGameObject("CamZoneRollerOutsideHint")
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") > 310 then
    GameObjects.Son_RopeDrop2.LuaObjectScript.Enable()
  end
end
function OnUpdate(level)
  if game.Level.GetVariable("PEAK_RopeBroken") == false then
    if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_RollerPreBreak") then
      game.Camera.SubmitCameraByName("PLYR_Peak_RollerPush_000_PreBreak")
    end
    if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_RollerPreBreak_Hint") then
      game.Camera.SubmitCameraByName("PLYR_Peak_RollerPush_000_PreBreak_Hint")
    end
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function SpawnGoblinPeak200()
  thisLevel:FindSingleGameObject("GoblinController").LuaObjectScript.ActivateGoblin()
end
function DespawnGoblinPeak200()
  thisLevel:FindSingleGameObject("GoblinController").LuaObjectScript.DeactivateGoblin()
end
function HideRolleZoneExitHint()
  camZoneRollerExitHint:HideCameraVolume()
  camZoneRollerOutsideHint:ShowCameraVolume()
end
function BreakableFloorDestroy()
  LD.BreakObject(GameObjects.BreakableFloor1)
  LD.BreakObject(GameObjects.BreakableFloor2)
end
function HideGate()
  GameObjects.LiftGate_Huodini:Hide()
end
function SCA_RopeDown_Down_Enable()
  GameObjects.SCA_RopeDown_Down.LuaObjectScript.Enable()
end
function SCA_RopeDown_Up_Enable()
  GameObjects.SCA_RopeDown_Up.LuaObjectScript.Enable()
end
function OnEvaluateLoadGroup_AIWads()
  if game.Level.GetVariable("PEAK_ChimneyPhase") == 1 and game.Level.GetVariable("CompletedCineNumber") < 450 then
    return "AIWadsFirstEntry"
  elseif game.Level.GetVariable("PEAK_ChimneyPhase") == 2 and game.Level.GetVariable("CompletedCineNumber") < 450 then
    return "AIWadsRoller"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 450 then
    return "AIWadsReturn"
  end
end
function Peak210_CraneCartPuzzleSolved()
  GameObjects.Son_RopeDrop2.LuaObjectScript.ActivateRopeDrop()
end
