local thisObj
local tCollisionDefinition = {
  standard = "Traps_CrusherBlock_Standard_Horizontal",
  instantKill = "Traps_CrusherBlock_InstantKill_Horizontal"
}
local currentCombatCollision
local enabled = true
function OnScriptLoaded(level, obj)
  thisObj = obj
  currentCombatCollision = tCollisionDefinition.standard
  game.SubObject.SetForgetOnCheckpoint(thisObj)
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  SetToInstantKill(false)
end
function Enable()
  enabled = true
  game.Combat.AddSubObjectCombatCollision(thisObj, currentCombatCollision)
end
function Disable()
  enabled = false
  game.Combat.RemoveSubObjectCombatCollision(thisObj, currentCombatCollision)
end
function SetToInstantKill(instantKill_ON)
  if enabled == false then
    return
  end
  local stringCollisionType = tCollisionDefinition.standard
  if instantKill_ON == true then
    stringCollisionType = tCollisionDefinition.instantKill
  end
  game.Combat.RemoveSubObjectCombatCollision(thisObj, currentCombatCollision)
  game.Combat.AddSubObjectCombatCollision(thisObj, stringCollisionType)
  currentCombatCollision = stringCollisionType
end
