local timers = require("level.timer")
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  banterPlayed = savedInfo.banterPlayed
end
function SpearTrapPart1_Banter()
  if not banterPlayed.SpearTrapPart1 then
    timers.StartLevelTimer(2, function()
      game.Audio.PlayBanter("235_SpearTrapPart1")
    end)
    banterPlayed.SpearTrapPart1 = true
    Hide_AloneInTheDarkBanter()
  end
end
function SpearTrapPart2_Banter()
  if not banterPlayed.SpearTrapPart2 then
    game.Audio.PlayBanter("238_SpearTrapPart2")
    banterPlayed.SpearTrapPart2 = true
  end
end
function Hide_AloneInTheDarkBanter()
  GameObjects.BtrZone_AloneInTheDark_Timed:Hide()
  GameObjects.BanterTimer_AloneInTheDark.LuaObjectScript.Cancel()
end
