local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kratosActor, sonActor, lanternObj, flintObj, lightObj, preCineCam, cine_lights_270
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  preCineCam = CCEC.CineEnterCamera.New("ENV_CineEnter_narPeakSkyLantern000Cine", 8)
  preCineCam:SetObjectToSleep(obj)
end
function OnStart(level, obj)
  SetupActorsAndProps()
  cine_lights_270 = GameObjects.Cine_Start_270
  HideCineLights()
  if game.Level.GetVariable("CompletedCineNumber") < 270 then
    lanternObj:Show()
  else
    lanternObj:Hide()
    HideNoGoZone()
    HideSpeedControlZone()
  end
end
function OnUpdate(level, obj)
  if preCineCam ~= nil then
    preCineCam:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function SetupActorsAndProps()
  kratosActor = actor.Actor.New("SKY LANTERN: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SKY LANTERN: Son Actor", game.AI.FindSon)
  lanternObj = GameObjects.lantern00_Top.Child
  lanternObj:StartAnim("narPeakSkyLantern000Cine")
  lanternObj:JumpAnimToFrame(0)
  lanternObj:PauseAnim()
  flintObj = GameObjects.flint00A.Child
  flintObj:Hide()
end
function HideProps()
  lanternObj:Hide()
  flintObj:Hide()
end
function HideNoGoZone()
  GameObjects.NoGoZone_SkyLantern:Hide()
end
function HideSpeedControlZone()
  GameObjects.SpeedControlZone_SkyLantern:Hide()
end
function SetupCineSequence()
  if game.Level.GetVariable("CompletedCineNumber") < 270 then
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Sky Lantern Sequence")
    local table = {
      {
        Actor = sonActor,
        Branch = "BRA_SkyLantern"
      },
      {
        Obj = lanternObj,
        Anim = "narPeakSkyLantern000Cine"
      },
      {
        Obj = flintObj,
        Anim = "narPeakSkyLantern000Cine"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_PEAK_start_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:RequestCineModeAndWait(kratosActor, thisObj)
    cineSeq:Do(function()
      game.Player.FindPlayer():SetDecelerationOverride(1.2)
    end)
    cineSeq:Do(function()
      preCineCam:Start()
    end)
    cineSeq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_SkyLantern",
      ReferenceJoint = "SkyLantern_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kRight,
      radius = ND.ArrivalRadius,
      weapon_state = "bare"
    })
    cineSeq:Do(PlayCineLights)
    cineSeq:Do(function()
      flintObj:Show()
    end)
    cineSeq:ActorSync(kratosActor, {
      Slaves = table,
      Branch = "BRA_SkyLantern",
      ReferenceJoint = "SkyLantern_SynchJoint"
    })
    cineSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    cineSeq:StopPuppetingActor(kratosActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:Do(function()
      game.Player.FindPlayer():ClearDecelerationOverride()
    end)
    cineSeq:Do(HideSpeedControlZone)
    cineSeq:Do(HideProps)
    cineSeq:Do(HideCineLights)
    cineSeq:Do(HideNoGoZone)
    cineSeq:SetCompletedCineNumber(270)
    cineSeq:WaitSeconds(1)
    cineSeq:Do(Quest_PeaksPass_Objective275_End)
    cineSeq:Do(function()
      GameObjects.SCA_Fire01Reveal_React.LuaObjectScript.Enable()
    end)
    cineSeq:Do(function()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "09_PeaksPass_030_ChimneyMid"]
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
    cineSeq:StartSequence()
  end
end
function PlayCineLights()
  cine_lights_270:Show()
  cine_lights_270:JumpAnimToFrame(0)
  cine_lights_270:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_270:Hide()
end
function Quest_PeaksPass_Objective275_End()
  game.QuestManager.ProposeQuestState("Quest_PeaksPass_Objective275", "Complete")
  game.Compass.SetDesignerForcedHide(false)
end
