local timers = require("level.timer")
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  banterPlayed = savedInfo.banterPlayed
end
function FireTrap1_A_Banter()
  if not banterPlayed.FireTrap1_A then
    game.Audio.PlayBanter("342_FireTrap1_A")
    banterPlayed.FireTrap1_A = true
  end
end
function FireTrap1_A2_Banter()
  timers.StartLevelTimer(2.5, function()
    if not banterPlayed.FireTrap1_A2 then
      game.Audio.PlayBanter("342_FireTrap1_A2")
      banterPlayed.FireTrap1_A2 = true
    end
  end)
end
function FireTrap2_Banter()
  if not banterPlayed.FireTrap2 then
    game.Audio.PlayBanter("342_FireTrap2")
    banterPlayed.FireTrap2 = true
  end
end
function TunnelRat_Banter()
  if not banterPlayed.TunnelRat then
    game.Audio.PlayBanter("345_TunnelRat")
    banterPlayed.TunnelRat = true
  end
end
function ScaryGoRound_Banter()
  if not banterPlayed.ScaryGoRound then
    timers.StartLevelTimer(1.75, function()
      game.Audio.PlayBanter("346_ScaryGoRound")
      banterPlayed.ScaryGoRound = true
    end)
  end
end
function PostScaryGoRound_Banter()
  if not banterPlayed.PostScaryGoRound then
    timers.StartLevelTimer(0.1, function()
      game.Audio.PlayBanter("348_PostScaryGoRound01")
      banterPlayed.PostScaryGoRound = true
    end)
  end
end
