local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local timer = require("level.timer")
local color = require("core.color")
local camCollisionCheck = require("camera.collisioncheck")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local player
local warpoffset = engine.Vector.New(2, 0, 2)
local thisLevel, Area_1_Encounter_1, Area_1_Encounter_2
local numPlayersInsideFire01 = 0
local encountersComplete = 0
local sonCrawlPastFireSpinned = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  TurretDraugr_01()
  TurretDraugr_02()
end
function OnPreStart(level)
  GameObjects.Turret_Sprayer_Base.LuaObjectScript.AttachObject(GameObjects.coffin_tier3_peak300_1)
end
function OnFirstStart(level)
  GameObjects.Zone_Fire01:HideEntityVolume()
  GameObjects.Btr_SecondElevatorApproach:HideEntityVolume()
  GameObjects.Zone_Checkpoint_17:HideEntityVolume()
  SoundOnFirstStart()
end
function OnUpdate(level)
  if player:IsInsideEntityZone("Dbg_ZoneSonWarp") then
    game.AI.FindSon():Warp(player:GetWorldPosition() + warpoffset, player:GetWorldForward())
  end
end
function TurretDraugr_01()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Turret Draugr 1 Peak300", {CheckpointOnComplete = false})
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr00_Projectile1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:OnStart(Area_1_Encounter_1_Start)
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("Zone_ProjectileEnemy1"))
  Area_1_Encounter_1:OnComplete(Area_1_Encounter_1_Complete)
end
function Area_1_Encounter_1_Start()
  print("SWAP COMBAT SCA STUFF")
end
function Area_1_Encounter_1_Complete()
  encountersComplete = encountersComplete + 1
  print("encountersComplete = " .. tostring(encountersComplete))
  if encountersComplete == 2 then
    GameObjects.Zone_Checkpoint_17:ShowEntityVolume()
    local peak380 = game.FindLevel("peak380_BigElevator")
    peak380:CallScript("Zone_ElevatorHintTimerStart_Enable")
  end
end
function TurretDraugr_02()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 Turret Draugr 2 Peak300", {CheckpointOnComplete = false})
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Draugr00_Projectile2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_2:SetStartZone(thisLevel:GetGameObject("Zone_ProjectileEnemy2"))
  Area_1_Encounter_2:OnComplete(Area_1_Encounter_2_Complete)
end
function Area_1_Encounter_2_Complete()
  encountersComplete = encountersComplete + 1
  print("encountersComplete = " .. tostring(encountersComplete))
  if encountersComplete == 2 then
    GameObjects.Zone_Checkpoint_17:ShowEntityVolume()
    local peak380 = game.FindLevel("peak380_BigElevator")
    peak380:CallScript("Zone_ElevatorHintTimerStart_Enable")
  end
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
function ElevatorSpoolAnimate()
  GameObjects.Machine300_guts.Child:PlayAnimToEnd()
end
function FireRevealStart(level)
  GameObjects.Zone_Fire01:ShowEntityVolume()
  timer.StartLevelTimer(0.1, function()
    GameObjects.Peak300_Banter.LuaObjectScript.FireTrap1_A_Banter()
  end)
  timer.StartLevelTimer(3.5, function()
    GameObjects.SpeedControl_FireReveal:Hide()
  end)
end
function KratosArrivesFire01()
  GameObjects.SCA_Fire01Reveal_React.LuaObjectScript.Disable()
  timer.StartLevelTimer(0.75, function()
    GameObjects.Peak300_Banter.LuaObjectScript.FireTrap2_Banter()
  end)
end
function FireTrap01_Enter()
  numPlayersInsideFire01 = numPlayersInsideFire01 + 1
  print("numPlayersInsideFire01 = " .. tostring(numPlayersInsideFire01))
  if numPlayersInsideFire01 == 1 then
    GameObjects.SprayerNozzle_Fire01.LuaObjectScript.Enable()
  end
end
function FireTrap01_Exit()
  numPlayersInsideFire01 = numPlayersInsideFire01 - 1
  print("numPlayersInsideFire01 = " .. tostring(numPlayersInsideFire01))
  if numPlayersInsideFire01 == 0 then
    GameObjects.SprayerNozzle_Fire01.LuaObjectScript.SoftDisable()
  end
end
function SpeedControlFireReveal_Disable()
end
local timerToStartNozzle02A, timerToStartNozzle02B, timerToStartNozzle02C
local FlameSet2_Enabled = false
function FlameSet2_Loop()
  GameObjects.Peak300_Banter.LuaObjectScript.FireTrap1_A2_Banter()
  if not FlameSet2_Enabled then
    FlameSet2_Enabled = true
    GameObjects.SprayerNozzle_Fire02C.LuaObjectScript.Enable(1)
    GameObjects.SprayerNozzle_Fire02B.LuaObjectScript.Enable(1.5)
    GameObjects.SprayerNozzle_Fire02A.LuaObjectScript.Enable(2)
  end
end
function DisableFlameSet2()
  GameObjects.SprayerNozzle_Fire02A.LuaObjectScript.SoftDisable()
  GameObjects.SprayerNozzle_Fire02B.LuaObjectScript.SoftDisable()
  GameObjects.SprayerNozzle_Fire02C.LuaObjectScript.SoftDisable()
  FlameSet2_Enabled = false
end
function FireSprayer02A_Disable()
  GameObjects.SprayerNozzle_Fire02A.LuaObjectScript.SoftDisable()
end
function FireSprayer02B_Disable()
  GameObjects.SprayerNozzle_Fire02B.LuaObjectScript.SoftDisable()
end
function FireSprayer02C_Disable()
  GameObjects.SprayerNozzle_Fire02C.LuaObjectScript.SoftDisable()
end
function DisableCinematicGuides()
  GameObjects.CinematicGuides:HideCollision()
end
function EnableFireTrap()
  GameObjects.Turret_Sprayer_Base.LuaObjectScript.Enable()
  GameObjects.Turret_Sprayer_Base.LuaObjectScript.Expose()
  GameObjects.SprayerNozzle_Fire01.LuaObjectScript.SoftDisable()
  GameObjects.Peak300_Banter.LuaObjectScript.ScaryGoRound_Banter()
  timer.StartLevelTimer(1.25, function()
    GameObjects.SCA_WaitForKratos_FireSpinner.LuaObjectScript.Enable()
    GameObjects.SCA_WaitForKratos_PreFireSpinner.LuaObjectScript.Disable()
  end)
end
function DisableFireTrap()
  GameObjects.Turret_Sprayer_Base.LuaObjectScript.Disable()
  GameObjects.Turret_Sprayer_Base.LuaObjectScript.Lock()
  GameObjects.SCA_WaitForKratos_FireSpinner.LuaObjectScript.Disable()
  GameObjects.SCA_WaitForKratos_PreFireSpinner.LuaObjectScript.Enable()
  GameObjects.NavObstacle_FlameSpinner:HideNavObstacle()
end
function ForceSonRemoveCombat()
  local availabilityState = {AvailableForCombat = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  print("REMOVE SON FROM COMBAT")
end
function ExitCubbyHole()
  GameObjects.Btr_SecondElevatorApproach:ShowEntityVolume()
  GameObjects.CrawlSpaceManager02.LuaObjectScript.Disable()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  GameObjects.SCA_CubbyHoleExit.LuaObjectScript.Enable()
  print("SON EXIT CUBBY HOLE ON ELEVATOR SIDE")
end
function DisableResurrection()
  player:CallScript("LuaHook_DisableRevive", true)
  print("DISABLE REZ")
end
function EnableResurrection()
  player:CallScript("LuaHook_DisableRevive", false)
  print("ENABLE REZ")
end
function Spline_LeadTheWay_ToElevator_Disable()
  GameObjects.LeadTheWay_ToElevator.LuaObjectScript.Disable()
end
local flameThrowerDrivenObjectSound = {
  SoundEmitter = nil,
  OnForward = "SND_TRAP_Flamethrower_Moving_LP",
  OnForwardFrame = -1,
  OnBackward = "SND_TRAP_Flamethrower_Moving_LP",
  OnBackwardFrame = -1
}
function SoundOnFirstStart()
  flameThrowerDrivenObjectSound.SoundEmitter = GameObjects.Turret_Sprayer_Base.Child.SoundEmitters[1]
  GameObjects.WheelCrank_PeaksPass.LuaObjectScript.DrivenObjectSoundSetup(flameThrowerDrivenObjectSound)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
