local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local thisObj, thisLevel, player
local counterweightsPushed = 0
local leftWeightPushed = false
local rightWeightPushed = false
local debugWarp = false
onElevator = 0
local sCA_HintTimer01, sCA_HintTimer02_A, sCA_HintTimer02_B
postStuck00HintTimer = nil
postStuck01HintTimer = nil
local dragonElevator
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  sCA_HintTimer01 = timers.StartLevelTimer(30, GiveElevatorHint01)
  sCA_HintTimer01:Stop()
  sCA_HintTimer02_A = timers.StartLevelTimer(35, GiveElevatorHint02_A)
  sCA_HintTimer02_A:Stop()
  sCA_HintTimer02_B = timers.StartLevelTimer(15, GiveElevatorHint02_B)
  sCA_HintTimer02_B:Stop()
  postStuck00HintTimer = timers.StartLevelTimer(15, Stuck00_BanterHintPlay)
  postStuck00HintTimer:Stop()
  postStuck01HintTimer = timers.StartLevelTimer(14, Stuck01_BanterHintPlay)
  postStuck01HintTimer:Stop()
  dragonElevator = GameObjects.DragonElevator.Child
  SoundInit()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  GameObjects.CollisionToggle:HideCollision()
  GameObjects.DeathPlane01:Hide()
  GameObjects.DeathPlane02:Hide()
  GameObjects.DeathPlane03:Hide()
  GameObjects.DeathPlane04a:Hide()
  GameObjects.DeathPlane04b:Hide()
  GameObjects.DeathPlane05:Hide()
  GameObjects.DeathPlane06:Hide()
  GameObjects.FX_Platform_Scrape1:HideParticleEmitter()
  GameObjects.FX_Platform_Scrape2:HideParticleEmitter()
  GameObjects.FX_Platform_Scrape3:HideParticleEmitter()
  GameObjects.Zone_ElevatorHintTimerStart:HideEntityVolume()
  GameObjects.CollisionWallsDragon:HideCollision()
  StartIdle_00()
  dragonElevator:FindSingleGOByName("TraverseLink1_2m"):HideTraverseLink()
  dragonElevator:FindSingleGOByName("TraverseLink2_2m"):HideTraverseLink()
end
function OnStart(level, obj)
  GameObjects.BasicTNFObject_Stuck00.LuaObjectScript.SetUseLinkJointForPrompt(true)
  GameObjects.BasicTNFObject_Stuck01.LuaObjectScript.SetUseLinkJointForPrompt(true)
end
function Debug_All()
  GameObjects.CollisionToggle:ShowCollision()
  local cw1 = GameObjects.Counterweight01
  cw1.LuaObjectScript.Disable()
  cw1:Hide()
  cw1:HideCollision()
  local cw2 = GameObjects.Counterweight02
  cw2.LuaObjectScript.Disable()
  cw2:Hide()
  cw2:HideCollision()
  LD.CallFunctionAfterDelay(function()
    player:Warp(GameObjects.BasicTNFObject_Stuck00.WorldPosition, player:GetWorldForward())
    game.AI.FindSon():Warp(GameObjects.BasicTNFObject_Stuck00.WorldPosition, game.AI.FindSon():GetWorldForward())
  end, 0.25)
end
function Debug_SkipToFirstTnf()
  if not _G.debug_bool then
    _G.debug_bool = true
    Debug_All()
    dragonElevator:StartAnim("Peak380_ElevatorStuck1Idle")
    EnableStuckTnF00()
    dragonElevator:PlayAnimCycle()
  end
end
function Debug_SkipToSecondTnf()
  if not _G.debug_bool then
    _G.debug_bool = true
    Debug_All()
    dragonElevator:StartAnim("Peak380_ElevatorStuck2Idle")
    EnableStuckTnF01()
    dragonElevator:PlayAnimCycle()
  end
end
function Debug_SkipToDragonIntro()
  if not _G.debug_bool then
    _G.debug_bool = true
    Debug_All()
    StartDragonTransition()
    dragonElevator:JumpAnimToPercent(0.99)
    EndElevatorRide_StartDragonBoss()
  end
end
function OnElevator()
  onElevator = onElevator + 1
  print("onElevator = " .. tostring(onElevator))
end
function OffElevator()
  onElevator = onElevator - 1
  print("onElevator = " .. tostring(onElevator))
end
function ElevatorHint01Start()
  sCA_HintTimer01:Start()
end
function ElevatorHint01Stop()
  sCA_HintTimer01:Stop()
end
function GiveElevatorHint01()
  if onElevator == 2 then
    GameObjects.Peak380_Banter.LuaObjectScript.SecondElevator_Idle02_Banter()
    print("MAYBE WE'RE TOO HEAVY")
  else
    GameObjects.Peak380_Banter.LuaObjectScript.SecondElevator_Idle01_Banter()
    print("WE SHOULD USE THE LIFT")
  end
end
function ElevatorHint02_A_Start()
  sCA_HintTimer02_A:Start()
end
function ElevatorHint02_A_Stop()
  sCA_HintTimer02_A:Stop()
end
function GiveElevatorHint02_A()
  GameObjects.Peak380_Banter.LuaObjectScript.SecondElevator_Idle02_Banter()
  print("MAYBE WE'RE TOO HEAVY")
end
function ElevatorHint02_B_Start()
  sCA_HintTimer02_B:Start()
end
function ElevatorHint02_B_Stop()
  sCA_HintTimer02_B:Stop()
end
function GiveElevatorHint02_B()
  GameObjects.Peak380_Banter.LuaObjectScript.SecondElevator_Idle01_Banter()
  print("WE SHOULD USE THE LIFT")
end
function EnableCounterweight01()
  GameObjects.Counterweight01.LuaObjectScript.Enable()
end
function PlayerAttachedToPushBlock()
  dragonElevator:FindSingleGOByName("SonWarpModule").LuaObjectScript.WarpSon()
end
function CounterweightLeft_Pushed()
  LD.CallFunctionAfterDelay(function()
    leftWeightPushed = true
    PlayElevatorRunningSounds()
    local peak300 = game.FindLevel("peak300_ChimneyMid")
    peak300:CallScript("Spline_LeadTheWay_ToElevator_Disable")
    _G.SCA_ElevatorIdleBehavior_03_Enable()
    local camerashakeeffect_pushoff = {
      EffectName = "FSE_SHAKE_SPREAD_WINGS",
      Duration = 1,
      TweenInTime = 0.2,
      TweenOutTime = 0.3
    }
    game.FX.SubmitEffect(camerashakeeffect_pushoff)
    if rightWeightPushed == false then
      FirstPushFunctionality()
      dragonElevator:StartAnim("Peak380_ElevatorLvl0StoneA")
      dragonElevator:PlayAnimToEnd(0.7)
      dragonElevator:OnAnimDone(thisObj, "StartIdle_01")
      GameObjects.peak300_loop_braziers_00:JumpAnimationToPercent(0)
      GameObjects.peak300_loop_braziers_00:PlayAnimationToEnd()
    else
      SecondPushFunctionality()
      dragonElevator:StartAnim("Peak380_ElevatorLvl1StoneA")
      dragonElevator:PlayAnimToEnd(0.85)
      dragonElevator:OnAnimDone(thisObj, "StartStuck_01")
      GameObjects.peak300_loop_braziers_00:JumpAnimationToPercent(0)
      GameObjects.peak300_loop_braziers_00:PlayAnimationCycle()
    end
    GameObjects.CollisionToggle:ShowCollision()
    GameObjects.Counterweight01.LuaObjectScript.StopAllLoopingSounds()
    GameObjects.CamZone_Pushblock_Left:HideCameraVolume()
    WatchCounterweightFall()
    GameObjects.Counterweight01.Child:OnAnimDone(thisObj, "HideLeftCounterweight")
  end, 1)
end
function HideLeftCounterweight()
  GameObjects.Counterweight01:ClearAllAnimCallbacks()
  GameObjects.Counterweight01:Hide()
end
function CounterweightRight_Pushed()
  LD.CallFunctionAfterDelay(function()
    rightWeightPushed = true
    PlayElevatorRunningSounds()
    _G.SCA_ElevatorIdleBehavior_03_Enable()
    local peak300 = game.FindLevel("peak300_ChimneyMid")
    peak300:CallScript("Spline_LeadTheWay_ToElevator_Disable")
    local camerashakeeffect_pushoff = {
      EffectName = "FSE_SHAKE_SPREAD_WINGS",
      Duration = 1,
      TweenInTime = 0.2,
      TweenOutTime = 0.3
    }
    game.FX.SubmitEffect(camerashakeeffect_pushoff)
    if leftWeightPushed == false then
      FirstPushFunctionality()
      dragonElevator:StartAnim("Peak380_ElevatorLvl0StoneB")
      dragonElevator:PlayAnimToEnd(0.7)
      dragonElevator:OnAnimDone(thisObj, "StartIdle_01")
      GameObjects.peak300_loop_braziers_00:JumpAnimationToPercent(0)
      GameObjects.peak300_loop_braziers_00:PlayAnimationToEnd()
    else
      SecondPushFunctionality()
      dragonElevator:StartAnim("Peak380_ElevatorLvl1StoneB")
      dragonElevator:PlayAnimToEnd(0.85)
      dragonElevator:OnAnimDone(thisObj, "StartStuck_01")
      GameObjects.peak300_loop_braziers_00:JumpAnimationToPercent(0)
      GameObjects.peak300_loop_braziers_00:PlayAnimationCycle()
    end
    GameObjects.CollisionToggle:ShowCollision()
    GameObjects.Counterweight02.LuaObjectScript.StopAllLoopingSounds()
    GameObjects.CamZone_Pushblock_Right:HideCameraVolume()
    WatchCounterweightFall()
    GameObjects.Counterweight02.Child:OnAnimDone(thisObj, "HideRightCounterweight")
  end, 1)
end
function HideRightCounterweight()
  GameObjects.Counterweight02:ClearAllAnimCallbacks()
  GameObjects.Counterweight02:Hide()
end
function CreateWallCollisionMonitor()
  local wallHitCollisionMonitor = monitors.CreateAnimFrameMonitor(dragonElevator)
  wallHitCollisionMonitor:OnFrameForward(567, PlayStuckSound)
  wallHitCollisionMonitor:OnFrameForward(1040, StartWallGrind)
  wallHitCollisionMonitor:OnFrameForward(1095, EndWallGrind)
  wallHitCollisionMonitor:OnFrameForward(1771, StartWallHit02)
  LD.CallFunctionAfterDelay(function()
    wallHitCollisionMonitor:OnFrameForward(1830, function()
      StopWallHit02(wallHitCollisionMonitor)
    end)
  end, 0.5)
end
function StartWallGrind()
  Encounter01_Start()
  dragonElevator:SetAnimRate(0.15)
  GameObjects.elevator_scrape_01_break.Child:PlayAnimToEnd()
  GameObjects.FX_Platform_Scrape3:ShowParticleEmitter()
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_GIANT",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1.2},
    Priority = 1920
  })
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_LARGE",
    Duration = 4,
    TweenIn = {Time = 0.2},
    TweenOut = {Time = 7},
    Priority = 1910
  })
  LD.AddControllerRumble({Duration = 1, EffectName = "FFB_GIANT"})
  game.Blender.Trigger({
    Name = "FFB_TINY",
    Duration = 12,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.25}
  })
  PlayElevatorScrapingSound(1)
  _G.SCA_ElevatorIdleBehavior_03_Disable()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "ALERT_BEHAVIOR_CONTEXT_CONFIG")
end
function EndWallGrind()
  GameObjects.FX_Platform_Scrape3:HideParticleEmitter()
  StopElevatorScrapingSound()
  dragonElevator:SetAnimRate(0.85)
end
function StartWallHit02()
  LD.BreakObject(GameObjects.elevator_scrape_02_break)
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_GIANT",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1.2},
    Priority = 1900
  })
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_LARGE",
    Duration = 2,
    TweenIn = {Time = 0.4},
    TweenOut = {Time = 0.5},
    Priority = 1910
  })
  LD.AddControllerRumble({Duration = 1, EffectName = "FFB_GIANT"})
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM",
    Duration = 3,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.25}
  })
  PlayElevatorScrapingSound(1)
end
function StopWallHit02(monitor)
  if monitor then
    monitor:Stop()
    monitor:Terminate()
    monitor = nil
  end
  LD.AddControllerRumble({Duration = 1.8, EffectName = "FFB_MEDIUM"})
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_TITAN",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1.2},
    Priority = 1920
  })
end
function FirstPushFunctionality()
  dragonElevator:FindSingleGOByName("TraverseLink1_2m"):ShowTraverseLink()
  dragonElevator:FindSingleGOByName("TraverseLink2_2m"):ShowTraverseLink()
  timers.StartLevelTimer(1, function()
    GameObjects.Peak380_Banter.LuaObjectScript.SecondElevator_Pylon01_Banter()
  end)
  timers.StartLevelTimer(6, function()
    GameObjects.Peak380_Banter.LuaObjectScript.SecondElevator_Pylon02_Banter()
  end)
end
function SecondPushFunctionality()
  GameObjects.Peak380_Banter.LuaObjectScript.ElevatorUnstableSeq()
  dragonElevator:FindSingleGOByName("TraverseLink1_2m"):HideTraverseLink()
  dragonElevator:FindSingleGOByName("TraverseLink2_2m"):HideTraverseLink()
  timers.StartLevelTimer(1, function()
    GameObjects.Peak380_Banter.LuaObjectScript.UpUpAndAway_Banter()
  end)
  CreateWallCollisionMonitor()
end
function StartIdle_00()
  dragonElevator:StartAnim("Peak380_ElevatorLvl0")
  dragonElevator:PlayAnimCycle()
end
function StartIdle_01()
  StopElevatorRunningSounds()
  dragonElevator:ClearAllAnimCallbacks()
  dragonElevator:StartAnim("Peak380_ElevatorLvl1")
  dragonElevator:PlayAnimCycle()
  GameObjects.CollisionToggle:HideCollision()
end
function StartStuck_01()
  dragonElevator:ClearAllAnimCallbacks()
  dragonElevator:StartAnim("Peak380_ElevatorStuck1Idle")
  dragonElevator:PlayAnimCycle()
  Encounter01_Stop()
  StopElevatorRunningSounds()
  Encounter02_Start()
  GameObjects.peak300_loop_braziers_00:JumpAnimationToPercent(0)
  GameObjects.peak300_loop_braziers_00:PlayAnimationToEnd()
end
function StartRide_02()
  dragonElevator:ClearAllAnimCallbacks()
  dragonElevator:OnAnimDone(thisObj, "StartStuck_02")
  dragonElevator:SetAnimRate(0.8)
  PlayElevatorRunningSounds()
  PlayElevatorScrapingSound(2, true)
  timers.StartLevelTimer(4, function()
    _G.Unstuck00Banter()
  end)
  CreateFightAndScrape03Monitor()
  GameObjects.peak300_loop_braziers_00:JumpAnimationToPercent(0)
  GameObjects.peak300_loop_braziers_00:PlayAnimationCycle()
  timers.StartLevelTimer(12, function()
    GameObjects.DeathPlane04a:Show()
  end)
  timers.StartLevelTimer(20, function()
    GameObjects.DeathPlane04b:Show()
  end)
end
function CreateFightAndScrape03Monitor()
  local fightAndScrape03Monitor = monitors.CreateAnimFrameMonitor(dragonElevator)
  local currentFrame = dragonElevator.AnimFrame
  fightAndScrape03Monitor:OnFrameForward(currentFrame + 58, Encounter03_Start)
  fightAndScrape03Monitor:OnFrameForward(880, Scrape03Start)
  LD.CallFunctionAfterDelay(function()
    fightAndScrape03Monitor:OnFrameForward(928, function()
      Scrape03Stop(fightAndScrape03Monitor)
    end)
  end, 0.5)
end
function Scrape03Start()
  LD.BreakObject(GameObjects.elevator_scrape_03_break)
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_GIANT",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1.2},
    Priority = 1900
  })
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_LARGE",
    Duration = 2,
    TweenIn = {Time = 0.4},
    TweenOut = {Time = 0.5},
    Priority = 1910
  })
  LD.AddControllerRumble({Duration = 1, EffectName = "FFB_GIANT"})
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM",
    Duration = 3,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.25}
  })
  PlayElevatorScrapingSound(2)
end
function Scrape03Stop(monitor)
  if monitor then
    monitor:Stop()
    monitor:Terminate()
    monitor = nil
  end
  LD.AddControllerRumble({Duration = 1.8, EffectName = "FFB_MEDIUM"})
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_TITAN",
    Duration = 1.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1.2},
    Priority = 1920
  })
end
function StartStuck_02()
  Encounter04_Start()
  dragonElevator:ClearAllAnimCallbacks()
  dragonElevator:StartAnim("Peak380_ElevatorStuck2Idle")
  dragonElevator:PlayAnimCycle()
  GameObjects.CombatScripts.LuaObjectScript.elevatorIsStuck = true
  StopElevatorRunningSounds()
  GameObjects.peak300_loop_braziers_00:JumpAnimationToPercent(0)
  GameObjects.peak300_loop_braziers_00:PlayAnimationToEnd()
end
function StartDragonTransition()
  dragonElevator:ClearAllAnimCallbacks()
  dragonElevator:OnAnimDone(thisObj, "EndElevatorRide_StartDragonBoss")
  dragonElevator:SetAnimRate(1.2)
  PlayElevatorRunningSounds()
  timers.StartLevelTimer(5, function()
    _G.Unstuck01Banter()
  end)
  GameObjects.peak300_loop_braziers_00:JumpAnimationToPercent(0)
  GameObjects.peak300_loop_braziers_00:PlayAnimationCycle()
end
function EndElevatorRide_StartDragonBoss(level, obj)
  dragonElevator:ClearAllAnimCallbacks()
  GameObjects.DragonBossScript.LuaObjectScript.StartDragonBossElevatorStages()
  PlayStuckSound()
  LD.CallFunctionAfterDelay(function()
    PlayStuckSound()
  end, 6.772)
  LD.CallFunctionAfterDelay(function()
    PlayStuckSound()
    StopElevatorRunningSounds()
  end, 16.413)
  _G.SCA_DragonTurret_Enable()
  GameObjects.ZoneKillAI:HideEntityVolume()
  GameObjects.CollisionDeathplane:Hide()
end
function Stuck00_BanterHintTimerStart()
  postStuck00HintTimer:Start()
end
function EnableStuckTnF00()
  GameObjects.BasicTNFObject_Stuck00.LuaObjectScript.Enable()
end
function EnableStuckTnF01()
  GameObjects.BasicTNFObject_Stuck01.LuaObjectScript.Enable()
end
function WatchCounterweightFall()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 1.2,
    LockRecenter = 0.46,
    YawRange = 360,
    PitchRange = -1,
    TriggerUp = -5,
    ReturnUp = -8.5,
    ReturnDown = -8.5,
    TriggerDown = -90
  })
end
function BigElevatorBreakScaffold()
  LD.BreakObject(GameObjects.ChimneyShaftPieceA3)
end
function Stuck00_BanterHintPlay()
  GameObjects.Peak380_Banter.LuaObjectScript.StuckOnShelf_Hint_Banter()
  print("STUCK 00 BANTER LINE PLAY")
end
function Stuck00_BanterHintTimerStop()
  postStuck00HintTimer:Stop()
end
function Stuck01_BanterHintTimerStart()
  postStuck01HintTimer:Start()
  print("STUCK 01 BANTER LINE PLAY")
end
function Stuck01_BanterHintPlay()
  GameObjects.Peak380_Banter.LuaObjectScript.WeGoHome_Hint_Banter()
end
function Stuck01_BanterHintTimerStop()
  postStuck01HintTimer:Stop()
end
local soundElevatorEmitter
local soundScrapeEmitters = {}
function SoundInit()
  soundElevatorEmitter = thisObj:FindSingleSoundEmitterByName("SNDBigElevator")
  soundScrapeEmitters[1] = GameObjects.FX_Platform_Scrape3:FindSingleSoundEmitterByName("SNDBigElevatorScrape")
  soundScrapeEmitters[2] = GameObjects.FX_Platform_Scrape1:FindSingleSoundEmitterByName("SNDBigElevatorScrape2")
end
function PlayElevatorRunningSounds()
  LD.PlaySound(soundElevatorEmitter, "SND_MECH_Wooden_Elevator_PeaksPass_LP")
  LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, "OnBigElevatorRunning", "Fires when elevator starts running")
end
function PlayElevatorScrapingSound(emit, onFrame)
  if onFrame then
    LD.PlaySoundOnFrame(soundScrapeEmitters[emit], dragonElevator, "SND_MECH_Wooden_Elevator_PeaksPass_Scrape_LP", dragonElevator.AnimLengthFrames - 30)
  else
    LD.PlaySound(soundScrapeEmitters[emit], "SND_MECH_Wooden_Elevator_PeaksPass_Scrape_LP")
  end
end
function StopElevatorScrapingSound()
  for i = 1, #soundScrapeEmitters do
    if soundScrapeEmitters[i]:IsPlaying("SND_MECH_Wooden_Elevator_PeaksPass_Scrape_LP") then
      LD.StopSound(soundScrapeEmitters[i], "SND_MECH_Wooden_Elevator_PeaksPass_Scrape_LP")
    end
  end
end
function StopElevatorRunningSounds()
  LD.StopSound(soundElevatorEmitter, "SND_MECH_Wooden_Elevator_PeaksPass_LP")
  StopElevatorScrapingSound()
  LD.ExtractAndExecuteCallbacksForEvent(thisLevel, thisObj, "OnBigElevatorStopped", "Fires when elevator stops running")
end
function PlayStuckSound()
  LD.PlaySound(soundElevatorEmitter, "SND_MECH_Wooden_Elevator_PeaksPass_Atreus_Stumble")
end
function PlayUnstuckSound()
  LD.PlaySound(soundElevatorEmitter, "SND_MECH_Wooden_Elevator_PeaksPass_Atreus_Stumble")
end
function Encounter01_Start(monitor)
  if monitor then
    monitor:Stop()
    monitor = nil
  end
  GameObjects.CombatScripts.LuaObjectScript.Encounter01_Fight()
  print("START ENCOUNTER 01")
end
function Encounter01_Stop()
  GameObjects.CombatScripts.LuaObjectScript.Encounter01_Fight()
  print("STOP ENCOUNTER 01")
end
function Encounter02_Start()
  GameObjects.CombatScripts.LuaObjectScript.Encounter02_Fight()
  print("START ENCOUNTER 02")
end
function Encounter03_Start()
  GameObjects.CombatScripts.LuaObjectScript.Encounter03_Fight()
  print("START ENCOUNTER 03")
end
function Encounter04_Start()
  GameObjects.CombatScripts.LuaObjectScript.Encounter04_Fight()
  print("START ENCOUNTER 04")
end
function FindAndKillEnemies()
  local nearbyEnemies = game.Player.FindPlayer():FindEnemies(30)
  for _, enemy in pairs(nearbyEnemies) do
    enemy:Destroy()
  end
end
function DebugZoneEnter()
end
function DebugZoneExit()
end
