local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
EC = require("design.Encounter")
local thisLevel, player, BigElevator_Encounter00, BigElevator_Encounter01, BigElevator_Encounter02, BigElevator_Encounter03, BigElevator_Encounter04
elevatorIsStuck = false
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  function OnUpdate(level)
    if BigElevator_Encounter04:IsRunning() and player:IsPlayingMove("MOV_CSRageGrabJotunnEnter") then
      BigElevator_Encounter04:StartWave(2)
    end
  end
  BigElevator_Encounter01 = EC.NewEncounter(thisLevel, "Encounter 01", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_PEAK_elevator_fight_11_in",
    StopMusic = "SND_MX_PEAK_elevator_fight_11_out"
  })
  BigElevator_Encounter01:AddWave({
    disableSpawnerPostSpawn = true,
    {
      spawners = "Draugr00_01_Scrape1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_01_Scrape2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.4,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_01_Scrape3",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8,
      pointMarkerID = "666"
    }
  })
  BigElevator_Encounter01:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
    Encounter01_DeathPlane()
  end)
  print("START ENCOUNTER 2")
  BigElevator_Encounter02 = EC.NewEncounter(thisLevel, "Encounter 02", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_PEAK_elevator_fight_11_5_in",
    StopMusic = "SND_MX_PEAK_elevator_fight_11_5_out"
  })
  BigElevator_Encounter02:AddWave({
    {
      spawners = "Draugr00_02_Stuck1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_02_Stuck2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_02_Stuck3",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_02_Ranged1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_02_Ranged2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 25,
      pointMarkerID = "666"
    }
  })
  BigElevator_Encounter02:AddWave({
    {
      spawners = "Draugr00_02_Stuck4",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_02_Stuck3",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_02_Stuck2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7,
      pointMarkerID = "666"
    }
  })
  BigElevator_Encounter02:OnStart(function()
    Encounter03_DeathPlane()
  end)
  BigElevator_Encounter02:OnEnemyDeath(function()
    BigElevator_Encounter02:StartWave(2)
  end, {count = 3})
  BigElevator_Encounter02:OnComplete(SecondEncounterComplete)
  print("START ENCOUNTER 3")
  BigElevator_Encounter03 = EC.NewEncounter(thisLevel, "Encounter 03", {CheckpointOnComplete = false})
  BigElevator_Encounter03:AddWave({
    {
      spawners = "Draugr00_02_Stuck5",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 12,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_02_Stuck6",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 11,
      pointMarkerID = "666"
    }
  })
  BigElevator_Encounter03:OnCombatStart(function()
    game.Audio.StartMusic("SND_MX_PEAK_elevator_fight_12a_in")
  end)
  BigElevator_Encounter04 = EC.NewEncounter(thisLevel, "Encounter 04", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_PEAK_elevator_fight_12b_in",
    StopMusic = "SND_MX_PEAK_elevator_fight_12b_out"
  })
  BigElevator_Encounter04:AddWave({
    {
      spawners = "Jotun10_04_Stuck",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_04_Stuck1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_04_Stuck2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 18,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_04_Ranged2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_04_Stuck1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 9,
      pointMarkerID = "666"
    }
  })
  BigElevator_Encounter04:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr00_04_Stuck1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_04_Stuck2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_04_Stuck1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10,
      pointMarkerID = "666"
    },
    {
      spawners = "Draugr00_04_Stuck2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 14.2,
      pointMarkerID = "666"
    }
  })
  BigElevator_Encounter04:OnStart(function()
    Encounter05_DeathPlane()
  end)
  BigElevator_Encounter04:OnComplete(FourthEncounterComplete)
end
function OnStart(level, obj)
  if BigElevator_Encounter02:WasRunning() then
    BigElevator_Encounter02:Start()
  end
  if BigElevator_Encounter04:WasRunning() then
    BigElevator_Encounter04:Start()
  end
end
function OnUpdate(level, obj)
end
function Encounter01_DeathPlane()
  GameObjects.DeathPlane01:Show()
  timer.StartLevelTimer(25, function()
    GameObjects.DeathPlane02:Show()
  end)
end
function Encounter03_DeathPlane()
  GameObjects.DeathPlane03:Show()
end
function Encounter05_DeathPlane()
  GameObjects.DeathPlane05:Show()
end
function KillEnemiesInsideZone(enemy)
  enemy:Destroy()
end
function Encounter01_Fight()
  print("START ENCOUNTER 01")
  BigElevator_Encounter01:Start()
end
function Encounter01_Stop()
  print("STOP ENCOUNTER 1")
  BigElevator_Encounter01:Stop()
end
function FirstEncounterComplete()
  timer.StartLevelTimer(2, function()
    _G.PostScrapeFightBanter()
  end)
end
function Encounter02_Fight()
  print("START ENCOUNTER 2")
  BigElevator_Encounter02:StartAndStoreCheckpoint()
end
function SecondEncounterComplete()
  timer.StartLevelTimer(1.8, function()
    _G.PostScrapeFightBanter()
  end)
  timer.StartLevelTimer(6.5, function()
    _G.PostStuck00FightBanter()
  end)
  GameObjects.DragonElevator.LuaObjectScript.EnableStuckTnF00()
  GameObjects.DragonElevator.LuaObjectScript.Stuck00_BanterHintTimerStart()
end
function Encounter03_Fight()
  print("START ENCOUNTER 3")
  BigElevator_Encounter03:Start()
end
function Encounter04_Fight()
  print("START ENCOUNTER 4")
  BigElevator_Encounter04:StartAndStoreCheckpoint()
end
function FourthEncounterComplete()
  game.Compass.SetDesignerForcedHide(false)
  _G.PostStuck01FightBanter()
  _G.SCA_PostFight02_Enable()
  GameObjects.DragonElevator.LuaObjectScript.EnableStuckTnF01()
  GameObjects.DragonElevator.LuaObjectScript.Stuck01_BanterHintTimerStart()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Body")
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ogre_Basher")
  print("FOURTH ENCOUNTER COMPLETE")
end
