local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, son
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  banterPlayed = savedInfo.banterPlayed
end
function ElevatorUnstableSeq()
  if not banterPlayed.elevatorUnstable then
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Elevator Unstable")
    cineSeq:WaitForFunctionTrue(function()
      return GameObjects.DragonElevator.Child.AnimFrame >= 575
    end)
    cineSeq:Do(function()
      son:TriggerMoveEvent("LE_StartElevatorUnstable")
      game.Audio.PlayBanter("360_ElevatorUnstable")
    end)
    cineSeq:WaitForFunctionTrue(function()
      return not son:IsPlayingMove("MOV_ElevatorUnstableFirstHalf") and not son:IsPlayingMove("MOV_ElevatorUnstableSecondHalf")
    end)
    cineSeq:Do(function()
      banterPlayed.elevatorUnstable = true
    end)
    cineSeq:StartSequence()
  end
end
function SecondElevator_Idle01_Banter()
  if not banterPlayed.secondElevator_Idle01 then
    game.Audio.PlayBanter("350_SecondElevator_Idle01")
    banterPlayed.secondElevator_Idle01 = true
  end
end
function SecondElevator_Idle02_Banter()
  if not banterPlayed.secondElevator_Idle02 then
    game.Audio.PlayBanter("350_SecondElevator_Idle02")
    banterPlayed.secondElevator_Idle02 = true
  end
end
function SecondElevator_Pylon01_Banter()
  if not banterPlayed.secondElevator_Pylon01 then
    game.Audio.PlayBanter("350_SecondElevator_Pylon01")
    banterPlayed.secondElevator_Pylon01 = true
  end
end
function SecondElevator_Pylon02_Banter()
  if not banterPlayed.secondElevator_Pylon02 then
    game.Audio.PlayBanter("350_SecondElevator_Pylon02")
    banterPlayed.secondElevator_Pylon02 = true
  end
end
function UpUpAndAway_Banter()
  if not banterPlayed.UpUpAndAway then
    game.Audio.PlayBanter("355_UpUpAndAway")
    banterPlayed.UpUpAndAway = true
  end
end
function HavingFunYet_Banter()
  if not banterPlayed.HavingFunYet then
    game.Audio.PlayBanter("365_HavingFunYet")
    banterPlayed.HavingFunYet = true
  end
end
function StuckOnShelf_Intro_Banter()
  if not banterPlayed.StuckOnShelf_Intro then
    game.Audio.PlayBanter("370_StuckOnShelf_Intro")
    banterPlayed.StuckOnShelf_Intro = true
  end
end
function StuckOnShelf_Hint_Banter()
  if not banterPlayed.StuckOnShelf_Hint then
    game.Audio.PlayBanter("370_StuckOnShelf_Hint")
    banterPlayed.StuckOnShelf_Hint = true
  end
end
function StuckOnShelf_Victory_Banter()
  if not banterPlayed.StuckOnShelf_Victory then
    game.Audio.PlayBanter("370_StuckOnShelf_Victory")
    banterPlayed.StuckOnShelf_Victory = true
  end
end
function WeGoHome_Intro_Banter()
  if not banterPlayed.WeGoHome_Intro then
    game.Audio.PlayBanter("375_WeGoHome_Intro")
    banterPlayed.WeGoHome_Intro = true
  end
end
function WeGoHome_Hint_Banter()
  if not banterPlayed.WeGoHome_Hint then
    game.Audio.PlayBanter("375_WeGoHome_Hint")
    banterPlayed.WeGoHome_Hint = true
  end
end
function WeGoHome_Success_Banter()
  if not banterPlayed.WeGoHome_Success then
    game.Audio.PlayBanter("375_WeGoHome_Success")
    banterPlayed.WeGoHome_Success = true
  end
end
function HelloDragon_Intro_Banter()
  game.Audio.PlayBanter("380_HelloDragon_Intro")
end
function HelloDragon_Claw_Banter()
  if not banterPlayed.HelloDragon_Claw then
    game.Audio.PlayBanter("380_HelloDragon_Claw")
    banterPlayed.HelloDragon_Claw = true
  end
end
function HelloDragon_Bite1_Banter()
  if not banterPlayed.HelloDragon_Bite1 then
    game.Audio.PlayBanter("380_HelloDragon_Bite1")
    banterPlayed.HelloDragon_Bite1 = true
  end
end
function HelloDragon_Bite2_Banter()
  game.Audio.PlayBanter("380_HelloDragon_Bite2")
end
function HelloDragon_End01_Banter()
  if not banterPlayed.HelloDragon_End01 then
    game.Audio.PlayBanter("380_HelloDragon_End01")
    banterPlayed.HelloDragon_End01 = true
  end
end
function HelloDragon_End02_Banter()
  if not banterPlayed.HelloDragon_End02 then
    game.Audio.PlayBanter("380_HelloDragon_End02")
    banterPlayed.HelloDragon_End02 = true
  end
end
function HelloDragon_End03_Banter()
  if not banterPlayed.HelloDragon_End03 then
    game.Audio.PlayBanter("380_HelloDragon_End03")
    banterPlayed.HelloDragon_End03 = true
  end
end
