LD = require("design.LevelDesignLibrary")
monitors = require("level.MonitorLibrary")
timers = require("level.timer")
uiCalls = require("ui.uicalls")
checkpoint = require("level.checkpoint")
thisObj = nil
player = nil
son = nil
thisLevel = nil
local elevator
ElevatorCollision = nil
local TriangleButtonMonitor, L1buttonMonitor
local isBraziersPlaying = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  SoundInit()
  TriangleButtonMonitor = monitors.CreateTriangleButtonMonitor()
  TriangleButtonMonitor:OnButtonUp(CancelMsg)
end
function OnStart(level)
  SoundOnStart()
  if GameObjects.DragonBossScript.LuaObjectScript.isBossStateGrabMelee() == true then
    GameObjects.DragonElevator:FindSingleGOByName("peak300_platform_bite_01"):Show()
  else
    GameObjects.DragonElevator:FindSingleGOByName("peak300_platform_bite_01"):Hide()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function LuaHook_ForwardBossState(ai, data)
  GameObjects.DragonBossScript.LuaObjectScript.ForwardBossState()
end
function LuaHook_PushOffElevatorStart(ai, data)
  GameObjects.DragonBossScript.LuaObjectScript.LuaHook_PushOffElevatorStart()
end
function LuaHook_ElevatorStoppedMelee(ai, data)
  print("Platform stopped!")
end
function LuaHook_ElevatorStoppedElectricBreath(ai, data)
  print("Platform stopped!")
  game.World.StoreCheckpoint()
end
function LuaHook_SmashFaceWin(ai, data)
  print("Win TnF")
  GameObjects.DragonBossScript.LuaObjectScript.BossEncounter_SetActiveState("SmashFace")
end
function Peak380_HideCollisionWall()
  GameObjects.CollisionWall_Disable:HideCollision()
end
function LuaHook_DamageHealthBar()
  GameObjects.DragonBossScript.LuaObjectScript.LuaHook_DamageHealthBar()
end
function Zone_ElevatorHintTimerStart_Enable()
  GameObjects.Zone_ElevatorHintTimerStart:ShowEntityVolume()
  print("ENABLE DRAGON ELEVATOR HINT01 ZONE")
end
function StartBraziersAnimLoop()
  if isBraziersPlaying then
    return
  else
    GameObjects.peak300_loop_braziers_00:PlayAnimationCycle()
    isBraziersPlaying = true
  end
end
function DragonElevatorDestroyed()
  timers.StartLevelTimer(10, function()
    game.World.StoreCheckpoint()
  end)
end
function DragonTunnelBreak()
  local peak500 = game.FindLevel("peak500_ChimneyTop")
  peak500:CallScript("DragonTunnelBreak")
end
function DragonElevatorBreakPillar_ClawHit()
  LD.BreakObject(GameObjects.DragonElevator:FindSingleGOByName("Peak300_PillarBreak_ClawHit"))
end
function LuaHook_DragonElevatorPlatformBite()
  LD.BreakObject(GameObjects.DragonElevator:FindSingleGOByName("peak300_platform_bite_01"))
end
function LuaHook_Trigger_DragonIntro()
  LD.BreakObject(GameObjects.DragonElevator:FindSingleGOByName("peak300_platform_grab_group"))
  GameObjects.DragonElevator:FindSingleGOByName("peak300_platform_grab_group"):Show()
end
function LuaHook_SwapPlatformVis_DragonIntro()
  GameObjects.DragonElevator:FindSingleGOByName("peak300_platform_grab_group"):Hide()
  GameObjects.DragonElevator:FindSingleGOByName("peak300_platform_bite_01"):Show()
end
function DragonElevatorBreakPillar_TailHit()
  LD.BreakObject(GameObjects.DragonElevator:FindSingleGOByName("peak300_PillarBreak_TailHit"))
end
function LuaHook_HideDragonElevator00()
  local l_obj = thisLevel:GetGameObject("dragonelevator00")
  l_obj:Hide()
  l_obj:JumpAnimationToFrame(1)
  l_obj:PauseAnimation()
end
function StartDragonBossElevatorStages()
  GameObjects.DragonElevator:ShowCollision()
  GameObjects.DragonBossScript.LuaObjectScript.ForwardBossState()
end
function SCA_ElevatorIdleBehavior_03_Enable()
  GameObjects.SCA_ElevatorIdleBehavior_03.LuaObjectScript.Enable()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
  GameObjects.SCA_ElevatorStart_01.LuaObjectScript.Disable()
end
function SCA_ElevatorIdleBehavior_03_Disable()
  GameObjects.SCA_ElevatorIdleBehavior_03.LuaObjectScript.Interrupt()
  GameObjects.SCA_ElevatorIdleBehavior_03.LuaObjectScript.Disable()
end
function ElevatorSecretPlatform_Enter()
  GameObjects.SCA_ElevatorIdleBehavior_03.LuaObjectScript.Disable()
  GameObjects.SCA_Level2Secret_02.LuaObjectScript.Enable()
end
function ElevatorSecretPlatform_Exit()
  GameObjects.SCA_ElevatorIdleBehavior_03.LuaObjectScript.Enable()
  GameObjects.SCA_Level2Secret_02.LuaObjectScript.Disable()
end
function SCA_PostFight02_Enable()
  GameObjects.SCA_ElevatorIdleBehavior_03.LuaObjectScript.Interrupt()
  GameObjects.SCA_ElevatorIdleBehavior_03.LuaObjectScript.Disable()
  GameObjects.SCA_PostFight2_05.LuaObjectScript.Enable()
end
function SCA_DragonTurret_Enable()
  GameObjects.SCA_PostFight2_05.LuaObjectScript.Interrupt()
  GameObjects.SCA_PostFight2_05.LuaObjectScript.Disable()
  GameObjects.SCA_DragonTurret.LuaObjectScript.Enable()
end
function SCA_DragonTurret_Disable()
  GameObjects.SCA_DragonTurret.LuaObjectScript.Interrupt()
  GameObjects.SCA_DragonTurret.LuaObjectScript.Disable()
end
function PostScrapeFightBanter()
  GameObjects.Peak380_Banter.LuaObjectScript.HavingFunYet_Banter()
end
function PostStuck00FightBanter()
  GameObjects.Peak380_Banter.LuaObjectScript.StuckOnShelf_Intro_Banter()
end
function Unstuck00Banter()
  GameObjects.Peak380_Banter.LuaObjectScript.StuckOnShelf_Victory_Banter()
end
function PostStuck01FightBanter()
  GameObjects.Peak380_Banter.LuaObjectScript.WeGoHome_Intro_Banter()
end
function Unstuck01Banter()
  GameObjects.Peak380_Banter.LuaObjectScript.WeGoHome_Success_Banter()
end
function CancelMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function Peak380_DragonFightStart()
  timers.StartLevelTimer(1, function()
    GameObjects.DragonBossScript.LuaObjectScript.BossEncounter_SetActiveState("GrabMelee")
  end)
  timers.StartLevelTimer(3, function()
  end)
end
function Peak380_DragonFightStage1Over()
  DragonTunnelBreak()
end
local soundGearEmitters = {}
local soundGearSoundEvents = {
  "SND_MECH_Wooden_Elevator_PeaksPass_Gear_LP_A",
  "SND_MECH_Wooden_Elevator_PeaksPass_Gear_LP_B",
  "SND_MECH_Wooden_Elevator_PeaksPass_Gear_LP_C",
  "SND_MECH_Wooden_Elevator_PeaksPass_Gear_LP_D",
  "SND_MECH_Wooden_Elevator_PeaksPass_Gear_LP_E",
  "SND_MECH_Wooden_Elevator_PeaksPass_Gear_LP_F"
}
function OnBigElevatorRunning()
  print(thisLevel, "knows that the elevator is running")
  PlayGearsRunningSounds()
end
function OnBigElevatorStopped()
  print(thisLevel, "knows that the elevator is stopped")
  StopGearsRunningSounds()
end
function SoundInit()
  InitializeGearEmitters()
end
function PlayGearsRunningSounds()
  for i = 1, #soundGearEmitters do
    LD.PlaySound(soundGearEmitters[i][1], soundGearEmitters[i][2])
  end
end
function StopGearsRunningSounds()
  for i = 1, #soundGearEmitters do
    LD.StopSound(soundGearEmitters[i][1], soundGearEmitters[i][2])
  end
end
function InitializeGearEmitters()
  local soundEmitters = GameObjects.SNDElevatorGearGroup.SoundEmitters
  for i = 1, #soundEmitters do
    table.insert(soundGearEmitters, {
      soundEmitters[i],
      GetRandomSoundEvent()
    })
    print(tostring(soundGearEmitters[i][1]), soundGearEmitters[i][2])
  end
end
function GetRandomSoundEvent()
  return soundGearSoundEvents[math.random(#soundGearSoundEvents)]
end
function LuaHook_Stg1_ElectricBreath()
  player:CallScript("PlaySoundOnKratos", "SND_CHR_EarthDragon_CS_Elev_Pushoff_Long")
end
function LuaHook_FreeStuckElevator()
  GameObjects.DragonElevator.LuaObjectScript.PlayUnstuckSound()
end
local counterweightEmitter01, counterweightEmitter02
local elevatorWeightsSoundOverrides = {
  SoundEmitter = nil,
  OnStuckAtEnd = "",
  OnStuckAtEndFrame = -1,
  OnStuckAtStart = "SND_MECH_Stone_Lift_Boulder_Pull_Back"
}
local counterWeightMovementSoundLoop = "SND_MECH_Stone_Lift_Move_380_LP"
local counterWeightPushOffSound = "SND_MECH_Stone_Lift_Fail_380"
local counterWeight01CrankScript, counterWeight02CrankScript, counterWeight01AnimMonitor, counterWeight02AnimMonitor
function SoundOnStart()
  if GameObjects.Counterweight01:IsModelShown() then
    counterweightEmitter01 = GameObjects.Counterweight01.Child.SoundEmitters[1]
    elevatorWeightsSoundOverrides.SoundEmitter = counterweightEmitter01
    GameObjects.Counterweight01.LuaObjectScript.DrivenObjectSoundSetup(elevatorWeightsSoundOverrides)
    counterWeight01CrankScript = GameObjects.Counterweight01.Child.LuaObjectScript
    if counterWeight01AnimMonitor == nil then
      counterWeight01AnimMonitor = monitors.CreateAnimFrameMonitor(GameObjects.weight01Group)
      counterWeight01AnimMonitor:OnFrameBackward(0, AttemptStopSoundCounterweightLoop_01)
      counterWeight01AnimMonitor:OnFrameForward(50, AttemptStopSoundCounterweightLoop_01)
    end
  end
  if GameObjects.Counterweight02:IsModelShown() then
    counterweightEmitter02 = GameObjects.Counterweight02.Child.SoundEmitters[1]
    elevatorWeightsSoundOverrides.SoundEmitter = counterweightEmitter02
    GameObjects.Counterweight02.LuaObjectScript.DrivenObjectSoundSetup(elevatorWeightsSoundOverrides)
    counterWeight02CrankScript = GameObjects.Counterweight02.Child.LuaObjectScript
    if counterWeight02AnimMonitor == nil then
      counterWeight02AnimMonitor = monitors.CreateAnimFrameMonitor(GameObjects.weight02Group)
      counterWeight02AnimMonitor:OnFrameBackward(0, AttemptStopSoundCounterweightLoop_02)
      counterWeight02AnimMonitor:OnFrameForward(50, AttemptStopSoundCounterweightLoop_02)
    end
  end
end
function StartSoundCounterweightLoop_01()
  LD.PlaySound(counterweightEmitter01, counterWeightMovementSoundLoop)
end
function StopSoundCounterweightLoop_01()
  LD.StopSound(counterweightEmitter01, counterWeightMovementSoundLoop)
end
function AttemptStopSoundCounterweightLoop_01()
  if not counterWeight01CrankScript.PlayerIsAttached() then
    StopSoundCounterweightLoop_01()
  end
end
function PlaySoundOnEndCounterweight_01()
  LD.PlaySoundRingOut(counterweightEmitter01, counterWeightPushOffSound)
  StopSoundCounterweightLoop_01()
  if counterWeight01AnimMonitor ~= nil then
    counterWeight01AnimMonitor:Stop()
    counterWeight01AnimMonitor:Terminate()
    counterWeight01AnimMonitor = nil
  end
end
function StartSoundCounterweightLoop_02()
  LD.PlaySound(counterweightEmitter02, counterWeightMovementSoundLoop)
end
function StopSoundCounterweightLoop_02()
  LD.StopSound(counterweightEmitter02, counterWeightMovementSoundLoop)
end
function AttemptStopSoundCounterweightLoop_02()
  if not counterWeight02CrankScript.PlayerIsAttached() then
    StopSoundCounterweightLoop_02()
  end
end
function PlaySoundOnEndCounterweight_02()
  LD.PlaySoundRingOut(counterweightEmitter02, counterWeightPushOffSound)
  StopSoundCounterweightLoop_02()
  if counterWeight02AnimMonitor ~= nil then
    counterWeight02AnimMonitor:Stop()
    counterWeight02AnimMonitor:Terminate()
    counterWeight02AnimMonitor = nil
  end
end
