local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
EC = require("design.Encounter")
thisObj = nil
thisLevel = nil
player = nil
son = nil
local Area_1_Encounter_1, Area_1_Encounter_2, Area_2_Encounter_0, Area_2_Encounter_1, Area_2_Encounter_2, Elite_HealthMonitor, Elite_ZoneMonitor, VibrateElevatorEncounter, VibrateGearEncounter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  DarkOne_MainFight()
  DarkOne_Turret_Fight()
  Jotunn_Breakout_Fight()
  Jotunn_Ride_Fight()
end
function StartVibrateElevatorEncounter()
  VibrateElevatorEncounter:StartAndStoreCheckpoint()
end
function StartVibrateGearEncounter()
  VibrateGearEncounter:StartAndStoreCheckpoint()
end
function CompassOn()
  game.Compass.SetDesignerForcedHide(false)
end
function OnStart(level)
  if Area_2_Encounter_1:WasRunning() then
    Area_2_Encounter_1:Start()
  end
end
function OnUpdate(level, obj)
  if Area_2_Encounter_1:IsRunning() and player:IsPlayingMove("MOV_CSRageGrabJotunnEnter") then
    Area_2_Encounter_2:Start()
  end
end
function Jotunn_Breakout_Fight()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Jotunn Breakout Peak500", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone500"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Jotunn_L7_Break",
      spawnWad = "Peak720_AI_SummitAscent_02",
      spawnLocators = "A1_Loc_U_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_3_FIREBOMB",
      spawnWad = "Peak720_AI_SummitAscent_02",
      spawnLocators = "A1_Loc_U_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Flyer_3_FIREBOMB",
      spawnWad = "Peak720_AI_SummitAscent_02",
      spawnLocators = "A1_Loc_U_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.6
    }
  })
  Area_2_Encounter_1:OnStart(function()
    GameObjects.KillBoxFight:ShowCollision()
    LD.CallFunctionAfterDelay(function()
      GameObjects.ReactionStim_PreJotunBreakout.LuaObjectScript.Trigger()
    end, 0.2)
    LD.CallFunctionAfterDelay(function()
      GameObjects.ReactionStim_JotunBreakout.LuaObjectScript.Trigger()
    end, 1.7)
  end)
  Area_2_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Fire")
  end)
end
function Jotunn_Ride_Fight()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Jotunn Ride Draugr Peak500", {
    LeashZone = "LeashZone500"
  })
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Draugr_5_JOTUNN_1",
      spawnLocators = "A1_Loc_U_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_5_JOTUNN_1",
      spawnLocators = "A1_Loc_U_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Draugr_5_JOTUNN_2",
      spawnLocators = "A1_Loc_U_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.6
    }
  })
end
function StartJotunnEncounter()
  timers.StartLevelTimer(9.5, function()
    Area_2_Encounter_1:Start()
  end)
end
function GetJotunnEncounterComplete()
  return Area_2_Encounter_1:IsComplete()
end
function DarkOne_Turret_Fight()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Draugr Turret Main Fight Peak500", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone501"
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Draugr_3_PROJ_01",
      spawnLocators = "A1_Loc_L_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_2:SetStartZone(thisLevel:GetGameObject("Zone_DarkTurret"), {
    cineRequirement = {459, 465}
  })
end
function DarkOne_MainFight()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 DarkOne Main Fight Peak500", {CheckpointOnComplete = true})
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_4_ENCH_STATUE",
      spawnLocators = "A1_Loc_M_2",
      useSpawnLocatorsOnly = true,
      markerID = "KillTarget",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_3_ENCH_PATROL",
      spawnLocators = "A1_Loc_M_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    },
    {
      spawners = "Draugr_3_CHEST_PATROL",
      spawnLocators = "A1_Loc_M_9",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Flyer_5_POSS_UN",
      spawnLocators = "A1_Loc_M_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Flyer_5_POSS_AL",
      spawnLocators = "A1_Loc_M_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Draugr_3_CHEST_DROP",
      spawnLocators = "A1_Loc_U_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_3_CHEST_DROP",
      spawnLocators = "A1_Loc_U_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("Zone_DarkMainFight"), {
    cineRequirement = {459, 465}
  })
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(2)
  end, {count = 1})
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(3)
  end, {count = 2})
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:AlertEnemies()
  end, {count = 1})
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Possess")
  end)
  Area_1_Encounter_1:OnComplete(_G.Btr_DragonTunnel_LookAt_Enable)
  Area_1_Encounter_1:OnComplete(CompassOn)
  Elite_ZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("Zone_DarkMainFightAlert"))
  Elite_ZoneMonitor:OnEnter(function()
    local LM = require("level.loadmonitor")
    LM.CreateLoadMonitor():AddCallback({
      Wads = {
        "Peak580_ExpressElevator"
      },
      Functions = {
        function(wads)
          wads.Peak580_ExpressElevator:CallScript("SCA_ElevatorRide_Disable")
        end
      }
    })
    GameObjects.DraugrAlertReaction.LuaObjectScript.Trigger()
    timers.StartLevelTimer(2, function()
      game.AI.FindSon():TriggerMoveEvent("kLE_KillDraugr")
    end)
    timers.StartLevelTimer(1.5, function()
      game.Audio.PlayBanter("SonJerk_Attack")
    end)
    GameObjects.Zone_DarkMainFightAlert:HideEntityVolume()
  end)
  Elite_ZoneMonitor:SetTriggerCountLimit(1)
end
function DisableFirstElevatorFights()
  VibrateElevatorEncounter:SetComplete()
  VibrateGearEncounter:SetComplete()
end
