local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local thisLevel, player
local warpoffset = engine.Vector.New(2, 0, 2)
local liftMechanism, slidingDoor2Breakable
local expressMusic = false
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  thisLevel = level
  CompassGatewayToggle()
end
function OnFirstStart(level)
end
function OnStart(level)
  GameObjects.BOOKMARK_26_PeaksPass_015_ExpressElevator:HideEntityVolume()
  GameObjects.Btr_DragonTunnel_LookAt:HideEntityVolume()
  GameObjects.peak500_broken_door_static:Hide()
end
function OnUpdate(level)
  if player:IsInsideEntityZone("Zone_DebugSonWarp") then
    game.AI.FindSon():Warp(player:GetWorldPosition() + warpoffset, player:GetWorldForward())
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function ElevatorSpoolAnimate()
  GameObjects.Machine500_guts.Child:PlayAnimToEnd()
end
function ElevatorSpoolAnimateReverse()
  GameObjects.Machine500_guts.Child:PlayAnimToEnd(-1)
end
function Peak500_RuneReadBanter()
  if GameObjects.CombatScripts.LuaObjectScript.GetJotunnEncounterComplete() then
    game.Audio.PlayBanter("Peak500_RuneGraffiti_OgreDead")
  else
    game.Audio.PlayBanter("Peak500_RuneGraffiti")
  end
end
function CompassGatewayToggle()
  if game.Wallets.HasResource("HERO", "Blades") then
    game.Compass.SetGatewayMarkerIsOpen("PP_500_Helper2", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("PP_500_Helper2", false)
  end
end
function Peak500_Bookmark_Enable()
  GameObjects.BOOKMARK_26_PeaksPass_015_ExpressElevator:ShowEntityVolume()
end
function LuaHook_Trigger_PlatformRockFall()
  local l_breakableObj = thisLevel:GetGameObject("peak300_platform_rock_fall_group")
  if l_breakableObj ~= nil then
    l_breakableObj:Show()
    l_breakableObj:JumpAnimationToFrame(0)
    l_breakableObj:PlayAnimToEnd()
  end
end
function ElevatorSwitchActivateStuck()
end
function GearVibrateRockDestroyedResult()
  timers.StartLevelTimer(1.75, function()
    DisableDungeonDoor()
    StartVibrateGearEncounter2()
  end)
end
function ElevatorSwitchActivateFree()
end
function StartVibrateElevatorEncounter1()
  GameObjects.CombatScripts.LuaObjectScript.StartVibrateElevatorEncounter()
end
function StartVibrateGearEncounter2()
  GameObjects.CombatScripts.LuaObjectScript.StartVibrateGearEncounter()
end
function DisableDungeonDoor()
  timers.StartLevelTimer(4, function()
    GameObjects.dungeon_door_break:Hide()
    GameObjects.peak500_broken_door_static:Show()
  end)
end
function DragonTunnelBreak()
  LD.BreakObject(GameObjects.dragon_tunnel_break)
  local peak380 = game.FindLevel("Peak380_BigElevator")
  peak380:CallScript("Peak380_HideCollisionWall")
end
function Endgame_Checkpoint()
  game.World.StoreCheckpoint()
end
function SCA_DragonTunnel_Enable()
  GameObjects.SCA_DragonTunnelLook.LuaObjectScript.Disable()
end
function SCA_DragonTunnel_Disable()
  GameObjects.SCA_DragonTunnelLook.LuaObjectScript.Disable()
end
function Btr_DragonTunnel_LookAt_Enable()
  GameObjects.Btr_DragonTunnel_LookAt:ShowEntityVolume()
end
function SCA_RuneReadStandby_ObserveFwd_Disable()
  GameObjects.SCA_RuneReadStandby_ObserveFwd.LuaObjectScript.Disable()
end
function Spline_500MainPath_Enable()
  GameObjects.LeadTheWay_500MainPath.LuaObjectScript.Enable()
end
function Spline_500MainPath_Disable()
  GameObjects.LeadTheWay_500MainPath.LuaObjectScript.Disable()
end
function Peak500_ExpressElevatorActive()
  GameObjects.CombatScripts.LuaObjectScript.DisableFirstElevatorFights()
  timers.StartLevelTimer(1, function()
    DisableDungeonDoor()
  end)
end
function afterExpressElevatorMusic()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 460 <= cineNum and expressMusic == false then
    game.Audio.StartCheckpointedMusic("SND_MX_PEAK2_explore2_in")
    expressMusic = true
  end
end
