local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local DL = require("design.DesignerLibrary")
local monitors = require("level.MonitorLibrary")
local TUT = require("game.GlobalTutorials")
local uiCalls = require("ui.uicalls")
local CSL = require("camera.shakelibrary")
local player, thisLevel, bPlayCamera, camera
local pickupCrystalFirstTime = false
local ThrowCrystalHintTimer
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  bPlayCamera = false
  thisLevel = level
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.Peak300_Platform_end_static_P:Hide()
  GameObjects.Peak510_DragonTunnelLH_Zone_18:HideEntityVolume()
  GameObjects.Zone_PostCrashLand:HideEntityVolume()
end
function OnUpdate(level)
  if bPlayCamera == true and camera ~= nil then
    game.Camera.SubmitCamera(camera)
  end
end
function LoadCheck_Peak500()
  game.UI.LoadCheck("Peak500_ChimneyTop")
end
function LoadCheck_Peak520()
  game.UI.LoadCheck("Peak520_PostDragonTunnel")
end
function VibrateInfoTutorial1()
  game.Audio.PlayBanter("385_TeachCrystalZap_RootApproach", function()
    timers.StartLevelTimer(0.5, function()
      TUT.VibrateInfo_Tutorial()
    end)
  end)
end
function VibrateTutorial1Complete()
  CSL.PlayDefaultShake("ShakeRumbleLarge")
  GameObjects.DragonEnergyVibrate1:Hide()
  GameObjects.Zone_DragonEnergyVibrate1:Hide()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  if ThrowCrystalHintTimer then
    ThrowCrystalHintTimer:Stop()
  end
  timers.StartLevelTimer(3.25, function()
    game.Audio.PlayBanter("385_TeachCrystalZap_End")
  end)
end
function LuaHook_Trigger_PlatformEndBreak()
  local l_breakableObj1 = thisLevel:GetGameObject("Peak300_Platform_end_static_P")
  local l_breakableObj2 = thisLevel:GetGameObject("Peak300_Platform_end_break_group")
  if l_breakableObj1 ~= nil then
    l_breakableObj1:Hide()
  end
  if l_breakableObj2 ~= nil then
    l_breakableObj2:Show()
    l_breakableObj2:JumpAnimationToFrame(0)
    l_breakableObj2:PlayAnimToEnd()
  end
end
function LuaHook_SwapToStaticElevator()
  local l_breakableObj1 = thisLevel:GetGameObject("Peak300_Platform_end_static_P")
  local l_breakableObj2 = thisLevel:GetGameObject("Peak300_Platform_end_break_group")
  if l_breakableObj1 ~= nil then
    l_breakableObj1:Show()
  end
  if l_breakableObj2 ~= nil then
    l_breakableObj2:Hide()
    l_breakableObj2:JumpAnimationToFrame(1)
    l_breakableObj2:PauseAnimation()
  end
  PostElevatorCrashLand()
end
function LuaHook_EnableHUD(ai, data)
  uiCalls.UI_Event_Force_Combat_HUD_On()
  game.Compass.SetDesignerForcedHide(false)
end
function SCA_PostElevatorDestroyed_Disable()
  GameObjects.SCA_PostElevatorDestroyed.LuaObjectScript.Disable()
end
function PostElevatorCrashLand()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
  timers.StartLevelTimer(0.5, function()
    GameObjects.Peak510_DragonTunnelLH_Zone_18:ShowEntityVolume()
    GameObjects.Zone_PostCrashLand:ShowEntityVolume()
  end)
end
function EnableStaticBrokenElevator()
end
function VibrateHintDestroy()
  GameObjects.DragonEnergyHint:Hide()
end
function VibrateRockCollapse()
  PlayRockCollapseAnim()
  timers.StartLevelTimer(0.8, StartRockCamera)
  timers.StartLevelTimer(1.8, function()
    player:SetMaxSpeedOverride(1.5)
  end)
  timers.StartLevelTimer(1.2, function()
    CSL.PlayDefaultShake("ShakeRumbleSmall")
  end)
  timers.StartLevelTimer(3.1, function()
    CSL.PlayDefaultShake("ShakeRumbleMedium")
  end)
  timers.StartLevelTimer(4, function()
    CSL.PlayDefaultShake("ShakeRumbleMedium")
  end)
  timers.StartLevelTimer(4.6, function()
    CSL.PlayDefaultShake("ShakeRumbleTitan")
  end)
  timers.StartLevelTimer(4.7, function()
    game.Blender.Trigger({
      Name = "FSE_sway_SlopZoom_Heavy",
      Duration = 2,
      TweenIn = {Time = 0},
      TweenOut = {Time = 3},
      Weight = 1
    })
  end)
  timers.StartLevelTimer(4.4, function()
    player:ClearMaxSpeedOverride()
  end)
end
function StartRockCamera()
  bPlayCamera = true
  camera = game.Camera.StartCamera("PLYR_Nar_2sRtn_LookAt_Rocks_Peak510")
  timers.StartLevelTimer(3.8, DisableCamera)
end
function PlayRockCollapseAnim()
  GameObjects.VibrateRockCollapse_P.Child:PlayAnimToEnd()
  PlaySoundOnBreakLoose()
  PlaySoundOnBounce()
  timers.StartLevelTimer(1, function()
    game.Audio.PlayBanter("385_TeachCrystalZap_Crystal")
  end)
end
function PlayBanter_AfterFirstCrystalPickup()
  if pickupCrystalFirstTime == false then
    game.Audio.PlayBanter("385_TeachCrystalZap_Interact")
    ThrowCrystalHintTimer = timers.StartLevelTimer(20, PlayBanter_ThrowCrystalHint)
    pickupCrystalFirstTime = true
  end
end
function PlayBanter_ThrowCrystalHint()
  game.Audio.PlayBanter("385_TeachCrystalZap_Hint")
end
function DisableCamera()
  bPlayCamera = false
end
local soundEmitter
local OnBounce = "SND_WPN_Bifrost_Bomb_Hit_Surface"
local OnBreakLoose = "SND_WPN_Vibrate_Crytsal_Break_Loose"
function SoundInit()
  local targetSoundEmitter = GameObjects.VibrateRockCollapse_P.Child:FindSingleGOByName("BifrostVibrate_Fractures").Child.Child:FindSingleSoundEmitterByName("SNDBifrostVibrateFractured_Pristine")
  if targetSoundEmitter ~= nil then
    soundEmitter = targetSoundEmitter
  end
end
function PlaySoundOnBounce()
  LD.PlaySoundOnFrame(soundEmitter, GameObjects.VibrateRockCollapse_P.Child, OnBounce, 93)
  LD.PlaySoundOnFrame(soundEmitter, GameObjects.VibrateRockCollapse_P.Child, OnBounce, 116)
  LD.PlaySoundOnFrame(soundEmitter, GameObjects.VibrateRockCollapse_P.Child, OnBounce, 121)
end
function PlaySoundOnBreakLoose()
  LD.PlaySoundOnFrame(soundEmitter, GameObjects.VibrateRockCollapse_P.Child, OnBreakLoose, 15)
end
