local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local CSL = require("camera.shakelibrary")
function OnScriptLoaded(level)
  SoundInit()
end
function SetColdContextIdle()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "COLD_BEHAVIOR_CONTEXT_CONFIG")
end
function BreakFrontPressLedge()
  LD.BreakObject(GameObjects.Peak520_PressBreak_P)
  GameObjects.TraversePath_FrontPress:HideTraversePath()
  PlaySoundOnBreak()
end
function VibrateTutorial2Complete()
  CSL.PlayDefaultShake("ShakeRumbleLarge")
  GameObjects.DragonEnergyVibrate2:Hide()
  GameObjects.Zone_DragonEnergyVibrate2:Hide()
end
function LoadCheck_Peak550()
  game.UI.LoadCheck("Peak540_PreDragonArena")
  game.UI.LoadCheck("Peak550_DragonArena")
end
function HideEndTraverseLink()
  GameObjects.vaultGrp1:Hide()
end
function ShowEndTraverseLink()
  GameObjects.vaultGrp1:Show()
end
local breakSoundEmitter, SNDDragonRoar
function SoundInit()
  breakSoundEmitter = GameObjects.SNDGrpPeak520Break:FindSingleSoundEmitterByName("SNDPeak520Break")
  SNDDragonRoar = GameObjects.SNDGrpDragonRoar:FindSingleSoundEmitterByName("SNDDragonRoar")
end
function PlaySoundOnBreak()
  LD.PlaySound(breakSoundEmitter, "SND_BRK_Rocks_Collapse_Peak520")
end
function playDragonRoar()
  LD.PlaySound(SNDDragonRoar, "SND_CHR_EarthDragon_Vox_Groan_Distant")
end
