local LD = require("design.LevelDesignLibrary")
local thisLevel
function OnScriptLoaded(level)
  thisLevel = level
  Restore_DragonBlow_VacuumFX()
end
function Checkpoint()
  GameObjects.Dbg_DragonRide_KratosRide:ClearAllAnimCallbacks()
  game.World.StoreCheckpoint()
end
function DragonRide_Shell()
  GameObjects.DragonModel1_AttackSindri:PlayAnimToFrame(300)
  GameObjects.Dbg_DragonRide_KratosRide:PlayAnimToEnd(0.75)
  GameObjects.Dbg_DragonRide_KratosRide:OnAnimDone(thisLevel, "Checkpoint")
end
function RestoreSonSindriPosition()
  GameObjects.Cine_DragonFight.LuaObjectScript.SetupLeapAcrossRocksSequence()
end
function LuaHook_Trigger_DragonBlow_VacuumFX()
  local l_breakableObj = thisLevel:GetGameObject("Peak540_dragon_blow_break")
  if l_breakableObj ~= nil then
    l_breakableObj:Show()
    l_breakableObj:JumpAnimationToFrame(0)
    l_breakableObj:PlayAnimToEnd()
  end
end
function Restore_DragonBlow_VacuumFX()
  local l_breakableObj = thisLevel:GetGameObject("Peak540_dragon_blow_break")
  if l_breakableObj ~= nil then
    l_breakableObj:Hide()
    l_breakableObj:JumpAnimationToFrame(0)
    l_breakableObj:PauseAnim()
  end
end
