local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local ND = require("design.NarrativeDesignLibrary")
local thisObj, thisLevel, player, kratosActor, sonActor, sindriActor, peak550, cine_lights_290, propsObj, wrench, poleWeapon, magicBag, sindriHorn, largeSpoon, deadFish
local dragonTooth_Started = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(thisObj)
end
function OnStart(level, obj)
  peak550 = game.FindLevel("Peak550_DragonArena")
  SetupCineLightsAndProps()
  HideCineLightsAndProps()
  if game.Level.GetVariable("CompletedCineNumber") < 290 then
    SetupCineSequence()
  end
end
function SetupCineLightsAndProps()
  propsObj = GameObjects.CineProps_SindriDragon
  wrench = propsObj:FindSingleGOByName("wrenchProp").Child
  poleWeapon = propsObj:FindSingleGOByName("sindriPoleWeaponProp").Child
  magicBag = propsObj:FindSingleGOByName("sindriMagicBagProp").Child
  sindriHorn = propsObj:FindSingleGOByName("sindriHornProp").Child
  largeSpoon = propsObj:FindSingleGOByName("largeSpoonProp").Child
  deadFish = propsObj:FindSingleGOByName("deadFishProp").Child
  cine_lights_290 = GameObjects.Cine_Start_290
end
function FindOrSpawnSindri()
  local peak550wad = game.FindLevel("Peak550_DragonArena")
  local sindri = ND.FindSindri()
  if sindri == nil then
    sindri = ND.SpawnAIAtJoint(thisLevel, "Cine_SindriDragon", "Sind_StartJoint", "CRT_Sindri00", "BRA_CineSpawnIdle", "Sindri")
  end
  return sindri
end
function SetupActors()
  kratosActor = actor.Actor.New("SINDRI DRAGON: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SINDRI DRAGON: Son Actor", game.AI.FindSon)
  sindriActor = actor.Actor.New("SINDRI DRAGON: Sindri Actor")
  sindriActor:SetSpawnFunction(FindOrSpawnSindri)
end
function SetupCineSequence()
  SetupActors()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Sindri Dragon Sequence")
  local actorTable = {
    {Actor = sonActor},
    {Actor = sindriActor},
    {
      Obj = wrench,
      Anim = "narPeakSindriDragon000"
    },
    {
      Obj = poleWeapon,
      Anim = "narPeakSindriDragon000"
    },
    {
      Obj = magicBag,
      Anim = "narPeakSindriDragon000"
    },
    {
      Obj = sindriHorn,
      Anim = "narPeakSindriDragon000"
    },
    {
      Obj = largeSpoon,
      Anim = "narPeakSindriDragon000"
    },
    {
      Obj = deadFish,
      Anim = "narPeakSindriDragon000"
    }
  }
  cineSeq:BeginMultipleWait()
  cineSeq:WaitForActorInZone(kratosActor, thisObj)
  cineSeq:WaitForFunctionTrue(CanSeqFire)
  cineSeq:EndMultipleWait()
  cineSeq:SpawnActorAndWait(sindriActor)
  cineSeq:Do(function()
    player:MeterSetValue("Health", player:MeterGetMax("Health"))
  end)
  cineSeq:ActorSync(kratosActor, {
    Slaves = actorTable,
    Branch = "BRA_SindriDragonCine",
    ReferenceJoint = "SindriDragon_SynchJoint"
  })
  cineSeq:Do(function()
    cineSeq:MarkAbleToSkip()
  end)
  cineSeq:Do(ShowCineLightsAndProps)
  cineSeq:Do(HideSindriBag)
  cineSeq:Do(PlayCineLights)
  cineSeq:Do(SwapArrowVisuals)
  cineSeq:Do(SwapToBrokenQuiver)
  cineSeq:WaitFrames(1)
  cineSeq:Do(HideBaseArrowVisual)
  cineSeq:WaitForActorPuppeteerComplete(kratosActor)
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(sindriActor)
  cineSeq:Do(HideCineLightsAndProps)
  cineSeq:Do(ShowSindriBag)
  cineSeq:SetCompletedCineNumber(290)
  cineSeq:Do(AwardTrophy)
  cineSeq:Do(BestiaryUnlock)
  cineSeq:Do(function()
    cineSeq:EndSkipIfActive()
  end)
  cineSeq:Do(function()
    peak550:CallScript("EnableToothInteract")
  end)
  cineSeq:Do(function()
    GameObjects.Cine_VibrateArrows.LuaObjectScript.ShopAfterSindriDragon()
  end)
  cineSeq:Do(DragonTooth_Idle_Banter)
  cineSeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "09_PeaksPass_050_DragonDead"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  cineSeq:StartSequence()
end
function HideSindriBag()
  local bagJointIndex = sindriActor:GetCreature():GetJointIndex("BagVis")
  sindriActor:GetCreature():HideJoint(bagJointIndex)
end
function ShowSindriBag()
  local bagJointIndex = sindriActor:GetCreature():GetJointIndex("BagVis")
  sindriActor:GetCreature():ShowJoint(bagJointIndex)
end
function AwardTrophy()
  print("Award Trophy: Dragon Slayer")
  game.UnlockTrophy(4)
end
function BestiaryUnlock()
  LD.UnlockBestiaryEntry("Bestiary_Unlock_Hr\195\166zlyr")
end
function SwapArrowVisuals()
  game.Wallets.AddResource("HERO", "ArrowUnlockStage2", 1, "NO_TELEMETRY")
end
function HideBaseArrowVisual()
  game.AI.FindSon():CallScript("HideBaseArrow")
end
function ShowCineLightsAndProps()
  cine_lights_290:Show()
  propsObj:Show()
end
function CanSeqFire()
  return game.Level.GetVariable("CompletedCineNumber") < 290
end
function PlayCineLights()
  cine_lights_290:Show()
  cine_lights_290:JumpAnimToFrame(0)
  cine_lights_290:PlayAnimToEnd()
end
function HideCineLightsAndProps()
  cine_lights_290:Hide()
  propsObj:Hide()
end
function DragonTooth_Idle_Banter()
  timers.StartLevelTimer(15, function()
    if not dragonTooth_Started then
      game.Audio.PlayBanter("400_DragonsTooth_Idle")
      timers.StartLevelTimer(12, DragonTooth_Idle_Banter)
    end
  end)
end
function Set_DragonTooth_Started()
  dragonTooth_Started = true
end
function DragonTooth_Approach_Banter()
  timers.StartLevelTimer(2.3, function()
    game.Audio.PlayBanter("400_DragonTooth_Approach")
  end)
  GameObjects.Cine_VibrateArrows.LuaObjectScript.PreVibrateArrowsIdle()
end
function DragonTooth_Victory_Banter()
  timers.StartLevelTimer(2.5, function()
    game.Audio.PlayBanter("400_DragonTooth_Victory")
  end)
  GameObjects.SmallShop.LuaObjectScript.EnableVendorInteract()
  GameObjects.Cine_VibrateArrows.LuaObjectScript.ShopAfterDragonTooth()
end
function SwapToBrokenQuiver()
  ND.SafePickupSetStage(sonActor:GetCreature(), "SonStrap_Visual", 1)
end
