local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local actor = require("narrative.actor")
local PeakDragonModule = require("combat.PeakDragonModule")
local BossEncounter = require("boss.statemachine")
local heroPuppeteer, thisLevel, player, son, sindri, dragonCrane, AimDriverName, AimDriverNameCustom, toothChopped, kratosActor, sindriClampPOIpos, puppeteerRefObject
local warpoffset = engine.Vector.New(2, 0, 2)
local restartCounter
introMsg = false
tutMsg1 = false
local hintCrystalTimer_ID, hintMeleeTimer_ID, hintCombatTimer_ID
local CrystalGrabCounter = 0
local incorrectCrystalGrabCounter = 0
local finaleTutorial = false
local replayTUT = true
local cameraPhase
local isLoadFromSave = false
local L1buttonMonitor, dragonActor
local dragonDefaultHealth = 1900
local DragonHealthMonitor
local isStunTimerActive = false
local stunTimer = 18
local dragonVulDebuffTimer_ID
local dragonVulDebuffTimer = 0.5
local CrystalSpawners = {
  "CrystalSpawner_locEntrance",
  "CrystalSpawner_locPerchEdge",
  "CrystalSpawner_locExit",
  "CrystalSpawner_locCenter"
}
local allCrystalSpawners = {}
local BossStage_2_0 = BossEncounter:AddStage("BossStage_2_0")
local BossStage_2_1 = BossEncounter:AddStage("BossStage_2_1")
local BossStage_transDragonSpitToPos1 = BossEncounter:AddStage("BossStage_transDragonSpitToPos1")
local BossStage_Pos1_Breath = BossEncounter:AddStage("BossStage_Pos1_Breath", true)
local BossStage_Pos1_Stun = BossEncounter:AddStage("BossStage_Pos1_Stun")
local BossStage_transPos1toPos3 = BossEncounter:AddStage("BossStage_transPos1toPos3")
local BossStage_Pos3_Melee = BossEncounter:AddStage("BossStage_Pos3_Melee", true)
local BossStage_Pos3_Breath = BossEncounter:AddStage("BossStage_Pos3_Breath")
local BossStage_Pos3_Stun = BossEncounter:AddStage("BossStage_Pos3_Stun")
local BossStage_transPos3toPos2 = BossEncounter:AddStage("BossStage_transPos3toPos2")
local BossStage_Pos2_Melee = BossEncounter:AddStage("BossStage_Pos2_Melee", true)
local BossStage_Pos2_Breath = BossEncounter:AddStage("BossStage_Pos2_Breath")
local BossStage_Pos2_Stun = BossEncounter:AddStage("BossStage_Pos2_Stun")
local BossStage_transPos2toTugofWar = BossEncounter:AddStage("BossStage_transPos2toTugofWar")
local BossStage_TugWar_Pos02_Melee = BossEncounter:AddStage("BossStage_TugWar_Pos02_Melee", true)
local BossStage_TugWar_Pos02_Breath = BossEncounter:AddStage("BossStage_TugWar_Pos02_Breath")
local BossStage_TugWar_Pos02_Stun = BossEncounter:AddStage("BossStage_TugWar_Pos02_Stun")
local BossStage_ClampFinale = BossEncounter:AddStage("BossStage_ClampFinale")
local BossStage_ClampFinaleLoop = BossEncounter:AddStage("BossStage_ClampFinaleLoop")
local BossStage_DeathPose = BossEncounter:AddStage("BossStage_DeathPose")
function BossStage_2_0:OnEnter(level, debugSkip)
  dragonActor:SetCharacterConfig("pristineHead")
  if isLoadFromSave then
    local wad = game.FindLevel("Peak540_PreDragonArena")
    if game.Level.GetVariable("CompletedCineNumber") == 280 then
      wad:CallScript("RestoreSonSindriPosition")
    end
    isLoadFromSave = false
  end
end
function BossStage_2_1:OnEnter(level, debugSkip)
  PeakDragonModule.ForceAllHudOff()
  PeakDragonModule.InitMetersForStartOfArena()
  player:MeterSetValue("Health", player:MeterGetMax("Health"))
  PlayCraneRetractedPose()
  PeakDragonModule.ResetMomentum()
end
function BossStage_transDragonSpitToPos1:OnEnter(level, debugSkip)
  local slaveTable = {
    syncSon = true,
    syncHero = true,
    syncSindri = true
  }
  PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_csDragonSpitKratosToStg3", dragonActor, "Phase3ArenaSyncJoint", self.stateName, slaveTable)
  uiCalls.UI_Event_TurnOffDesignerMessage()
  PeakDragonModule.ToggleMeterBarVis(false)
  PeakDragonModule.ForceAllHudOff()
end
function BossStage_transDragonSpitToPos1:OnExit()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  PeakDragonModule.ToggleMeterBarVis(true)
  PeakDragonModule.ForceAllHudOnNoCompass()
end
function BossStage_Pos1_Breath:OnEnter(level, debugSkip)
  if replayTUT == true then
    TUT_CrystalThrowHint_Timer(45)
  end
  if dragonActor:AttributeGetValue("Difficulty") == 4 then
    replayTUT = false
  end
  son:Warp(GameObjects.WarpToClampPOI:GetWorldPosition(), GameObjects.WarpToClampPOI:GetWorldPosition())
  LD.PlayMove(son, puppeteerRefObject, "MOV_Crystal_POIIdle")
  sindri = PeakDragonModule.FindSindri()
  sindri:Warp(sindriClampPOIpos, GameObjects.WarpToClampPOI:GetWorldPosition(), engine.Vector.New(0, 0, 1))
  LD.PlayMove(sindri, puppeteerRefObject, "MOV_Crystal_POIIdle")
  if isLoadFromSave or debugSkip then
    print("load from save")
    if isLoadFromSave then
      CheckForRestartCrystalTutorial()
    end
    PeakDragonModule.ToggleMeterBarVis(true)
    PeakDragonModule.ForceAllHudOnNoCompass()
    LuaHook_Peak550_ShowAllCrystalSpawners()
    if dragonActor:PickupGetStage("EarthDragon_HitBombFaceCounter") == 0 then
      PeakDragonModule.InitMetersForStartOfArena()
      dragonActor:SetCharacterConfig("pristineHead")
    end
    player:CallScript("LuaHook_DisableRevive", true)
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos01navIdle_SYNC", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    isLoadFromSave = false
  end
  cameraPhase = 1
  GameObjects.CamTargDragonBasePos00:ShowCameraTargets()
  GameObjects.CamTargDragonBasePos03:HideCameraTargets()
  GameObjects.CamTargDragonBasePos03Middle:HideCameraTargets()
  PlayCraneReadyPose()
  player:CallScript("LuaHook_DisableRevive", true)
end
function BossStage_Pos1_Breath:OnExit(level)
  ResetHintTimers()
  replayTUT = true
end
function BossStage_Pos1_Stun:OnEnter(level, debugSkip)
  LuaHook_Peak550_ElectricMode_FullScreenEffect_Deactivate()
  if debugSkip then
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos01hitStunBombFaceLoop", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    LuaHook_InitMetersForStartOfPos01Stun()
  end
  dragonActor:SetCharacterConfig("damageState_p1")
end
function BossStage_transPos1toPos3:OnEnter(level, debugSkip)
  dragonActor:PickupSetStage("EarthDragon_HitBombFaceCounter", 0)
  LuaHook_Peak550_DestroyCrystalTrans01to03()
  PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos01hitBombFace_trans", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
  LuaHook_Peak550_ElectricMode_FullScreenEffect_Deactivate()
end
function BossStage_Pos3_Melee:OnEnter(level, debugSkip)
  if replayTUT == true then
    TUT_DragonMeleeHint_Timer(30)
    CheckForDragonCombatReminder(59)
  end
  if dragonActor:AttributeGetValue("Difficulty") == 4 then
    replayTUT = false
  end
  if debugSkip or isLoadFromSave then
    if isLoadFromSave then
      CheckForRestartCombatTutorial()
    end
    dragonActor:SetCharacterConfig("damageState_p1")
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos03navIdle_SYNC", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    PeakDragonModule.ToggleMeterBarVis(true)
    PeakDragonModule.ForceAllHudOnNoCompass()
    PeakDragonModule.InitMetersForStartOfPos03Melee()
    son:Warp(GameObjects.WarpToClampPOI:GetWorldPosition(), GameObjects.WarpToClampPOI:GetWorldPosition())
    LD.PlayMove(son, puppeteerRefObject, "MOV_Crystal_POIIdle")
    sindri = PeakDragonModule.FindSindri()
    sindri:Warp(sindriClampPOIpos, GameObjects.WarpToClampPOI:GetWorldPosition(), engine.Vector.New(0, 0, 1))
    LD.PlayMove(sindri, puppeteerRefObject, "MOV_Crystal_POIIdle")
    player:CallScript("LuaHook_DisableRevive", true)
    isLoadFromSave = false
  end
  cameraPhase = 1
  GameObjects.CamTargDragonBasePos00:HideCameraTargets()
  GameObjects.CamTargDragonBasePos03:ShowCameraTargets()
  GameObjects.CamTargDragonBasePos03Middle:HideCameraTargets()
end
function BossStage_Pos3_Melee:OnUpdate(level)
  SaveCustomDriverForRake()
  ToggleRakeEnvCollisionOnMoves()
end
function BossStage_Pos3_Melee:OnExit(level)
  ResetHintTimers()
  dragonActor:HideJoint(dragonActor:GetJointIndex("JORakeCollision"))
  dragonActor:TriggerMoveEvent("kLEMeleeReact_ToElectricMode")
  dragonActor:StartMaterialAnim("hand_damage1")
  replayTUT = true
end
function BossStage_Pos3_Breath:OnEnter(level, debugSkip)
  if replayTUT == true then
    TUT_CrystalThrowHint_Timer(30)
  end
  if dragonActor:AttributeGetValue("Difficulty") == 4 then
    replayTUT = false
  end
  if debugSkip then
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos03BreathIdle_SYNC", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    ResetMeterBars()
  end
  dragonActor:TriggerMoveEvent("kLE_SetInvulnerability_DurationLong")
end
function BossStage_Pos3_Breath:OnUpdate(level)
  SaveCustomDriverForRake()
  ToggleRakeEnvCollisionOnMoves()
end
function BossStage_Pos3_Breath:OnExit(level)
  ResetHintTimers()
  replayTUT = true
end
function BossStage_Pos3_Stun:OnEnter(level, debugSkip)
  LuaHook_Peak550_ElectricMode_FullScreenEffect_Deactivate()
  if debugSkip then
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos03hitStunBombFaceLoop", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    LuaHook_InitMetersForStartOfPos03Stun()
  end
  dragonActor:SetCharacterConfig("damageState_p2")
end
function BossStage_transPos3toPos2:OnEnter(level, debugSkip)
  dragonActor:PickupSetStage("EarthDragon_HitBombFaceCounter", 0)
  LuaHook_Peak550_DestroyCrystalTrans03to02()
  PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos03hitBombFace_trans", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
  LuaHook_Peak550_ElectricMode_FullScreenEffect_Deactivate()
end
function BossStage_Pos2_Melee:OnEnter(level, debugSkip)
  son:Warp(GameObjects.WarpToClampPOI:GetWorldPosition(), GameObjects.WarpToClampPOI:GetWorldPosition())
  LD.PlayMove(son, puppeteerRefObject, "MOV_Crystal_POIIdle")
  cameraPhase = 1
  GameObjects.CamTargDragonBasePos00:HideCameraTargets()
  GameObjects.CamTargDragonBasePos03:HideCameraTargets()
  GameObjects.CamTargDragonBasePos03Middle:ShowCameraTargets()
  if replayTUT == true then
    TUT_DragonMeleeHint_Timer(30)
    CheckForDragonCombatReminder(59)
  end
  if dragonActor:AttributeGetValue("Difficulty") == 4 then
    replayTUT = false
  end
  if debugSkip or isLoadFromSave then
    dragonActor:SetCharacterConfig("damageState_p2")
    if isLoadFromSave then
      CheckForRestartCombatTutorial()
    end
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos02navIdle_SYNC", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    PeakDragonModule.ToggleMeterBarVis(true)
    PeakDragonModule.ForceAllHudOnNoCompass()
    PeakDragonModule.InitMetersForStartOfPos02Melee()
    son:Warp(GameObjects.WarpToClampPOI:GetWorldPosition(), GameObjects.WarpToClampPOI:GetWorldPosition())
    LD.PlayMove(son, puppeteerRefObject, "MOV_Crystal_POIIdle")
    sindri = PeakDragonModule.FindSindri()
    sindri:Warp(sindriClampPOIpos, GameObjects.WarpToClampPOI:GetWorldPosition(), engine.Vector.New(0, 0, 1))
    LD.PlayMove(sindri, puppeteerRefObject, "MOV_Crystal_POIIdle")
    player:CallScript("LuaHook_DisableRevive", true)
    isLoadFromSave = false
  end
end
function BossStage_Pos2_Melee:OnUpdate(level)
  SaveCustomDriverForRake()
  ToggleRakeEnvCollisionOnMoves()
end
function BossStage_Pos2_Melee:OnExit(level)
  dragonActor:TriggerMoveEvent("kLEMeleeReact_ToElectricMode")
  dragonActor:StartMaterialAnim("hand_damage2")
  ResetHintTimers()
  replayTUT = true
end
function BossStage_Pos2_Breath:OnEnter(level, debugSkip)
  if replayTUT == true then
    TUT_CrystalThrowHint_Timer(30)
    CheckForDragonCombatReminder(59)
  end
  if dragonActor:AttributeGetValue("Difficulty") == 4 then
    replayTUT = false
  end
  dragonActor:TriggerMoveEvent("kLE_SetInvulnerability_DurationLong")
end
function BossStage_Pos2_Breath:OnUpdate(level)
  SaveCustomDriverForRake()
  ToggleRakeEnvCollisionOnMoves()
end
function BossStage_Pos2_Breath:OnExit(level)
  ResetHintTimers()
  replayTUT = true
end
function BossStage_Pos2_Stun:OnEnter(level, debugSkip)
  LuaHook_Peak550_ElectricMode_FullScreenEffect_Deactivate()
  if debugSkip then
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos02hitStunBombFaceLoop", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    LuaHook_InitMetersForStartOfPos02Stun()
  end
  dragonActor:SetCharacterConfig("damageState_p3")
end
function BossStage_transPos2toTugofWar:OnEnter(level, debugSkip)
  dragonActor:PickupSetStage("EarthDragon_HitBombFaceCounter", 0)
  PeakDragonModule.ForceAllHudOff()
  PeakDragonModule.ToggleMeterBarVis(false)
  LuaHook_Peak550_DestroyCrystalTrans02toTugofwar()
  PeakDragonModule.ResetMomentum()
  local slaveTable = {
    prop1 = dragonCrane,
    propAnim = "Stg3_Pos02hitStunBombFace_trans",
    syncSon = true,
    syncHero = false,
    syncSindri = true
  }
  PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos02hitBombFace_trans", dragonActor, "Phase3ArenaSyncJoint", self.stateName, slaveTable)
  TransitionToTugOfWar_KratosSync()
  LuaHook_Peak550_ElectricMode_FullScreenEffect_Deactivate()
end
function BossStage_transPos2toTugofWar:OnExit(level, debugSkip)
  PeakDragonModule.ToggleMeterBarVis(true)
  PeakDragonModule.ForceAllHudOnNoCompass()
end
function BossStage_TugWar_Pos02_Melee:OnEnter(level, debugSkip)
  sindri = PeakDragonModule.FindSindri()
  sindri:Warp(sindriClampPOIpos, GameObjects.WarpToClampPOI:GetWorldPosition(), engine.Vector.New(0, 0, 1))
  LD.PlayMove(sindri, puppeteerRefObject, "MOV_Crystal_POIIdle")
  CraneFinalePose()
  cameraPhase = 1
  GameObjects.CamTargDragonBasePos00:HideCameraTargets()
  GameObjects.CamTargDragonBasePos03:HideCameraTargets()
  GameObjects.CamTargDragonBasePos03Middle:ShowCameraTargets()
  if dragonActor:AttributeGetValue("Difficulty") ~= 4 then
    TUT_DragonMeleeHint_Timer(45)
    CheckForDragonCombatReminder(89)
  end
  local l_FinalSonClampPOIpos = engine.Vector.New(-482.66, 1174.65, 1025.55)
  local l_FinaleSonClampPOIdir = 145.819
  son:Warp(l_FinalSonClampPOIpos, l_FinaleSonClampPOIdir)
  LD.PlayMove(son, puppeteerRefObject, "MOV_Crystal_POIIdle")
  if debugSkip or isLoadFromSave then
    if isLoadFromSave then
      CheckForRestartCombatTutorial()
    end
    dragonActor:SetCharacterConfig("damageState_p3")
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_TugofWar02navIdle_SYNC", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    PeakDragonModule.ToggleMeterBarVis(true)
    PeakDragonModule.ForceAllHudOnNoCompass()
    PeakDragonModule.InitMetersForStartOfTugOfWar()
    player:CallScript("LuaHook_DisableRevive", true)
    isLoadFromSave = false
  end
end
function BossStage_TugWar_Pos02_Melee:OnExit(level)
  ResetHintTimers()
end
function BossStage_TugWar_Pos02_Breath:OnEnter(level, debugSkip)
  if debugSkip then
    dragonActor:ShowJoint(dragonActor:GetJointIndex("HeadCrystalCollision"))
    LuaHook_InitMetersForStartOfTugOfWar()
  end
  if dragonActor:AttributeGetValue("Difficulty") ~= 4 then
    TUT_CrystalThrowHint_Timer(60)
  end
  dragonActor:TriggerMoveEvent("kLE_SetInvulnerability_DurationLong")
  dragonActor:TriggerMoveEvent("kLEMeleeReact_ToElectricMode_FromTug")
  dragonActor:StartMaterialAnim("hand_damage3")
end
function BossStage_TugWar_Pos02_Breath:OnUpdate(level)
end
function BossStage_TugWar_Pos02_Breath:OnExit(level)
  ResetHintTimers()
end
function BossStage_TugWar_Pos02_Stun:OnEnter(level, debugSkip)
  LuaHook_Peak550_ElectricMode_FullScreenEffect_Deactivate()
  if debugSkip then
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_TugofWar02hitStunBombFaceLoop_SYNC", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
    LuaHook_InitMetersForStartOfTugOfWarStun()
  end
  local l_FinalSonClampPOIpos = engine.Vector.New(-482.66, 1174.65, 1025.55)
  local l_FinaleSonClampPOIdir = 145.819
  son:Warp(l_FinalSonClampPOIpos, l_FinaleSonClampPOIdir)
  LD.PlayMove(son, puppeteerRefObject, "MOV_Crystal_POIIdle")
  dragonActor:SetCharacterConfig("damageState_p4")
end
function BossStage_ClampFinale:OnEnter(level)
  PeakDragonModule.ForceAllHudOff()
  if player:PickupIsAcquired("EarthDragon_RageMode") then
    player:PickupSetStage("EarthDragon_RageMode", 0)
    player:PickupDeactivate("EarthDragon_RageMode")
  end
  dragonActor:PickupSetStage("EarthDragon_HitBombFaceCounter", 0)
  PeakDragonModule.ResetMomentum()
  local slaveTable = {
    prop1 = dragonCrane,
    propAnim = "Stg3_csDragonFinisherStart",
    syncSon = true,
    syncHero = false,
    syncSindri = false
  }
  PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_csDragonFinisherStart", dragonActor, "Phase3ArenaSyncJoint", self.stateName, slaveTable)
  DragonFinisher_KratosSync()
end
function BossStage_ClampFinale:OnExit(level)
end
function BossStage_ClampFinaleLoop:OnEnter(level)
  PeakDragonModule.ForceAllHudOff()
end
function BossStage_DeathPose:OnEnter(level)
  SetGiantCrystalStateToBroken()
  dragonActor:HideJoint(dragonActor:GetJointIndex("HeadCrystalCollision"))
  Show_CineZone_SindriDragon()
  if toothChopped then
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_DeadPose_SplinterTooth", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
  else
    PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_DeadPose", dragonActor, "Phase3ArenaSyncJoint", self.stateName)
  end
  dragonActor:SetCharacterConfig("damageState_p5")
  PeakDragonModule.ToggleMeterBarVis(false)
  player:CallScript("LuaHook_DisableRevive", false)
end
function BossStage_DeathPose:OnExit(level)
  game.Compass.Show()
end
function BossEncounter:OnEnter(level)
  if dragonVulDebuffTimer_ID ~= nil then
    dragonVulDebuffTimer_ID:Finish()
  end
  if dragonActor:PickupIsAcquired("EarthDragon_CrystalVulnerability") and dragonActor:PickupGetStage("EarthDragon_CrystalVulnerability") ~= 2 then
    dragonActor:PickupSetStage("EarthDragon_CrystalVulnerability", 2)
  end
  if dragonActor ~= nil then
    dragonActor:AddMarker(BossEncounter:GetActiveStateName())
    dragonActor:TriggerMoveEvent("kLE_SetInvulnerability_DurationShort")
  end
end
function BossEncounter:OnExit(level)
  if dragonActor ~= nil then
    dragonActor:RemoveMarker(BossEncounter:GetPreviousStateName())
  end
end
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  sindri = PeakDragonModule.FindSindri()
  thisLevel = level
  dragonCrane = level:FindSingleGameObject("dragonCrane").Child
  sindriClampPOIpos = GameObjects.WarpToClampPOI:GetWorldPosition() + engine.Vector.New(1, 0, 0)
  BossEncounter:SetDebugInput(true)
  puppeteerRefObject = level:FindSingleGameObject("SyncScriptGroup")
  PeakDragonModule.SetupBossEncounter(BossEncounter)
  cameraPhase = 0
  allCrystalSpawners = thisLevel:FindGameObjects("CrystalSpawner_loc*")
  PlayCraneReadyPose()
  SoundOnInit()
  RestoreGiantCrystalState()
end
function OnFirstStart(level)
  print("first start")
end
function OnStartGameFromThisLevel(level)
  print("OnStartGameFromThisLevel")
  BossEncounter:SetActiveState("BossStage_Pos1_Breath")
  PeakDragonModule.InitMetersForStartOfArena()
  PeakDragonModule.ToggleMeterBarVis(true)
  son:Warp(GameObjects.WarpToClampPOI:GetWorldPosition(), GameObjects.WarpToClampPOI:GetWorldPosition())
  LD.PlayMove(son, puppeteerRefObject, "MOV_Crystal_POIIdle")
  PeakDragonModule.SyncOnlyDragonToArena(puppeteerRefObject, "BRA_Stg3_Pos01navIdle_SYNC", dragonActor, "Phase3ArenaSyncJoint", "BossStage_Pos1_Breath")
  if sindri == nil then
    game.AI.Spawn(level, sindriClampPOIpos, engine.Vector.New(0, 0, 1), "CRT_Sindri00", "BRA_Crystal_POIIdle")
  end
  dragonActor:SetCharacterConfig("pristineHead")
end
function OnStart(level)
  spawnDragonBoss()
  EnableToothInteract()
  if game.Level.GetVariable("CompletedCineNumber") >= 290 then
    BossEncounter:SetActiveState("BossStage_DeathPose")
    if toothChopped == true then
      timers.StartLevelTimer(1, function()
        HideDragonTooth()
      end)
    end
  end
  Hide_CineZone_SindriDragon()
  if not dragonActor:PickupIsAcquired("EarthDragon_HitBombFaceCounter") then
    dragonActor:PickupAcquire("EarthDragon_HitBombFaceCounter")
  end
  dragonActor:PickupSetStage("EarthDragon_HitBombFaceCounter", 0)
  local dragonInteract = GameObjects.InteractZone_Phase2CS.LuaObjectScript.GetInteractZone()
  LD.OverrideInteractZone(dragonInteract, {onScreenPercent = 0})
  GameObjects.FinaleCollision:Hide()
  Reset_Dragon_StunBombFace_Breakables()
  dragonActor:SetCombatTarget(player)
  dragonActor:RequestHighPriorityUpdate()
end
function OnUpdate(level)
  if player:IsInsideEntityZone("Zone_PlaytestStartMsg") and introMsg == false then
    timers.StartLevelTimer(1, function()
      uiCalls.UI_Event_SendDesignerMessage([[
Kratos and Son have just killed the Peaks Pass Dragon and acquired one of its teeth,
 which they have given to Sindri to receive a new ability: Bifrost VIBRATE]], -1)
    end)
    introMsg = true
  end
  if player:IsInsideEntityZone("Zone_TutorialMsg1") and tutMsg1 == false then
    TUT.EquipBifrost_Tutorial()
    tutMsg1 = true
  end
  if player:IsInsideEntityZone("Zone_DebugSonWarp") then
    game.AI.FindSon():Warp(player:GetWorldPosition() + warpoffset, player:GetWorldForward())
  end
  if cameraPhase == 1 then
    SubmitDragonBossCamera550_Base()
  elseif cameraPhase == 2 then
    SubmitDragonBossCamera550_Clamp()
  end
  PeakDragonModule.DragonHealthMonitor_OnUpdate()
  if PeakDragonModule.FinaleCameraReady() then
    game.Camera.SubmitCameraByName("ENV_Vista_EarthDragon_SonPlatform")
  end
  if finaleTutorial == false then
    local l_dragonHealth = dragonActor:MeterGetValue("DragonBossHealth")
    if l_dragonHealth < 350 and 2 <= dragonActor:PickupGetStage("EarthDragon_HitBombFaceCounter") and finaleTutorial == false then
      TUT.Peak550_CommandSon_Tutorial()
      finaleTutorial = true
    end
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_VibrateArrowTutorial") then
    if player:HasMarker("Aiming") then
      game.Camera.SubmitCameraByName("AIM_Spline_VibrateArrowTutorial")
    else
      game.Camera.SubmitCameraByName("PLYR_Spline_VibrateArrowTutorial")
    end
  end
end
function DisableSplineCamera()
  local camzone = thisLevel:GetGameObject("CamZone_VibrateArrowTutorial")
  camzone:HideCameraVolume()
end
function EnableToothInteract()
  local toothInteract = thisLevel:GetGameObject("DragonToothChop")
  if game.Level.GetVariable("CompletedCineNumber") >= 290 and not game.Wallets.HasResource("HERO", "DragonTooth") and toothInteract ~= nil then
    toothInteract.LuaObjectScript.Enable()
  end
end
function QuestStoneFixup()
  local questState = game.QuestManager.GetQuestState("Quest_Sindri_Epic_01_Objective_02")
  local entryStone = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneForestDungeon")
  if (entryStone == 0 or entryStone == -1) and questState == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneForestDungeon", 1)
  end
  local questState2 = game.QuestManager.GetQuestState("Quest_Brok_Epic_01_Objective_01")
  local entryStone2 = game.Wallets.GetResourceValue("HERO_SAVEONLY", "EntryStoneVolundr")
  if (entryStone2 == 0 or entryStone2 == -1) and questState2 == "Active" then
    game.Wallets.AddResource("HERO_SAVEONLY", "EntryStoneVolundr", 1)
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    toothChopped = toothChopped,
    restartCounter = restartCounter
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  isLoadFromSave = true
  if dragonActor == nil and BossEncounter:GetBoss() == nil then
    dragonActor = FindEarthDragon()
    if dragonActor ~= nil then
      BossEncounter:AddBoss(dragonActor)
    end
  end
  if player == nil then
    player = game.Player.FindPlayer()
  end
  player:CallScript("LuaHook_DisableRevive", true)
  checkpoint.Restore(savedInfo.levelstate)
  toothChopped = savedInfo.toothChopped
  restartCounter = savedInfo.restartCounter
  if restartCounter == nil then
    restartCounter = 0
  end
  restartCounter = restartCounter + 1
  local appVersion, masterVersion = level:GetAppMasterVersion()
  if appVersion == 256 then
    local player = game.Player.FindPlayer()
    local son = game.AI.FindSon()
    local savedAvailState = son:GetAvailabilityStateRequestByName("LevelDesignScript")
    if savedAvailState ~= nil and savedAvailState.Unoccupied == false then
      local vendorCheckpointPos = engine.Vector.New(-481.695, 1163.5, 997.975)
      if player:GetWorldPosition():Distance(vendorCheckpointPos) < 2 then
        son:RemoveAvailabilityRequest("LevelDesignScript")
        if savedAvailState.AvailableForSync == false or savedAvailState.AvailableForBanter == false or savedAvailState.AvailableInLevel == false or savedAvailState.AvailableForCombat == false then
          savedAvailState.Unoccupied = true
          son:SetNewAvailabilityRequest("LevelDesignScript", savedAvailState)
        end
      end
    end
    QuestStoneFixup()
  end
end
function LuaHook_AcquirePickup_CrystalVul(ai, data)
  if dragonActor ~= nil then
    dragonActor:PickupAcquire("EarthDragon_CrystalVulnerability")
    dragonActor:PickupSetStage("EarthDragon_CrystalVulnerability", 0)
    dragonActor:PickupActivate("EarthDragon_CrystalVulnerability")
  end
end
function LuaHook_SetVulnerabilityMarker(ai, data)
  if dragonActor ~= nil then
    if dragonVulDebuffTimer_ID == nil then
      dragonActor:AddMarker("DRAGON_VULNERABLE_PADDED")
      if dragonActor:PickupIsAcquired("EarthDragon_CrystalVulnerability") and dragonActor:PickupGetStage("EarthDragon_CrystalVulnerability") ~= 2 and dragonActor:HasMarker("DRAGON_VULNERABLE") == false then
        dragonActor:PickupSetStage("EarthDragon_CrystalVulnerability", 2)
      end
      dragonVulDebuffTimer_ID = timers.StartLevelTimer(dragonVulDebuffTimer, function()
        if dragonVulDebuffTimer_ID ~= nil then
          dragonActor:RemoveMarker("DRAGON_VULNERABLE_PADDED")
          dragonVulDebuffTimer_ID = nil
        end
      end)
    else
      dragonVulDebuffTimer_ID:Restart()
    end
  end
end
function LuaHook_DamageHealthBar(ai, data)
  PeakDragonModule.DamageHealthBar()
end
function LuaHook_FinaleWin()
  dragonActor:TriggerMoveEvent("LE_EarthDragon_FinisherExit")
end
function LuaHook_BossForwardState()
  BossEncounter:ForwardState()
end
function LuaHook_BossBackwardState()
  BossEncounter:BackwardState()
end
function LuaHook_Peak550_BossForwardState()
  BossEncounter:ForwardState()
end
function LuaHook_ForceStunBossState()
  local currentState = BossEncounter:GetActiveStateName()
  if currentState == "BossStage_Pos1_Breath" then
    BossEncounter:SetActiveState("BossStage_Pos1_Stun")
  elseif currentState == "BossStage_Pos3_Melee" or currentState == "BossStage_Pos3_Breath" then
    BossEncounter:SetActiveState("BossStage_Pos3_Stun")
  elseif currentState == "BossStage_Pos2_Melee" or currentState == "BossStage_Pos2_Breath" then
    BossEncounter:SetActiveState("BossStage_Pos2_Stun")
  elseif currentState == "BossStage_TugWar_Pos02_Melee" or currentState == "BossStage_TugWar_Pos02_Breath" then
    BossEncounter:SetActiveState("BossStage_TugWar_Pos02_Stun")
  end
end
function LuaHook_Peak550_SetActiveState_TugWar_Pos00()
  BossEncounter:SetActiveState("BossStage_TugWar_Pos00_Melee")
end
function LuaHook_WarpToDragonArena()
  WarpToDragonArena()
end
function LuaHook_DragonSpitKratosToStg3()
  player:TriggerMoveEvent("LE_S2_DragonSpitKratosToStg3")
end
function LuaHook_Peak550_DestroyCrystalTrans01to03(ai, data)
  local l_CrystalSpawners = {
    "CrystalSpawner_locCenter"
  }
  HideTableOfCrystalSpawners(l_CrystalSpawners)
end
function LuaHook_Peak550_DestroyCrystalTrans03to02(ai, data)
  local l_CrystalSpawners = {
    "CrystalSpawner_locEntrance"
  }
  HideTableOfCrystalSpawners(l_CrystalSpawners)
end
function LuaHook_Peak550_DestroyCrystalTrans02toTugofwar(ai, data)
  local l_CrystalSpawners = {
    "CrystalSpawner_locPerchEdge"
  }
  HideTableOfCrystalSpawners(l_CrystalSpawners)
end
function HideTableOfCrystalSpawners(l_table)
  for i, l_obj in ipairs(l_table) do
    print("Hide Crystal Spawner" .. tostring(i) .. "-" .. tostring(l_obj))
    local l_spawner = thisLevel:GetGameObject(l_table[i])
    for _, c in pairs(l_spawner.Children) do
      c.Child.LuaObjectScript.InteractDisable()
    end
    l_spawner:Hide()
  end
end
function LuaHook_Peak550_HideAllCrystalSpawners(ai, data)
  for i, l_obj in pairs(allCrystalSpawners) do
    print("Hide Crystal Spawner" .. tostring(i) .. "-" .. tostring(l_obj))
    for _, c in pairs(l_obj.Children) do
      c.Child.LuaObjectScript.InteractDisable()
    end
    l_obj:Hide()
  end
end
function LuaHook_Peak550_ShowAllCrystalSpawners(ai, data)
  for i, l_obj in pairs(allCrystalSpawners) do
    print("Show Crystal Spawner" .. tostring(i) .. "-" .. tostring(l_obj))
    for _, c in pairs(l_obj.Children) do
      c.Child.LuaObjectScript.InteractEnable()
    end
    l_obj:Show()
  end
end
function LuaHook_ToggleMeterOn(ai, data)
  PeakDragonModule.ToggleMeterBarVis(true)
end
function LuaHook_ToggleMeterOff(ai, data)
  PeakDragonModule.ToggleMeterBarVis(false)
end
function LuaHook_ForceAllHudOn(ai, data)
  PeakDragonModule.ForceAllHudOn()
end
function LuaHook_Peak550_ElectricMode_FullScreenEffect_Activate()
  if not player:PickupIsAcquired("EarthDragon_RageMode") then
    player:PickupAcquire("EarthDragon_RageMode")
  end
  if player:PickupGetStage("EarthDragon_RageMode") >= 1 then
    player:PickupSetStage("EarthDragon_RageMode", 0)
    player:PickupDeactivate("EarthDragon_RageMode")
    timers.StartLevelTimer(0.5, function()
      game.Player.FindPlayer():PickupSetStage("EarthDragon_RageMode", 1)
      game.Player.FindPlayer():PickupActivate("EarthDragon_RageMode")
    end)
  else
    player:PickupSetStage("EarthDragon_RageMode", 1)
    player:PickupActivate("EarthDragon_RageMode")
  end
end
function LuaHook_Peak550_ElectricMode_FullScreenEffect_Deactivate()
  if player:PickupIsAcquired("EarthDragon_RageMode") then
    player:PickupSetStage("EarthDragon_RageMode", 2)
  end
end
function LuaHook_Peak550_MortarLob_PatternLABTEST()
  local mortarObjectsSeq = {
    "MortarLocGroup_A00",
    "MortarLocGroup_A03",
    "MortarLocGroup_B01",
    "MortarLocGroup_B06",
    "MortarLocGroup_B04",
    "MortarLocGroup_B011",
    "MortarLocGroup_B08"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_GroupA()
  local mortarObjects = thisLevel:FindGameObjects("MortarLocGroup_A*")
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_GroupB()
  local mortarObjects = thisLevel:FindGameObjects("MortarLocGroup_B*")
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_GroupC()
  local mortarObjects = thisLevel:FindGameObjects("MortarLocGroup_C*")
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_GroupAll()
  local mortarObjects = thisLevel:FindGameObjects("MortarLocGroup_*")
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos01_Wave()
  local mortarObjectsSeq = {
    "MortarLocGroup_C01",
    "MortarLocGroup_C03",
    "MortarLocGroup_C04",
    "MortarLocGroup_B011",
    "MortarLocGroup_B010",
    "MortarLocGroup_B08",
    "MortarLocGroup_B04",
    "MortarLocGroup_B06",
    "MortarLocGroup_B012",
    "MortarLocGroup_B03",
    "MortarLocGroup_B02",
    "MortarLocGroup_A04",
    "MortarLocGroup_A02",
    "MortarLocGroup_A00",
    "MortarLocGroup_A01"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos02_Wave()
  local mortarObjectsSeq = {
    "MortarLocGroup_B011",
    "MortarLocGroup_B03",
    "MortarLocGroup_C04",
    "MortarLocGroup_B02",
    "MortarLocGroup_B010",
    "MortarLocGroup_A02",
    "MortarLocGroup_C03",
    "MortarLocGroup_A03",
    "MortarLocGroup_B09",
    "MortarLocGroup_A00",
    "MortarLocGroup_C02",
    "MortarLocGroup_A01",
    "MortarLocGroup_B08",
    "MortarLocGroup_A04",
    "MortarLocGroup_C01"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos03_Wave()
  local mortarObjectsSeq = {
    "MortarLocGroup_A01",
    "MortarLocGroup_B03",
    "MortarLocGroup_A04",
    "MortarLocGroup_B07",
    "MortarLocGroup_B00",
    "MortarLocGroup_B011",
    "MortarLocGroup_B04",
    "MortarLocGroup_C04",
    "MortarLocGroup_B08",
    "MortarLocGroup_C01"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos01_Gaps()
  local mortarObjectsSeq = {
    "MortarLocGroup_C02",
    "MortarLocGroup_C04",
    "MortarLocGroup_B012",
    "MortarLocGroup_B06",
    "MortarLocGroup_B05",
    "MortarLocGroup_B04",
    "MortarLocGroup_A02",
    "MortarLocGroup_A03",
    "MortarLocGroup_A04"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos02_Gaps()
  local mortarObjectsSeq = {
    "MortarLocGroup_B012",
    "MortarLocGroup_B07",
    "MortarLocGroup_B02",
    "MortarLocGroup_B01",
    "MortarLocGroup_B05",
    "MortarLocGroup_B010",
    "MortarLocGroup_C04",
    "MortarLocGroup_C02",
    "MortarLocGroup_B08",
    "MortarLocGroup_B04",
    "MortarLocGroup_B00",
    "MortarLocGroup_A04",
    "MortarLocGroup_A03",
    "MortarLocGroup_A02"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos03_Gaps()
  local mortarObjectsSeq = {
    "MortarLocGroup_A00",
    "MortarLocGroup_A04",
    "MortarLocGroup_B02",
    "MortarLocGroup_B03",
    "MortarLocGroup_B011",
    "MortarLocGroup_B010",
    "MortarLocGroup_B09"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos01_OutterRim()
  local mortarObjectsSeq = {
    "MortarLocGroup_C02",
    "MortarLocGroup_C03",
    "MortarLocGroup_C01",
    "MortarLocGroup_C04",
    "MortarLocGroup_B08",
    "MortarLocGroup_B011",
    "MortarLocGroup_B04",
    "MortarLocGroup_B012",
    "MortarLocGroup_B00",
    "MortarLocGroup_B07",
    "MortarLocGroup_A04",
    "MortarLocGroup_B03",
    "MortarLocGroup_A01",
    "MortarLocGroup_A02",
    "MortarLocGroup_A00"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos02_OutterRim()
  local mortarObjectsSeq = {
    "MortarLocGroup_B012",
    "MortarLocGroup_B07",
    "MortarLocGroup_B011",
    "MortarLocGroup_B02",
    "MortarLocGroup_C04",
    "MortarLocGroup_A02",
    "MortarLocGroup_C03",
    "MortarLocGroup_A00",
    "MortarLocGroup_C02",
    "MortarLocGroup_A01",
    "MortarLocGroup_C01",
    "MortarLocGroup_B00",
    "MortarLocGroup_B08",
    "MortarLocGroup_B04"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos03_OutterRim()
  local mortarObjectsSeq = {
    "MortarLocGroup_A00",
    "MortarLocGroup_A01",
    "MortarLocGroup_A02",
    "MortarLocGroup_B02",
    "MortarLocGroup_A04",
    "MortarLocGroup_B03",
    "MortarLocGroup_B00",
    "MortarLocGroup_B07",
    "MortarLocGroup_B04",
    "MortarLocGroup_B011",
    "MortarLocGroup_B08",
    "MortarLocGroup_C04",
    "MortarLocGroup_C01",
    "MortarLocGroup_C03",
    "MortarLocGroup_C02"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos01_MiddleLine()
  local mortarObjectsSeq = {
    "MortarLocGroup_C02",
    "MortarLocGroup_B09",
    "MortarLocGroup_B05",
    "MortarLocGroup_B01",
    "MortarLocGroup_A03"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos02_MiddleLine()
  local mortarObjectsSeq = {
    "MortarLocGroup_B012",
    "MortarLocGroup_B07",
    "MortarLocGroup_B06",
    "MortarLocGroup_B05",
    "MortarLocGroup_B04"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos03_MiddleLine()
  local mortarObjectsSeq = {
    "MortarLocGroup_A00",
    "MortarLocGroup_A03",
    "MortarLocGroup_B01",
    "MortarLocGroup_B05",
    "MortarLocGroup_B09"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos01_Stripes()
  local mortarObjectsSeq = {
    "MortarLocGroup_C02",
    "MortarLocGroup_B08",
    "MortarLocGroup_C01",
    "MortarLocGroup_C03",
    "MortarLocGroup_B012",
    "MortarLocGroup_B06",
    "MortarLocGroup_B05",
    "MortarLocGroup_B04",
    "MortarLocGroup_A02",
    "MortarLocGroup_A03",
    "MortarLocGroup_A04"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos02_Stripes()
  local mortarObjectsSeq = {
    "MortarLocGroup_B012",
    "MortarLocGroup_B011",
    "MortarLocGroup_B07",
    "MortarLocGroup_C04",
    "MortarLocGroup_B03",
    "MortarLocGroup_B05",
    "MortarLocGroup_B01",
    "MortarLocGroup_B09",
    "MortarLocGroup_A03",
    "MortarLocGroup_C02",
    "MortarLocGroup_A00"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos03_Stripes()
  local mortarObjectsSeq = {
    "MortarLocGroup_A00",
    "MortarLocGroup_B00",
    "MortarLocGroup_B01",
    "MortarLocGroup_B02",
    "MortarLocGroup_B03",
    "MortarLocGroup_B08",
    "MortarLocGroup_B09",
    "MortarLocGroup_B010",
    "MortarLocGroup_B011",
    "MortarLocGroup_B012"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos01_YSplit()
  local mortarObjectsSeq = {
    "MortarLocGroup_C02",
    "MortarLocGroup_B09",
    "MortarLocGroup_B05",
    "MortarLocGroup_B01",
    "MortarLocGroup_B02",
    "MortarLocGroup_A03",
    "MortarLocGroup_B03",
    "MortarLocGroup_A01"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos02_YSplit()
  local mortarObjectsSeq = {
    "MortarLocGroup_B012",
    "MortarLocGroup_B06",
    "MortarLocGroup_B05",
    "MortarLocGroup_B01",
    "MortarLocGroup_B09",
    "MortarLocGroup_A04",
    "MortarLocGroup_C01"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos03_YSplit()
  local mortarObjectsSeq = {
    "MortarLocGroup_A00",
    "MortarLocGroup_A03",
    "MortarLocGroup_B01",
    "MortarLocGroup_B06",
    "MortarLocGroup_B04",
    "MortarLocGroup_B011",
    "MortarLocGroup_B08"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  InitMortarTimers(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos01_SquareZones()
  local mortarObjectsSeq = {
    "MortarLocGroup_B08",
    "MortarLocGroup_C01",
    "MortarLocGroup_C02",
    "MortarLocGroup_B09",
    "MortarLocGroup_A01",
    "MortarLocGroup_A00",
    "MortarLocGroup_A02",
    "MortarLocGroup_A03",
    "MortarLocGroup_B012",
    "MortarLocGroup_B06",
    "MortarLocGroup_B07",
    "MortarLocGroup_B011"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  FireMortarGroup(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos02_SquareZones()
  local mortarObjectsSeq = {
    "MortarLocGroup_B06",
    "MortarLocGroup_B07",
    "MortarLocGroup_B011",
    "MortarLocGroup_A01",
    "MortarLocGroup_A04",
    "MortarLocGroup_A03",
    "MortarLocGroup_B08",
    "MortarLocGroup_C01",
    "MortarLocGroup_C02"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  FireMortarGroup(mortarObjects)
end
function LuaHook_Peak550_MortarLob_PatternPos03_SquareZones()
  local mortarObjectsSeq = {
    "MortarLocGroup_B010",
    "MortarLocGroup_C03",
    "MortarLocGroup_C04",
    "MortarLocGroup_B011",
    "MortarLocGroup_B00",
    "MortarLocGroup_B04",
    "MortarLocGroup_B05",
    "MortarLocGroup_B01",
    "MortarLocGroup_A01",
    "MortarLocGroup_A00",
    "MortarLocGroup_A02",
    "MortarLocGroup_A03"
  }
  local mortarObjects = ConvertTableStringsToObjects(mortarObjectsSeq)
  FireMortarGroup(mortarObjects)
end
function ConvertTableStringsToObjects(stringTable)
  local l_objTable = {}
  for i, v in ipairs(stringTable) do
    print("Mortar " .. "Sequence" .. tostring(i) .. "-" .. tostring(v))
    table.insert(l_objTable, thisLevel:FindSingleGameObject(v))
  end
  return l_objTable
end
function InitMortarTimers(mortarObjects)
  for i, v in ipairs(mortarObjects) do
    print("Mortar " .. "Sequence" .. tostring(i) .. "-" .. tostring(v))
    local l_MortarObj_loc = v:GetWorldPosition()
    timers.StartLevelTimer(i * 0.25, function()
      FireElectricMortar(dragonActor, l_MortarObj_loc)
    end)
  end
end
function FireMortarGroup(mortarObjects)
  for i, v in ipairs(mortarObjects) do
    print("Mortar " .. "Sequence" .. tostring(i) .. "-" .. tostring(v))
    local l_MortarObj_loc = v:GetWorldPosition()
    FireElectricMortar(dragonActor, l_MortarObj_loc)
  end
end
function FireElectricMortar(ai, targetLocation)
  local arrowData = {}
  local concussionParams = {
    Tweak = "CNC_EARTHDRAGON_FIREMODE_GROUND_TELL",
    WorldLocation = targetLocation,
    GameObject = dragonActor,
    EnemyId = dragonActor:GetID()
  }
  game.Combat.PlayConcussion(concussionParams)
end
function StartStage2CS()
  dragonActor:TriggerMoveEvent("LE_S2_DragonBackAttackSynch")
  BossEncounter:ForwardState()
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
function VibrateWallDestroyed()
  DisableSplineCamera()
  timers.StartLevelTimer(0.5, function()
    GameObjects.CA_Post_Up_Arrow_Upgrade_Tutorial.LuaObjectScript.Disable()
  end)
end
function DragonKill_Shell()
  Show_CineZone_SindriDragon()
  BossEncounter:SetActiveState("BossStage_DeathPose")
  player:Warp(GameObjects.WarpToDragonDeath:GetWorldPosition(), GameObjects.WarpToDragonDeath:GetWorldForward())
  son:Warp(GameObjects.WarpToDragonDeath:GetWorldPosition(), GameObjects.WarpToDragonDeath:GetWorldForward())
end
function WarpToDragonArena()
  son:Warp(GameObjects.WarpToDragonArena:GetWorldPosition(), GameObjects.WarpToDragonDeath:GetWorldForward())
end
function DragonKill_ShowTraversePaths()
  GameObjects.TraversePath_CrackClimb_Dragon:Show()
  GameObjects.TraversePath_CrackClimb_Dragon:ShowTraversePath()
end
function Hide_CineZone_SindriDragon()
  GameObjects.Cine_SindriDragon:Hide()
end
function Show_CineZone_SindriDragon()
  GameObjects.Cine_SindriDragon:Show()
end
function SpawnHealthOnDragonStun()
  local l_currentState = BossEncounter:GetActiveStateName()
  local l_jointIndex = dragonActor:GetJointIndex("JORightEye1")
  local l_jointPosition = dragonActor:GetWorldJointPosition(l_jointIndex)
  local spawnPosistionTable = {}
  if l_currentState == "BossStage_Pos1_Stun" then
    spawnPosistionTable = {
      l_jointPosition + engine.Vector.New(-3, -0.6, 3.5),
      l_jointPosition + engine.Vector.New(-5, -0.6, 2.5)
    }
  elseif l_currentState == "BossStage_Pos3_Stun" then
    spawnPosistionTable = {
      l_spawnPos1 = l_jointPosition + engine.Vector.New(4, -0.6, -4),
      l_spawnPos2 = l_jointPosition + engine.Vector.New(5, -0.6, 0)
    }
  elseif l_currentState == "BossStage_Pos2_Stun" then
    spawnPosistionTable = {
      l_jointPosition + engine.Vector.New(-2, -0.6, -6),
      l_jointPosition + engine.Vector.New(-3, -0.6, -4),
      l_jointPosition + engine.Vector.New(-5, -0.6, -3)
    }
  elseif l_currentState == "BossStage_TugWar_Pos02_Stun" then
    spawnPosistionTable = {
      l_jointPosition + engine.Vector.New(3, -0.6, -1),
      l_jointPosition + engine.Vector.New(4, -0.6, -2),
      l_jointPosition + engine.Vector.New(6, -0.6, -2)
    }
  end
  for l_limit, spawnPos in pairs(spawnPosistionTable) do
    local l_spawnArgs = {
      SpawnObject = "golootGenericHealthRune",
      OffsetPosition = spawnPos,
      Level = game.Level.GetPermLevel()
    }
    print("HEALTH SPAWNED: ", l_limit)
    dragonActor:SpawnGameObject(l_spawnArgs)
  end
end
function SonBowOut()
  son:CallScript("LuaHook_SetBowOutStatus", true)
end
function SonBowBack()
  son:CallScript("LuaHook_SetBowOutStatus", false)
  son:CallScript("LuaHook_ToggleSlowdownStops", false)
  game.AI.FindSon():RemoveMarker("PostUpNoCollision")
  LD.CallFunctionAfterDelay(function()
    son:CallScript("LuaHook_ToggleSlowdownStops", true)
  end, 5)
  son:ClearFocus()
end
function SaveCustomDriverForRake()
  if dragonActor:HasMarker("SAVECUSTOMAIMDRIVER") then
    AimDriverName = dragonActor:GetAnimDriver("AngleToTargetHorizontal")
    AimDriverNameCustom = dragonActor:GetAnimDriver("CustomAimDriver")
    AimDriverNameCustom.Value = AimDriverName.Value
  end
end
function CraneLower()
  dragonCrane:ClearAllAnimCallbacks()
  dragonCrane:StartAnim("csCraneLower")
  dragonCrane:PlayAnimToEnd(1)
end
function CraneFailDrop()
  dragonCrane:ClearAllAnimCallbacks()
  dragonCrane:StartAnim("stg3_csClampFail")
  dragonCrane:PlayAnimToEnd(1)
end
function CraneWinDrop()
  dragonCrane:ClearAllAnimCallbacks()
  dragonCrane:StartAnim("stg3_csClampWin")
  dragonCrane:PlayAnimToEnd(1)
end
function CraneReset()
  dragonCrane:ClearAllAnimCallbacks()
  dragonCrane:StartAnim("stg3_csClampFail", 0.1)
  local endframes = dragonCrane.AnimLengthFrames - 10
  dragonCrane:PlayAnimToFrame(endframes, -1)
  dragonCrane:PlayAnimToEnd(-1)
end
function PlayCraneReadyPose()
  dragonCrane:ClearAllAnimCallbacks()
  dragonCrane:StartAnim("CraneReadyPose")
  dragonCrane:PlayAnimToEnd(1)
end
function PlayCraneRetractedPose()
  dragonCrane:ClearAllAnimCallbacks()
  dragonCrane:StartAnim("CraneRetractedPose")
  dragonCrane:PlayAnimToEnd(1)
end
function CraneFinalePose()
  dragonCrane:ClearAllAnimCallbacks()
  dragonCrane:StartAnim("Stg3_Pos02hitStunBombFace_trans")
  dragonCrane:JumpAnimationToFrame(719)
  dragonCrane:PauseAnimation()
end
function FindEarthDragon()
  return PeakDragonModule:FindEarthDragon()
end
function spawnDragonBoss()
  if dragonActor == nil then
    BossEncounter:AddCreature("BossDragonSpawner")
    if FindEarthDragon() == nil then
      if game.Level.GetVariable("CompletedCineNumber") >= 290 then
        BossEncounter:SpawnBoss("damageState_p5")
      else
        BossEncounter:SpawnBoss()
      end
    end
    dragonActor = BossEncounter:GetBoss()
  end
end
function LuaHook_EnableFinaleCollision()
  GameObjects.FinaleCollision:Show()
  GameObjects.FinaleCollision:ShowCollision()
end
function LuaHook_Dragon_StunBombFace_Breakables(ai, data)
  local l_breakableObj = thisLevel:GetGameObject("dragon_stunbombface")
  if l_breakableObj ~= nil then
    l_breakableObj:Show()
    l_breakableObj:JumpAnimationToFrame(0)
    l_breakableObj:PlayAnimToEnd()
  end
end
function Reset_Dragon_StunBombFace_Breakables(ai, data)
  local l_breakableObj = thisLevel:GetGameObject("dragon_stunbombface")
  if l_breakableObj ~= nil then
    l_breakableObj:Hide()
    l_breakableObj:JumpAnimationToFrame(0)
    l_breakableObj:PauseAnim()
  end
end
function ResetMeterBars()
  dragonActor:MeterSetValue("DragonBossHealth_Hidden", dragonDefaultHealth)
  dragonActor:MeterSetValue("DragonBossHealth", dragonDefaultHealth)
  dragonActor:MeterSetValue("DragonBossShield", 100)
end
function LuaHook_RegenBombFaceDamage_FromPos01Stun()
  PeakDragonModule.RegenBombFaceDamage_FromPos01Stun()
end
function LuaHook_InitMetersForStartOfPos01Stun()
  PeakDragonModule.InitMetersForStartOfPos01Stun()
end
function LuaHook_InitMetersForStartOfPos03Melee()
  PeakDragonModule.InitMetersForStartOfPos03Melee()
end
function LuaHook_InitMetersForStartOfPos03Stun()
  PeakDragonModule.InitMetersForStartOfPos03Stun()
end
function LuaHook_RegenBombFaceDamage_FromPos03Stun()
  PeakDragonModule.RegenBombFaceDamage_FromPos03Stun()
end
function LuaHook_InitMetersForStartOfPos02Melee()
  PeakDragonModule.InitMetersForStartOfPos02Melee()
end
function LuaHook_RegenBombFaceDamage_FromPos02Stun()
  PeakDragonModule.RegenBombFaceDamage_FromPos02Stun()
end
function LuaHook_InitMetersForStartOfPos02Stun()
  PeakDragonModule.InitMetersForStartOfPos02Stun()
end
function LuaHook_InitMetersForStartOfTugOfWar()
  PeakDragonModule.InitMetersForStartOfTugOfWar()
end
function LuaHook_InitMetersForStartOfTugOfWarStun()
  PeakDragonModule.InitMetersForStartOfTugOfWarStun()
end
function ToggleRakeEnvCollisionOnMoves()
  if dragonActor:IsPlayingMove("MOV_Stg3_Pos03attClawRakeLoopBlend") or dragonActor:IsPlayingMove("MOV_Stg3_Pos03attClawRakeStrikeEndBlend") then
    dragonActor:ShowJoint(dragonActor:GetJointIndex("JORakeCollision"))
  else
    dragonActor:HideJoint(dragonActor:GetJointIndex("JORakeCollision"))
  end
end
function GetDirectionToTarget(ai)
  local l_target = ai:GetTargetCreature()
  if l_target == nil then
    return false
  end
  local vecToTarget = l_target:GetWorldPosition() - ai:GetWorldPosition()
  local distToTarget = vecToTarget:Length()
  return distToTarget
end
function LuaHook_BreakPlatform(ai, data)
  local l_breakableObj = thisLevel:GetGameObject("structure_new_break")
  if l_breakableObj ~= nil then
    l_breakableObj:JumpAnimationToFrame(0)
    l_breakableObj:PlayAnimToEnd()
  end
end
function LuaHook_TriggerFinaleFX(ai, data)
  local l_breakableObj1 = thisLevel:GetGameObject("crystal_Pristine")
  local l_breakableObj2 = thisLevel:GetGameObject("dragon_death_break_group")
  if l_breakableObj1 ~= nil then
    l_breakableObj1:Hide()
  end
  if l_breakableObj2 ~= nil then
    l_breakableObj2:Show()
    l_breakableObj2:JumpAnimationToFrame(0)
    l_breakableObj2:PlayAnimToEnd()
  end
end
function RestoreGiantCrystalState()
  local l_breakableObj1 = thisLevel:GetGameObject("crystal_Pristine")
  local l_breakableObj2 = thisLevel:GetGameObject("dragon_death_break_group")
  if l_breakableObj1 ~= nil then
    l_breakableObj1:Show()
  end
  if l_breakableObj2 ~= nil then
    l_breakableObj2:Hide()
    l_breakableObj2:JumpAnimationToFrame(0)
    l_breakableObj2:PauseAnimation()
  end
end
function LuaHook_SwapGiantCrystalToFinale()
  local l_breakableObj1 = thisLevel:GetGameObject("crystal_Pristine")
  local l_breakableObj2 = thisLevel:GetGameObject("dragon_death_break_group")
  if l_breakableObj1 ~= nil then
    l_breakableObj1:Hide()
  end
  if l_breakableObj2 ~= nil then
    l_breakableObj2:Show()
    l_breakableObj2:JumpAnimationToFrame(0)
    l_breakableObj2:PauseAnimation()
  end
end
function SetGiantCrystalStateToBroken()
  local l_breakableObj1 = thisLevel:GetGameObject("crystal_Pristine")
  local l_breakableObj2 = thisLevel:GetGameObject("dragon_death_break_group")
  if l_breakableObj1 ~= nil then
    l_breakableObj1:Hide()
  end
  if l_breakableObj2 ~= nil then
    l_breakableObj2:Show()
    l_breakableObj2:JumpAnimationToPercent(1)
    l_breakableObj2:PauseAnimation()
  end
end
function LuaHook_Peak550_TriggerFinaleDamageState(ai, data)
  dragonActor:SetCharacterConfig("damageState_p5")
end
function SubmitDragonBossCamera550_Base()
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_DragonArena550") and dragonActor ~= nil and dragonActor:IsDead() ~= true then
    game.Camera.SubmitCameraByName("CBT_EarthDragon_Base_Near")
    game.Camera.SubmitCameraByName("CBT_EarthDragon_Base_Far")
    if dragonActor:HasMarker("Attacking") then
      if dragonActor:HasMarker("FORWARDSWIPE") or dragonActor:HasMarker("JUMPSMASH") or dragonActor:HasMarker("CLAWSHAKE") or dragonActor:HasMarker("CLAWSTOMPRAKE") or dragonActor:HasMarker("ELECTRICBREATHSTRAIGHTTELL") or dragonActor:HasMarker("ELECTRICBREATHSTRAIGHTSTRIKE") or dragonActor:HasMarker("CLAWRAKETELL") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_Base")
      elseif dragonActor:HasMarker("VACUUMBREATHTELL") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_VacuumSuck_Start")
      elseif dragonActor:HasMarker("VACUUMBREATH") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_VacuumSuck_End")
      elseif dragonActor:HasMarker("ELECTRICBREATH") or dragonActor:HasMarker("ELECTRICLOB") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_GroundBombs")
      elseif dragonActor:HasMarker("HITBOMBFACE") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Hit_BombFace")
      elseif dragonActor:HasMarker("BITETELL") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_Bite")
      end
    elseif dragonActor:HasMarker("STUNBOMBFACE") then
      game.Camera.SubmitCameraByName("CBT_EarthDragon_Base_FaceStun")
    end
  end
end
function SubmitDragonBossCamera550_Clamp()
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_DragonArena550") and dragonActor ~= nil and dragonActor:IsDead() ~= true then
    game.Camera.SubmitCameraByName("CBT_EarthDragon_Clamp_Near")
    game.Camera.SubmitCameraByName("CBT_EarthDragon_Clamp_Far")
    if dragonActor:HasMarker("Attacking") then
      if dragonActor:HasMarker("FORWARDSWIPE") or dragonActor:HasMarker("JUMPSMASH") or dragonActor:HasMarker("CLAWSHAKE") or dragonActor:HasMarker("ELECTRICBREATHSTRAIGHTTELL") or dragonActor:HasMarker("ELECTRICBREATHSTRAIGHTSTRIKE") or dragonActor:HasMarker("ELECTRICBREATH") or dragonActor:HasMarker("CLAWRAKETELL") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_Base")
      elseif dragonActor:HasMarker("VACUUMBREATHTELL") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_VacuumSuck_Start")
      elseif dragonActor:HasMarker("VACUUMBREATH") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_VacuumSuck_End")
      elseif dragonActor:HasMarker("BITETELL") then
        game.Camera.SubmitCameraByName("CBT_EarthDragon_Tell_Bite")
      end
    end
  end
end
function LuaHook_AxeMeleeTutorial()
  TUT.AxeMelee_Tutorial()
end
function TUT_CrystalThrowHint_Timer(t)
  if hintCrystalTimer_ID == nil then
    hintCrystalTimer_ID = timers.StartLevelTimer(t, function()
      PlayBanter_PeaksDragonBossFight_CrystalHint()
      TUT.Peak550_CrystalThrowHint_Tutorial()
      hintCrystalTimer_ID:Restart()
    end)
  else
    hintCrystalTimer_ID:Restart()
  end
end
function TUT_CrystalHint()
  TUT.Peak550_CrystalThrowHint_Tutorial()
end
function CheckForRestartCrystalTutorial()
  if isLoadFromSave and 1 <= restartCounter then
    timers.StartLevelTimer(2, function()
      TUT.Peak550_CrystalThrowHint_Splash()
    end)
  end
end
function TUT_DragonMeleeHint_Timer(t)
  if hintMeleeTimer_ID == nil then
    hintMeleeTimer_ID = timers.StartLevelTimer(t, function()
      TUT.Peak550_DragonMeleeHint_Tutorial()
      hintMeleeTimer_ID:Restart()
    end)
  else
    hintMeleeTimer_ID:Restart()
  end
end
function CheckForDragonCombatReminder(t)
  if isLoadFromSave and 1 <= restartCounter then
    TUT_DragonCombatHints_ReminderTimer(t)
  end
end
function TUT_DragonCombatHints_ReminderTimer(t)
  if hintCombatTimer_ID == nil then
    hintCombatTimer_ID = timers.StartLevelTimer(t, function()
      TUT.Peak550_DragonCombatHints_Tutorial()
      hintCombatTimer_ID:Restart()
    end)
  else
    hintCombatTimer_ID:Restart()
  end
end
function CheckForRestartCombatTutorial()
  if isLoadFromSave and 2 <= restartCounter then
    TUT_DragonCombatHints_Splash()
  end
end
function TUT_DragonCombatHints_Splash()
  timers.StartLevelTimer(1, function()
    TUT.Peak550_DragonCombatHints_Splash()
  end)
end
function ResetHintTimers()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  if hintCrystalTimer_ID ~= nil then
    hintCrystalTimer_ID:Reset()
  end
  if hintMeleeTimer_ID ~= nil then
    hintMeleeTimer_ID:Reset()
  end
  if hintCombatTimer_ID ~= nil then
    hintCombatTimer_ID:Reset()
  end
end
function LuaHook_TurnOffDesignerMsgs()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function CheckCrystalGrab()
  print([[


======================================
Inside CheckCrystalGrab func
======================================
]])
  CrystalGrabCounter = CrystalGrabCounter + 1
  if BossEncounter ~= nil then
    local l_currentState = BossEncounter:GetActiveStateName()
    if l_currentState == "BossStage_Pos1_Breath" or l_currentState == "BossStage_Pos3_Breath" or l_currentState == "BossStage_Pos2_Breath" or l_currentState == "BossStage_TugWar_Pos02_Breath" then
      return
    end
  end
  incorrectCrystalGrabCounter = incorrectCrystalGrabCounter + 1
  if 5 <= incorrectCrystalGrabCounter then
    TUT.Peak550_DragonCombatHints_Tutorial()
    incorrectCrystalGrabCounter = 0
  end
end
function HideDragonTooth()
  if dragonActor ~= nil then
    dragonActor:TriggerMoveEvent("SplinterTootActive")
    toothChopped = true
  end
end
function Objective540_End_Delay()
  print("objective has been removed per DiMento")
end
function TransitionToTugOfWar_KratosSync()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  local seq = LD.CreateCineSequence(thisLevel, GameObjects.SyncScriptGroup, "Pos02hitStunBombFace_trans")
  seq:ActorSync(kratosActor, {
    Branch = "BRA_Stg3_Pos02hitBombFace_trans",
    ReferenceJoint = "Phase3ArenaSyncJoint",
    ReferenceJointOn = 1
  })
  seq:StartSequence()
end
function DragonFinisher_KratosSync()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  local seq = LD.CreateCineSequence(thisLevel, GameObjects.SyncScriptGroup, "DragonFinisherStart")
  seq:ActorSync(kratosActor, {
    Branch = "BRA_Stg3_csDragonFinisherStart",
    ReferenceJoint = "Phase3ArenaSyncJoint",
    ReferenceJointOn = 1
  })
  seq:StartSequence()
end
function Peak550_DragonDead()
  if not toothChopped then
    timers.StartLevelTimer(5.5, function()
      BossEncounter:SetActiveState("BossStage_DeathPose")
    end)
  else
    timers.StartLevelTimer(5.5, function()
      BossEncounter:SetActiveState("BossStage_DeathPose")
    end)
    timers.StartLevelTimer(5.6, function()
      HideDragonTooth()
    end)
  end
end
function Peak550_SummitRidgeArrive()
  GameObjects.BifrostVibrate_Fractured2:Hide()
  GameObjects.vibrateSlab1:Hide()
  GameObjects.vibrateSlab1:HideCollision()
end
local Timer_PeaksDragonBossFight_CrystalHint
function PlayBanter_PeaksDragonBossFight_CrystalHint()
  game.Audio.PlayBanter("395_PeaksDragonBossFight_CrystalHint", nil, false, false)
end
function StopTimer_CrystalHint()
  if Timer_PeaksDragonBossFight_CrystalHint then
    Timer_PeaksDragonBossFight_CrystalHint:Stop()
  end
end
local maxNumSounds = 5
local soundDragonEchoEmitters = {}
local soundDragonEchoEvents = {}
function SoundOnInit()
  soundDragonEchoEmitters = GameObjects.SNDDragonEchoGrp.SoundEmitters
  for i = 1, #soundDragonEchoEmitters do
    table.insert(soundDragonEchoEvents, "SND_CHR_EarthDragon_Rock_Rumble_Distant_0" .. i)
  end
end
function LuaHook_PlayDragonSlamSound()
  for i = 1, #soundDragonEchoEmitters do
    LD.PlaySound(soundDragonEchoEmitters[i], soundDragonEchoEvents[i])
  end
end
