local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local checkpoint = require("level.checkpoint")
local CCOS = require("camera.camera_oneshot")
local son, player, elevatorObj, elevatorManager, loadZonesGoingDown, loadZonesGoingUp, playerPuppeteer, sonPuppeteer
local elevatorSyncStarted = false
local btrElevatorUpTriggered = false
local firstRopeDropSCA_Disabled = false
local pad, camOneShot_LimitedUp_GoingDown, camOneShot_LimitedUp_GoingUp
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  pad = player.Pad
  elevatorObj = GameObjects.Elevator_01
  elevatorManager = GameObjects.BasicElevatorManager_Peak580
  loadZonesGoingDown = {
    GameObjects.Peak580_ExpressElevator_Zone_1,
    GameObjects.Peak580_ExpressElevator_Zone_2
  }
  loadZonesGoingUp = {
    GameObjects.Peak580_ExpressElevator_Zone_3,
    GameObjects.Peak580_ExpressElevator_Zone_4
  }
  SoundInit()
end
function OnFirstStart(level)
  LD.HideFX(GameObjects.ElevatorTorch)
  GameObjects.Zone_RopeDropIdle_Disable:HideEntityVolume()
  GameObjects.SpeedControl_ExpressElevator:HideEntityVolume()
  GameObjects.Col_ElevatorDown_Walls_500:HideCollision()
end
function OnStart(level)
  SoundOnStart()
  LD.RegisterForCineUpdate(level, {
    {
      at = 460,
      immediateFn = function()
        if LD.GetEntityVariable("isPeakElevatorBurned") and GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.IsEnabled() == false then
          GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.EnableElevator()
        end
      end,
      fn = function()
        if LD.GetEntityVariable("isPeakElevatorBurned") and GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.IsEnabled() == false then
          GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.EnableElevator()
        end
      end
    }
  })
  if game.Level.GetVariable("CompletedCineNumber") >= 470 then
    elevatorManager.LuaObjectScript.EnableElevator()
  end
end
function OnUpdate(level)
  if camOneShot_LimitedUp_GoingDown ~= nil then
    camOneShot_LimitedUp_GoingDown:Update()
  end
  if camOneShot_LimitedUp_GoingUp ~= nil then
    camOneShot_LimitedUp_GoingUp:Update()
  end
end
function DestroyOneShot_LimitedUp_GoingDown()
  camOneShot_LimitedUp_GoingDown = nil
end
function StartCamera_LimitedUp_GoingDown()
  camOneShot_LimitedUp_GoingDown = CCOS.OneShotCamera.New("PLYR_Elevator_LimitedUp_More", 30)
  camOneShot_LimitedUp_GoingDown:SetCallback(DestroyOneShot_LimitedUp_GoingDown)
  camOneShot_LimitedUp_GoingDown:Start()
end
function DestroyOneShot_LimitedUp_GoingUp()
  camOneShot_LimitedUp_GoingUp = nil
end
function StartCamera_LimitedUp_GoingUp()
  camOneShot_LimitedUp_GoingUp = CCOS.OneShotCamera.New("PLYR_Elevator_LimitedUp_More", 25)
  camOneShot_LimitedUp_GoingUp:SetCallback(DestroyOneShot_LimitedUp_GoingUp)
  camOneShot_LimitedUp_GoingUp:Start()
end
function SendElevator500Animate()
  timer.StartLevelTimer(60, StartCamera_LimitedUp_GoingUp)
  timer.StartLevelTimer(82.3, function()
    local peak500 = game.FindLevel("peak500_ChimneyTop")
    if peak500 ~= nil then
      peak500:CallScript("ElevatorSpoolAnimate")
      camOneShot_LimitedUp_GoingUp = nil
    end
  end)
end
function SendElevator500AnimateReverse()
  StartCamera_LimitedUp_GoingDown()
  local peak500 = game.FindLevel("peak500_ChimneyTop")
  if peak500 ~= nil then
    peak500:CallScript("ElevatorSpoolAnimateReverse")
  end
end
function OnPlayerStartElevator()
  local peak080 = game.FindLevel("peak080_Global")
  if peak080 ~= nil then
    peak080:CallScript("SCA_BackCornerSecret_Disable")
  end
end
function ShowElevatorLights()
  LD.ShowFX(GameObjects.ElevatorTorch)
end
function Peak500_Bookmark_Enable()
  if game.Level.GetVariable("CompletedCineNumber") == 460 then
    local peak500 = game.FindLevel("peak500_ChimneyTop")
    if peak500 ~= nil then
      peak500:CallScript("Peak500_Bookmark_Enable")
    end
  end
end
function Checkpoint_Retraversal()
  if game.Level.GetVariable("CompletedCineNumber") >= 470 then
    game.World.StoreCheckpoint()
  end
end
function Btr_ElevatorUp()
  if btrElevatorUpTriggered == false then
    timer.StartLevelTimer(15, function()
      game.Audio.PlayBanter("100_NothingToLearn")
      btrElevatorUpTriggered = true
    end)
  end
end
function Son_ContextIdle_Bored()
  if game.Level.GetVariable("CompletedCineNumber") == 460 then
    son:CallScript("LuaHook_ResetEnraged")
    game.AI.FindSon():CallScript("EnterBehaviorContext", "BORED_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function SonSyncOff()
  local availabilityState = {AvailableForSync = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  GameObjects.EntZn_SonBoostBailOut:ShowEntityVolume()
end
function SonSyncOn()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function SonSync_BailOut()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function SonSync_BailExit()
  if game.AI.FindSon():IsInsideEntityZone("EntZn_SonInUpperArea") then
    local availabilityState = {AvailableForSync = false}
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  end
end
function SCA_RopeDropIdle_Enable()
  GameObjects.SCA_RopeDropIdle.LuaObjectScript.Enable()
end
function SCA_RopeDropIdle_Disable()
  GameObjects.SCA_RopeDropIdle.LuaObjectScript.Interrupt()
  GameObjects.SCA_RopeDropIdle.LuaObjectScript.Disable()
  firstRopeDropSCA_Disabled = true
end
function SCA_RopeClimbExit_Enable()
  if firstRopeDropSCA_Disabled == true then
    GameObjects.SCA_RopeClimbExit.LuaObjectScript.Enable()
  end
end
function Zone_RopeDropIdle_Disable_ON()
  GameObjects.Zone_RopeDropIdle_Disable:ShowEntityVolume()
  print("ENABLE ZONE")
end
function Col_RopeDrop_Enable()
  GameObjects.Col_RopeDrop:ShowCollision()
end
function SpeedZone_SlowDown_Enable()
  GameObjects.SpeedControl_ExpressElevator:ShowEntityVolume()
  InputMask_Elevator()
end
function SpeedZone_SlowDown_Disable()
  GameObjects.SpeedControl_ExpressElevator:HideEntityVolume()
  ClearInputMask()
end
function InputMask_Elevator()
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadUp)
  pad:DisableGameButton(tweaks.ePad.kPadLeft)
  pad:DisableGameButton(tweaks.ePad.kPadDown)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
end
function ClearInputMask()
  pad:ClearAllDisabledGameButtons()
end
function SetLoadZones()
  local elevator01State = elevatorManager.LuaObjectScript.GetState()
  if elevator01State == "Bottom" or elevator01State == "MovingUp" then
    ShowUpwardLoadZones()
  elseif elevator01State == "Top" or elevator01State == "MovingDown" then
    ShowDownwardLoadZones()
  end
end
function ShowUpwardLoadZones()
  for _, zone in pairs(loadZonesGoingUp) do
    zone:Show()
  end
  for _, zone in pairs(loadZonesGoingDown) do
    zone:Hide()
  end
end
function ShowDownwardLoadZones()
  for _, zone in pairs(loadZonesGoingDown) do
    zone:Show()
  end
  for _, zone in pairs(loadZonesGoingUp) do
    zone:Hide()
  end
end
function BurnableDestroyed_EnableElevator()
  LD.SetEntityVariable("isPeakElevatorBurned", true)
  GameObjects.Col_StaticWalls:HideCollision()
  if game.Level.GetVariable("CompletedCineNumber") == 460 then
    GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.EnableElevator()
  end
end
function SCA_ElevatorRide_Enable()
  GameObjects.SCA_ElevatorRide.LuaObjectScript.Enable()
  print("This reenabled")
end
function ElevatorCollision_Enable()
  GameObjects.Col_StaticWalls:ShowCollision()
end
function ElevatorCollision_Disable()
  GameObjects.Col_StaticWalls:HideCollision()
end
function Spline_500MainPath_Enable_580()
  local peak500 = game.FindLevel("peak500_ChimneyTop")
  if peak500 ~= nil then
    peak500:CallScript("Spline_500MainPath_Enable")
  end
end
function Spline_500MainPath_Disable_580()
  local peak500 = game.FindLevel("peak500_ChimneyTop")
  if peak500 ~= nil then
    peak500:CallScript("Spline_500MainPath_Disable")
  end
end
function OnReachTopFloor()
  if game.Level.GetVariable("CompletedCineNumber") == 460 then
    elevatorManager.LuaObjectScript.DisableElevator()
  end
end
function Col_ElevatorDown_Walls_Enable()
  GameObjects.Col_ElevatorDown_Walls_500:ShowCollision()
end
function Col_ElevatorDown_Walls_Disable()
  GameObjects.Col_ElevatorDown_Walls_500:HideCollision()
end
function WarpSonToUpperArea()
  son:Warp(GameObjects.SonWarp.WorldPosition, GameObjects.SonWarp:GetWorldForward())
  GameObjects.RopeDrop_VibratePuzzle.LuaObjectScript.EnableSonInteract()
end
function StartVibrateElevatorEncounter1()
  local peak500 = game.FindLevel("peak500_ChimneyTop")
  if peak500 ~= nil then
    peak500:CallScript("StartVibrateElevatorEncounter1")
  end
end
function StartVibrateGearEncounter2()
  local peak500 = game.FindLevel("peak500_ChimneyTop")
  if peak500 ~= nil then
    peak500:CallScript("StartVibrateGearEncounter2")
  end
end
function Peak580_ExpressElevatorActive()
  timer.StartLevelTimer(1, function()
    GameObjects.ExpressElevatorPuzzleScript.LuaObjectScript.Debug_PuzzleSolved_ElevatorReady()
  end)
  timer.StartLevelTimer(1, function()
    GameObjects.RopeDrop_VibratePuzzle.LuaObjectScript.Enable()
  end)
end
function Peak580_ExpressElevatorBottomFloor()
  GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.EnableElevator()
  GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.JumpToBottomFloor()
end
function Peak580_ExpressElevatorTopFloor()
  GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.EnableElevator()
  GameObjects.BasicElevatorManager_Peak580.LuaObjectScript.JumpToTopFloor()
end
function Btr_NotNowBlackRuneStone()
  if game.Level.GetVariable("CompletedCineNumber") < 460 and game.Level.GetVariable("CompletedCineNumber") > 330 then
    game.Audio.PlayBanter("000_NotNowBlackRuneStone")
  end
end
function Complete_Quest_PeaksPass_Objective800()
  LD.CompleteQuest("Quest_PeaksPass_Objective800")
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 460 <= cineNumber and cineNumber < 470 then
    game.Compass.SetDesignerForcedHide(true)
    game.Audio.StartMusic("SND_MX_PEAK2_hard_questions")
  end
end
local emitter
local elevatorSounds = {
  OnForward = "SND_MECH_Wooden_Elevator_Peak500_LP",
  OnBackward = "SND_MECH_Wooden_Elevator_Peak500_LP"
}
function SoundInit()
  emitter = elevatorObj:FindSingleSoundEmitterByName("SNDElevatorPeak580")
  elevatorSounds.SoundEmitter = emitter
end
function SoundOnStart()
  elevatorManager.LuaObjectScript.SoundSetup(elevatorSounds)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    btrElevatorUpTriggered = btrElevatorUpTriggered
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  btrElevatorUpTriggered = savedInfo.btrElevatorUpTriggered
end
