LD = require("design.LevelDesignLibrary")
timers = require("level.timer")
local thisObj, wheelCrank01, traverseBuddyBoost, pulleyMechanism, pulley
local vibrateExplodedFirstTime = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  print(thisObj)
  wheelCrank01 = GameObjects.WheelCrank01
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  SoundOnStart()
end
function OnFirstStart(level, obj)
  GameObjects.TraverseLink_MantlePuzzle:HideTraverseLink()
  GameObjects.RockCollapse_Collision:HideCollision()
  GameObjects.TraversePath_CrackClimbPuzzle:HideTraversePath()
  GameObjects.peakspassSummitCrank10:StartAnim("envPeakSummitCrank10_Vertical")
  GameObjects.peakspassSummitCrank10:PauseAnim()
  wheelCrank01.LuaObjectScript.SetDrivenObject(GameObjects.peakspassSummitCrank10)
  GameObjects.peakspassSummitCrank00:StartAnim("envRotate720")
  GameObjects.peakspassSummitCrank00:PauseAnim()
  wheelCrank01.LuaObjectScript.SetAnimSynchedObjects("peakspassSummitCrank00")
end
function RockFall2()
  GameObjects.Peak720_vibrate_weight_01_p.Child:PlayAnimToEnd()
  GameObjects.IdleContextPuzzle_Peak720.LuaObjectScript.Disable()
  GameObjects.RockCollapse_Collision:ShowCollision()
  GameObjects.LiftUP:Hide()
  PlaySoundRockFall()
  GameObjects.TraverseLink_MantlePuzzle:ShowTraverseLink()
  GameObjects.TraversePath_CrackClimbPuzzle:ShowTraversePath()
  wheelCrank01.LuaObjectScript.RemovePlayerImmediate()
  _G.DestroyVibrateLift_SCA_ToggleOFF()
  timers.StartLevelTimer(0.8, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_MEDIUM",
      Duration = 0.8,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.8}
    })
  end)
  timers.StartLevelTimer(0.8, function()
    game.Blender.Trigger({
      Name = "FFB_LARGE",
      Duration = 0.8,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.5},
      Priority = 3000
    })
  end)
end
function Vibrate02SetupSolve()
  wheelCrank01.LuaObjectScript.Unlock()
  GameObjects.Peak720_vibrate_weight_01_p.Child:PlayAnimToEnd()
  GameObjects.LiftUP:Hide()
  GameObjects.TraverseLink_MantlePuzzle:ShowTraverseLink()
  GameObjects.ElevatorRock:Hide()
  GameObjects.ElevatorRock:HideCollision()
end
function PlayAnim_VibrateExplode()
  GameObjects.peakspassSummitCrank20:ClearAllAnimCallbacks()
  GameObjects.peakspassSummitCrank20:StartAnim("peakspassSummitCrank20_HitExplode")
  GameObjects.peakspassSummitCrank20:JumpAnimToFrame(0)
  GameObjects.peakspassSummitCrank20:OnAnimDone(thisObj, "PlayAnim_Idle")
  vibrateExplodedFirstTime = true
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_LARGE",
    Duration = 0.45,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0},
    Priority = 3000
  })
  game.Blender.Trigger({
    Name = "FFB_GIANT",
    Duration = 0.45,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.2},
    Priority = 3000
  })
  if wheelCrank01.LuaObjectScript.GetCurrentCycle() < 3 and vibrateExplodedFirstTime == false then
    GameObjects.Peak720_Banter.FirstRechargingCrystal_InitialSuccess_Banter()
  end
end
function PlayAnim_BasketHit()
  GameObjects.peakspassSummitCrank20:ClearAllAnimCallbacks()
  GameObjects.peakspassSummitCrank20:StartAnim("peakspassSummitCrank20_HitReact")
  GameObjects.peakspassSummitCrank20:OnAnimDone(thisObj, "PlayAnim_Idle")
end
function PlayAnim_Idle()
  GameObjects.peakspassSummitCrank20:ClearAllAnimCallbacks()
  GameObjects.peakspassSummitCrank20:StartAnim("peakspassSummitCrank20_Idle")
  GameObjects.peakspassSummitCrank20:PlayAnimCycle()
end
function PlayAnim_Stop()
  GameObjects.peakspassSummitCrank20:ClearAllAnimCallbacks()
  GameObjects.peakspassSummitCrank20:StartAnim("peakspassSummitCrank20_Stop")
  GameObjects.peakspassSummitCrank20:JumpAnimToFrame(0)
  GameObjects.peakspassSummitCrank20:OnAnimDone(thisObj, "PlayAnim_Idle")
end
function WheelCrankAtBeginningEvent()
  PlayAnim_Stop()
  StopSoundOnCogs()
end
function WheelCrankAtEndEvent()
  PlayAnim_Stop()
  StopSoundOnCogs()
end
function WheelCrankOnAttachedEvent()
  StopSoundOnCogs()
end
function WheelCrankOnForwardEvent()
  PlaySoundCogsForward()
end
function WheelCrankOnBackwardEvent()
  PlaySoundCogsBackward()
end
function WheelCrankOnRewindEvent()
  PlaySoundCogsBackward()
end
function WheelCrankOnPauseEvent()
  PlayAnim_Stop()
  StopSoundOnCogs()
end
local RockFallEmitter
local BasketDrivenObjOverrides = {
  SoundEmitter = GameObjects.peakspassSummitCrank10_P.Child:FindSingleSoundEmitterByName("SNDCrankBasket"),
  UseExplicitSoundMotion = true,
  OnForward = "SND_MECH_Wood_Basket_Lift_Gears_Down_PeaksPass_LP",
  OnBackward = "SND_MECH_Wood_Basket_Lift_Gears_Up_PeaksPass_LP",
  OnRewind = "SND_MECH_Wood_Basket_Lift_Gears_Down_PeaksPass_LP"
}
local CogsSoundTable = {
  SoundEmitter = GameObjects.peakspassSummitCrank10_P.Child:FindSingleSoundEmitterByName("SNDCrankCogs"),
  OnForward = "SND_MECH_Wood_Basket_Lift_Cogs_Up_PeaksPass_LP",
  OnBackward = "SND_MECH_Wood_Basket_Lift_Cogs_Down_PeaksPass_LP",
  OnRewind = "SND_MECH_Wood_Basket_Lift_Cogs_Down_PeaksPass_LP"
}
function SoundOnStart()
  wheelCrank01.LuaObjectScript.DrivenObjectSoundSetup(BasketDrivenObjOverrides)
  RockFallEmitter = GameObjects.Vibrate02_Setup:FindSingleSoundEmitterByName("SNDRockCollapse")
end
function PlaySoundCogsForward()
  LD.PlaySound(CogsSoundTable.SoundEmitter, CogsSoundTable.OnForward)
end
function PlaySoundCogsBackward()
  LD.PlaySound(CogsSoundTable.SoundEmitter, CogsSoundTable.OnBackward)
end
function StopSoundOnCogs()
  LD.StopSound(CogsSoundTable.SoundEmitter, CogsSoundTable.OnForward)
  LD.StopSound(CogsSoundTable.SoundEmitter, CogsSoundTable.OnBackward)
end
function PlaySoundRockFall()
  LD.PlaySound(RockFallEmitter, "SND_MECH_Wood_Basket_Lift_Collapse_PeaksPass")
end
