local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, son, player, kratosActor, sonActor, mistletoeArrow, cineLights, cameraCineEnterDoorOpen, cameraCineEnterArrowFix
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  SetupCineLightsAndProps()
  HideCineLightsAndProps()
  if game.Level.GetVariable("CompletedCineNumber") >= 300 then
    GameObjects.SpeedControl_ArrowFix:Hide()
  end
end
function OnUpdate(level, obj)
  if cameraCineEnterDoorOpen ~= nil then
    cameraCineEnterDoorOpen:Update()
  end
  if cameraCineEnterArrowFix ~= nil then
    cameraCineEnterArrowFix:Update()
  end
end
function SetupActors()
  kratosActor = actor.Actor.New("ARROW FIX: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("ARROW FIX: Son Actor", game.AI.FindSon)
end
function SetupCineLightsAndProps()
  mistletoeArrow = GameObjects.mistletoeArrowProp.Child
  cineLights = GameObjects.Cine_Start_300
end
function ShowCineLightsAndProps()
  mistletoeArrow:Show()
  cineLights:Show()
end
function HideCineLightsAndProps()
  mistletoeArrow:Hide()
  cineLights:Hide()
end
function PlayCineLights()
  cineLights:JumpAnimToFrame(0)
  cineLights:PlayAnimToEnd()
end
function SetupCineSequence()
  if game.Level.GetVariable("CompletedCineNumber") < 300 then
    SetupActors()
    local seq = LD.CreateCineSequence(thisLevel, thisObj, "Arrow Fix Sequence")
    local door = GameObjects.HingeDoor_Upper.Child
    local actorTable = {
      {Actor = sonActor},
      {
        Obj = mistletoeArrow,
        Anim = "narPeakArrowFix020CineScene"
      }
    }
    local peaksDoorReveal_actors = {
      {Actor = sonActor},
      {
        Obj = door,
        Anim = "DoorDoublePushCloseLook_reverseDoor"
      }
    }
    door.LuaObjectScript.EnableCinematicTrigger(true)
    seq:Do(CameraStartPeakDoorEnter)
    seq:Do(CameraActivateWalkCamZone)
    seq:Do(StartButtonMasking)
    seq:RequestCineModeAndWait(kratosActor, thisObj)
    seq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_PeaksDoorReveal",
      ReferenceJoint = "SpreadDoor_Upper_synchJointFront",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = 0.3,
      weapon_state = "bare"
    })
    seq:ActorSync(kratosActor, {
      Slaves = peaksDoorReveal_actors,
      Branch = "BRA_PeaksDoorReveal",
      ReferenceJoint = "SpreadDoor_Upper_synchJointFront"
    })
    seq:Do(function()
      GameObjects.SCA_ArrowFix_ObsFor.LuaObjectScript.Enable()
    end)
    seq:WaitForFunctionTrue(function()
      return son:IsPlayingMove("MOV_PeaksDoorReveal")
    end)
    seq:WaitSeconds(1)
    seq:Do(function()
      thisLevel:CallScript("ToggleRidgeWindFromCine")
    end)
    seq:WaitSeconds(2.4)
    seq:Do(function()
      _G.ZoneReportTheSummit()
    end)
    seq:WaitForFunctionTrue(function()
      return not son:IsPlayingMove("MOV_PeaksDoorReveal")
    end)
    seq:StopPuppetingActor(sonActor)
    seq:WaitUntilActorAnimPastPercentage(kratosActor, 0.354)
    seq:Do(function()
      game.Audio.PlayBanter("440_SummitInView_1")
    end)
    seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    seq:StartPOIMoment()
    seq:Do(function()
      door:ShowNavObstacle()
      game.Audio.PlayBanter("peak_BrokenQuiver")
    end)
    seq:WaitSeconds(0.6)
    seq:Do(EndKratosIdle)
    seq:WaitSeconds(2.4)
    seq:Do(function()
      GameObjects.SCA_ArrowFix_ObsFor.LuaObjectScript.Disable()
      GameObjects.LeadTheWay_740ArrowFixIntro.LuaObjectScript.Disable()
      GameObjects.LeadTheWay_740Ridge_Lead.LuaObjectScript.Enable()
      game.SubmitActivityFeedStory("05_PeaksArrival")
    end)
    seq:Do(function()
      sonActor:StartPuppetingForce(thisObj)
    end)
    seq:Do(function()
      sonActor:GetActivePuppeteer().Puppet:ClearLocomotionSlowDownBehavior()
    end)
    seq:ActorForceApproachAndWait(sonActor, {
      Branch = "BRA_ArrowFixIdle",
      ReferenceJoint = "ArrowFix_SynchJoint",
      speed = ND.SonRunSpeed,
      stop = false,
      foot = game.Creature.Foot.kRight,
      radius = ND.ArrivalRadius
    })
    seq:ActorSync(sonActor, {
      Branch = "BRA_ArrowFixIdle",
      ReferenceJoint = "ArrowFix_SynchJoint"
    })
    seq:WaitForActorInZone(kratosActor, thisObj)
    seq:Do(CameraStartArrowFixEnter)
    seq:RequestCineModeAndWait(kratosActor, thisObj)
    seq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_ArrowFix",
      ReferenceJoint = "ArrowFix_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kLeft,
      radius = ND.ArrivalRadius,
      weapon_state = "bare"
    })
    seq:SetPostSkipMusic("SND_MX_PEAK_start_master")
    seq:Do(function()
      seq:MarkAbleToSkip()
    end)
    seq:Do(ShowCineLightsAndProps)
    seq:Do(PlayCineLights)
    seq:Do(SetDamagedQuiver)
    seq:ActorSync(kratosActor, {
      Slaves = actorTable,
      Branch = "BRA_ArrowFix",
      ReferenceJoint = "ArrowFix_SynchJoint"
    })
    seq:WaitUntilActorAnimPastFrame(kratosActor, 590)
    seq:Do(CameraDeactivateWalkCamZone)
    seq:Do(SetFixedQuiver)
    seq:Do(function()
      mistletoeArrow:Hide()
    end)
    seq:WaitForActorPuppeteerComplete(sonActor)
    seq:StopPuppetingActor(sonActor)
    seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    seq:EndPOIMoment()
    seq:StopPuppetingActor(kratosActor)
    seq:Do(HideCineLightsAndProps)
    seq:Do(StopButtonMasking)
    seq:Do(function()
      GameObjects.SpeedControl_ArrowFix:Hide()
    end)
    seq:SetCompletedCineNumber(300)
    seq:Do(function()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "09_PeaksPass_060_SummitRidge"]
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
    seq:Do(function()
      game.Audio.PlayBanter("440_SummitInView_3")
    end)
    seq:StartSequence()
  end
end
function StartButtonMasking()
  local pad = player.Pad
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
end
function StopButtonMasking()
  local pad = player.Pad
  pad:EnableGameButton(tweaks.ePad.kPadCross)
  pad:EnableGameButton(tweaks.ePad.kPadSquare)
end
function StartKratosIdle()
  kratosActor:StartPuppetingForce(thisObj)
  kratosActor:GetActivePuppeteer():StartMove("MOV_ArrowFixIdle")
end
function EndKratosIdle()
  player:TriggerMoveEvent("LE_ArrowFixIdle_Disengage")
  kratosActor:StopPuppeting()
end
function SetDamagedQuiver()
  ND.SafePickupSetStage(son, "SonStrap_Visual", 1)
end
function SetRepairQuiver()
  ND.SafePickupSetStage(son, "SonStrap_Visual", 2)
end
function SetFixedQuiver()
  ND.SafePickupSetStage(son, "SonStrap_Visual", 3)
end
function CameraStartPeakDoorEnter()
  game.SubObject.Wake(thisObj)
  cameraCineEnterDoorOpen = CCEC.CineEnterCamera.New("ENV_CineEnter_Peak_SummitReveal", 5, nil)
  cameraCineEnterDoorOpen:SetCallback(DestroyPeakDoorEnter)
  cameraCineEnterDoorOpen:Start()
end
function CameraStartArrowFixEnter()
  game.SubObject.Wake(thisObj)
  cameraCineEnterArrowFix = CCEC.CineEnterCamera.New("ENV_CineEnter_narPeakArrowFix020CineScene", 8, nil)
  cameraCineEnterArrowFix:SetCallback(DestroyStartArrowFixEnter)
  cameraCineEnterArrowFix:Start()
end
function DestroyPeakDoorEnter()
  cameraCineEnterDoorOpen = nil
  game.SubObject.Sleep(thisObj)
end
function DestroyStartArrowFixEnter()
  cameraCineEnterArrowFix = nil
  game.SubObject.Sleep(thisObj)
end
function CameraActivateWalkCamZone()
  GameObjects.CamZone_SonApproach_ArrowFix:ShowCameraVolume()
end
function CameraDeactivateWalkCamZone()
  GameObjects.CamZone_SonApproach_ArrowFix:HideCameraVolume()
end
