local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local timer = require("level.timer")
local thisObj, thisLevel, mimObj, kratosActor, sonActor, mimirActor, ashPouch, mimirRope, cine_lights_310
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  SetupProps()
  HideBaldurReturnsLights()
  LoadCheckPointBanter()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
end
function SetSpawnFunctions()
  if not mimirActor.actor_func then
    mimirActor:SetSpawnFunction(function()
      local cineWAD = game.FindLevel("Peak740_c310_MimirIntro")
      local spawnBranch
      if game.Level.GetVariable("CompletedCineNumber") < 310 then
        spawnBranch = "BRA_IdleWithHead"
      else
        spawnBranch = "BRA_IdleWithoutHead"
      end
      return ND.SpawnAIAtJoint(cineWAD, "Cine_MimirIntro", "Mimir_Start", "CRT_Mimir00", spawnBranch, "Mimir")
    end)
  end
end
function FindMimir()
  local mimirReference
  local objArray = game.World.FindGameObjectsByMarker("Mimir")
  if 1 < #objArray then
    error("Warning: there are multiple mimirs, getting reference will be unpredictable.")
    return mimirReference
  else
    for _, obj in ipairs(objArray) do
      if obj:GetCreature() ~= nil and obj:GetCreature():GetAI() ~= nil then
        mimirReference = obj:GetCreature():GetAI()
      end
    end
    return mimirReference
  end
end
function SetupProps()
  cine_lights_310 = GameObjects.Cine_Start_310
  ashPouch = GameObjects.ashesPouchProp.Child
  mimirRope = GameObjects.mimirRopeProp.Child
  HideCineLightsAndProps()
end
function HideBaldurReturnsLights()
  GameObjects.Cine_Start_480:JumpAnimToFrame(0)
  GameObjects.Cine_Start_480:PauseAnim()
  GameObjects.Cine_Start_480:Hide()
end
function ShowBaldurReturnsLights()
  GameObjects.Cine_Start_480:Show()
end
function SetupActors()
  kratosActor = actor.Actor.New("MIMIR INTRO: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("MIMIR INTRO: Son Actor", game.AI.FindSon)
  mimirActor = actor.Actor.New("MIMIR INTRO: Mimir Actor", FindMimir)
  SetSpawnFunctions()
end
function SetupCineSequence()
  SetupActors()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "mimirIntro")
  local actorTable = {
    {Actor = sonActor},
    {Actor = mimirActor},
    {
      Obj = ashPouch,
      Anim = "narPeakMimirIntro000CineScene"
    },
    {
      Obj = mimirRope,
      Anim = "narPeakMimirIntro000CineScene"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_PEAK_start_master")
  cineSeq:Do(AddApproachMarker)
  cineSeq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer():IsPlayingMove("MOV_Crack_Climb_Up_Exit")
  end)
  cineSeq:RequestCineModeAndWait(kratosActor, thisObj)
  cineSeq:Do(ShowPropsAndLights)
  cineSeq:Do(PlayCineLights)
  cineSeq:SpawnActorAndWait(mimirActor)
  cineSeq:Do(function()
    local peak740 = game.FindLevel("Peak740_SummitPeak")
    timer.StartLevelTimer(92.4, function()
      GameObjects.SummitHenge_RevealMagic:FindSingleGOByName("Jotunheim_reveal"):PlayAnimToEnd()
      peak740:CallScript("PlaySoundHengePortalLoop")
    end)
    timer.StartLevelTimer(105.4, function()
      peak740:CallScript("StopSoundHengePortalLoop")
    end)
    timer.StartLevelTimer(114.2, function()
      GameObjects.SummitHenge_RevealMagic:FindSingleGOByName("Jotunheim_reveal"):PlayAnimToEnd(-1)
    end)
  end)
  cineSeq:ActorSync(kratosActor, {
    Slaves = actorTable,
    Branch = "BRA_MimirIntro",
    ReferenceJoint = "MimirIntro_SyncJoint"
  })
  cineSeq:Do(function()
    cineSeq:MarkAbleToSkip()
  end)
  cineSeq:Do(function()
    game.World.DisablePlayerStateSoftSave()
  end)
  cineSeq:Do(HideMimirBodyRopes)
  cineSeq:WaitForFunctionTrue(function()
    return game.Player.FindPlayer().MimirHead ~= nil
  end)
  cineSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.18)
  cineSeq:Do(VisOffMimirHeadRope)
  cineSeq:WaitUntilActorAnimPastFrame(kratosActor, 7554)
  cineSeq:Do(VisOnMimirHeadRope)
  cineSeq:WaitForActorFinishMove(sonActor, "MOV_MimirIntro")
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  cineSeq:Do(RemoveApproachMarker)
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(mimirActor)
  cineSeq:Do(function()
    cineSeq:EndSkipIfActive()
  end)
  cineSeq:Do(function()
    game.Audio.PlayBanter("450_BackToTheWitch", function()
      banterPlayed.BackToTheWitch = true
    end)
  end)
  cineSeq:Do(HideCineLightsAndProps)
  cineSeq:Do(function()
    GameObjects.TraversePath_SummitClimbFirst:HideTraversePath()
  end)
  cineSeq:Do(function()
    kratosActor:GetCreature():PickupSetStage("MimirHead", 1)
  end)
  cineSeq:SetCompletedCineNumber(310)
  cineSeq:WaitSeconds(0.2)
  cineSeq:Do(function()
    GameObjects.SCA_PostMimirIntro.LuaObjectScript.Enable()
  end)
  cineSeq:WaitSeconds(1)
  cineSeq:Do(function()
    game.World.EnablePlayerStateSoftSave()
  end)
  cineSeq:Do(Quest_Jotunheim_Parent_Start)
  cineSeq:Do(BOOKMARK_09_PeaksPass_070_PreFastTravel)
  cineSeq:StartSequence()
end
function AddApproachMarker()
  local player = game.Player.FindPlayer()
  if not player:HasMarker("ApproachingCine") then
    player:AddMarker("ApproachingCine")
  end
end
function RemoveApproachMarker()
  local player = game.Player.FindPlayer()
  if player:HasMarker("ApproachingCine") then
    player:RemoveMarker("ApproachingCine")
  end
end
function LoadCheckPointBanter()
  if game.Level.GetVariable("CompletedCineNumber") == 310 and not banterPlayed.BackToTheWitch then
    game.Audio.PlayBanter("450_BackToTheWitch", function()
      banterPlayed.BackToTheWitch = true
    end)
  end
end
function HideMimirBodyRopes()
  mimirActor:GetCreature():CallScript("HideRealMimirHeadRope")
end
function VisOnMimirHeadRope()
  kratosActor:GetCreature():CallScript("ShowMimirRopes")
end
function VisOffMimirHeadRope()
  kratosActor:GetCreature():CallScript("HideMimirRopes")
end
function ShowPropsAndLights()
  ashPouch:Show()
  mimirRope:Show()
  cine_lights_310:Show()
end
function PlayCineLights()
  cine_lights_310:JumpAnimToFrame(0)
  cine_lights_310:PlayAnimToEnd()
end
function HideCineLightsAndProps()
  cine_lights_310:JumpAnimToFrame(0)
  cine_lights_310:PauseAnim()
  cine_lights_310:Hide()
  ashPouch:Hide()
  mimirRope:Hide()
end
function BOOKMARK_09_PeaksPass_070_PreFastTravel()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "09_PeaksPass_070_PreFastTravel"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function QuestEndSummit_StartJotenheim()
  print("function removed because it was being called in two places and the other objective was removed")
end
function Quest_Jotunheim_Parent_Start()
  game.QuestManager.ProposeQuestState("Quest_PeaksPass_Objective300", "Complete")
  LD.ActivateQuest("Quest_Jotunheim_Parent")
end
