local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local delayTimers = require("level.timer")
thisObj = nil
thisLevel = nil
player = nil
son = nil
local Area_1_Encounter_1, Area_1_Encounter_1_2, PeakRiseAlertZoneMonitor1, Area_1_Encounter_2, Area_1_Encounter_2_2, PeakRiseAlertZoneMonitor2, Area_9_Encounter_1
local Rift_Challenge_Duration = 60
local Challenge_Started = false
local ecTimer, ec_TimeRequirement, hudTimeRemaining
local delayDestruction = false
local delayDestruction_T = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  Area_1_Fight_1()
  if game.GetNewGamePlus() then
    New_Game_Plus_Rift_Proj_Fight()
  else
    Rift_Proj_Fight()
  end
end
function OnUpdate(level, obj)
  if Challenge_Started then
    Encounter_Timer()
  end
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") <= 459 then
    GameObjects.LootPocketRift740.LuaObjectScript.Disable()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 460 then
    GameObjects.LootPocketRift740.LuaObjectScript.Enable()
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function Stop_A1F1()
end
function PeakSummitCheckpoint()
  if Area_1_Encounter_1:IsComplete() then
    game.World.StoreCheckpoint()
  end
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Enemies Peak740", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone740",
    StartMusic = "SND_MX_PEAK_ridge_fight_31_in",
    StopMusic = "SND_MX_PEAK_ridge_fight_31_out"
  })
  Area_1_Encounter_1:AddWave({
    timeBeforeNextWave = 2,
    {
      spawners = "Bandit_2_RISING3",
      spawnLocators = "A1_E_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_2_RISING1",
      spawnLocators = "A1_E_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_2_RISING5",
      spawnLocators = "A1_E_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Bandit_2_RISING2",
      spawnLocators = "A1_E_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Bandit_2_RISING3",
      spawnLocators = "A1_E_Loc_10",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Bandit_2_RISING3",
      spawnLocators = "A1_E_Loc_11",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_2_RISING3",
      spawnLocators = "A1_E_Loc_12",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "Bandit_2_RISING3",
      spawnLocators = "A1_E_Loc_13",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_1_Encounter_Start, {
    cineRequirement = {285, 305}
  })
  Area_1_Encounter_1:OnComplete(PeakSummitCheckpoint)
  PeakRiseAlertZoneMonitor1 = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Arena_1_Encounter_Alert"))
  PeakRiseAlertZoneMonitor1:OnEnter(function()
    Area_1_Encounter_1:AlertEnemies()
    timers.StartLevelTimer(1, function()
      Area_1_Encounter_1:StartWave(3)
    end)
    timers.StartLevelTimer(2.2, function()
      Area_1_Encounter_1:AlertEnemies()
    end)
  end)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(4)
    timers.StartLevelTimer(1, function()
      Area_1_Encounter_1:AlertEnemies()
    end)
    timers.StartLevelTimer(2, function()
      Area_1_Encounter_1:AlertEnemies()
    end)
    timers.StartLevelTimer(3, function()
      Area_1_Encounter_1:AlertEnemies()
    end)
  end, {count = 4})
  PeakRiseAlertZoneMonitor2 = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Arena_2_Encounter_Alert"))
  PeakRiseAlertZoneMonitor2:OnEnter(function()
    Area_1_Encounter_1:StartWave(4)
    timers.StartLevelTimer(1, function()
      Area_1_Encounter_1:AlertEnemies()
    end)
    timers.StartLevelTimer(2, function()
      Area_1_Encounter_1:AlertEnemies()
    end)
    timers.StartLevelTimer(3, function()
      Area_1_Encounter_1:AlertEnemies()
    end)
  end)
end
function StartFightRift740()
  game.Combat.TurnOnAndLockCombatStatus()
  timers.StartLevelTimer(3, function()
    Area_9_Encounter_1:Start()
  end)
  timers.StartLevelTimer(18, function()
    GameObjects.LootPocketRift740.LuaObjectScript.SpawningDone()
  end)
end
function StopFightRift740()
  GameObjects.LootPocketRift740.LuaObjectScript.StopCombatState()
end
function PlaySoundEnemySpawnFightRift740()
  GameObjects.LootPocketRift740.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
end
function TurnOnPeakRiftMarker()
  LD.SetMarkerState("PEAK_740_RiftFight", 1)
end
function Rift_Proj_Fight()
  Area_9_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Rift Challenge Ice Challenge Peak740", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_PEAK2_rift_fight_in",
    StopMusic = "SND_MX_PEAK2_rift_fight_out"
  })
  Area_9_Encounter_1:AddWave({
    {
      spawners = "Bandit_6_SPRINT",
      spawnLocators = "A1_R_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "Bandit_7_SPRINT",
      spawnLocators = "A1_R_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.8
    },
    {
      spawners = "Bandit_Shield_7_RISING",
      spawnLocators = "A1_R_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.3
    },
    {
      spawners = "Flyers_Ice_Rift",
      spawnLocators = "A1_R_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7.5
    },
    {
      spawners = "Flyers_Ice_Rift",
      spawnLocators = "A1_R_Loc_5",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10.5
    },
    {
      spawners = "Flyers_Ice_Rift",
      spawnLocators = "A1_R_Loc_6",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13.5
    },
    {
      spawners = "Flyers_Ice_Rift",
      spawnLocators = "A1_R_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 17.5
    }
  })
  Area_9_Encounter_1:OnEnemySpawn(PlaySoundEnemySpawnFightRift740)
  Area_9_Encounter_1:OnComplete(StopFightRift740)
  Area_9_Encounter_1:OnComplete(function()
    LD.SetMarkerState("PEAK_740_RiftFight", 0)
  end)
end
function New_Game_Plus_Rift_Proj_Fight()
  Area_9_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 NPlus Rift Challenge Peak740", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_PEAK2_rift_fight_in",
    StopMusic = "SND_MX_PEAK2_rift_fight_out"
  })
  Area_9_Encounter_1:AddWave({
    {
      spawners = "Bandit_6_SPRINT",
      spawnLocators = "A1_R_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "Bandit_7_SPRINT",
      spawnLocators = "A1_R_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.8
    },
    {
      spawners = "Bandit_Shield_7_RISING",
      spawnLocators = "A1_R_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.3
    },
    {
      spawners = "Flyers_Ice_Rift",
      spawnLocators = "A1_R_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7.5
    },
    {
      spawners = "Flyers_Ice_Rift",
      spawnLocators = "A1_R_Loc_5",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10.5
    },
    {
      spawners = "Flyers_Ice_Rift",
      spawnLocators = "A1_R_Loc_6",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13.5
    },
    {
      spawners = "Flyers_Ice_Rift",
      spawnLocators = "A1_R_Loc_4",
      useSpawnLocatorsOnly = true,
      spawnWad = "Peak740_SummitPeak",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 17.5
    }
  })
  Area_9_Encounter_1:OnStart(function()
    Set_Encounter_Timer(Rift_Challenge_Duration)
    Start_Timer()
  end)
  Area_9_Encounter_1:OnEnemySpawn(PlaySoundEnemySpawnFightRift740)
  Area_9_Encounter_1:OnComplete(StopFightRift740)
  Area_9_Encounter_1:OnComplete(function()
    LD.SetMarkerState("PEAK_740_RiftFight", 0)
    Event_Complete()
  end)
end
function Set_Encounter_Timer(timeRequirement)
  ec_TimeRequirement = timeRequirement
  ecTimer = StartLevelTimer(timeRequirement, EventFailed_TimeElapsed)
  ecTimer:Stop()
end
function Start_Timer()
  local startDelay = 1
  Challenge_Started = true
  LD.CallFunctionAfterDelay(function()
    ecTimer:Start()
  end, startDelay)
  hudTimeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = ec_TimeRequirement % 60
  local minutes = (hudTimeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
end
function Encounter_Timer()
  hudTimeRemaining = math.floor(ec_TimeRequirement - ecTimer.time)
  local seconds = hudTimeRemaining % 60
  local minutes = (hudTimeRemaining - seconds) / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.EnableMechanicText(37906, {minutes, seconds})
end
function EventFailed_TimeElapsed()
  local seconds = Rift_Challenge_Duration % 60
  local minutes = Rift_Challenge_Duration / 60
  local Time_Text = string.format("%02d : %02d", minutes, seconds)
  uiCalls.DisableMechanicText()
  Despawn_Enemy_VFX(Area_9_Encounter_1)
  Area_9_Encounter_1:Reset()
  Area_9_Encounter_1:Stop()
  ResetRift_Callback()
  ecTimer:Stop()
  ecTimer:Reset()
  Challenge_Started = false
end
function Event_Complete()
  uiCalls.DisableMechanicText()
  ecTimer:Stop()
  ecTimer:Reset()
  Challenge_Started = false
end
function Despawn_Enemy_VFX(encounter)
  local minTime = 0.01
  local maxTime = 0.3
  local randomFn = function()
    return math.random(minTime * 1000, maxTime * 1000) / 1000
  end
  local enemies = encounter:GetActiveEnemies()
  for _, enemy in pairs(enemies) do
    if enemy ~= nil and enemy:IsDoingSyncMove() == false then
      timers.StartLevelTimer(randomFn(), function()
        if enemy ~= nil then
          SpawnFXAtCreatureLocation(enemy)
          enemy:Destroy()
        end
      end)
      CreatureInSyncMove_DelayDestruction(enemy)
    end
  end
  encounter:ResetLivingEnemiesCount()
  encounter:ReportWaveDespawned(nil)
end
function SpawnFXAtCreatureLocation(creature)
  local fx = game.FX.Spawn("Body_Fire_Explode", nil, {
    AutoDelete = true,
    EffectCreator = creature,
    Scale = 1.5
  })
  local lastEnemyPos = creature:GetWorldJointPosition(creature:GetJointIndex("JOPelvis1"))
  fx:SetWorldPosition(lastEnemyPos)
end
function CreatureInSyncMove_DelayDestruction(creature)
  delayDestruction = true
  delayDestruction_T[creature] = true
end
function UpdateCreatureDestruction()
  if delayDestruction == true then
    local remaining = 0
    for creature, _ in pairs(delayDestruction_T) do
      if creature ~= nil and delayDestruction_T[creature] == true then
        if creature:IsDoingSyncMove() == false then
          SpawnFXAtCreatureLocation(creature)
          creature:Destroy()
          delayDestruction_T[creature] = nil
        else
          remaining = remaining + 1
        end
      end
    end
    if remaining == 0 then
      delayDestruction = false
      delayDestruction_T = {}
    end
  end
end
function ResetRift_Callback()
  GameObjects.LootPocketRift740.LuaObjectScript.ResetCombatState()
end
