local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, thisLevel, player, climbStarted
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if not banterPlayed.MimirsBody_Enabled and game.Level.GetVariable("CompletedCineNumber") >= 330 then
    GameObjects.MimirBody_InteractZone.LuaObjectScript.Enable()
    banterPlayed.MimirsBody_Enabled = true
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
end
function ClimbMonitor_Start()
  SummitInView2_Timer()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "SummitInView2 climb monitor")
  seq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Crack_Climb_Up_Enter") or player:IsPlayingMove("MOV_Crack_Climb_Up_Forward")
  end)
  seq:Do(function()
    climbStarted = true
  end)
  seq:StartSequence()
end
function SummitInView2_Timer()
  timers.StartLevelTimer(25, function()
    if not climbStarted then
      game.Audio.PlayBanter("440_SummitInView_2")
    end
  end)
end
function BlackRune_Trigger()
  GameObjects.ChiselBlocker_BlackRune.LuaObjectScript.StartSonInteraction()
  BlackRuneA_Banter()
  GameObjects.SCA_CrackClimb_Summit_Top.LuaObjectScript.Interrupt()
  GameObjects.SCA_CrackClimb_Summit_Top.LuaObjectScript.Disable()
end
function BlackRuneA_Banter()
  if not banterPlayed.BlackRuneA then
    game.Audio.PlayBanter("130_BlackRuneA")
    banterPlayed.BlackRuneA = true
  end
end
function BlackRuneB_Banter()
  if not banterPlayed.BlackRuneB then
    game.Audio.PlayBanter("130_BlackRuneB")
    banterPlayed.BlackRuneB = true
  end
end
function JotunheimBridge_Banter()
  if not banterPlayed.JotunheimBridge and game.Level.GetVariable("CompletedCineNumber") < 330 then
    game.Audio.PlayBanterNonCritical("455_JotunheimBridge", function()
      banterPlayed.JotunheimBridge = true
    end)
  end
end
