local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, player, kratosActor, sonActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  sonActor = game.AI.FindSon()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function InitializeVariables()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function ClimbWallPeekOverEnter()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "ClimbWallPeekOverEnter")
  local cineSeq_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_Peak740_ClimbWallPeekOverEnter"
    }
  }
  cineSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Crack_Climb_H_Corner_Right_Inside") or player:IsPlayingMove("MOV_Crack_Climb_H_Corner_Right_Inside_Stop") or player:IsPlayingMove("MOV_Crack_Climb_H_Corner_Right_Inside_Start") or player:IsPlayingMove("MOV_Crack_Climb_H_Corner_Right_Inside_Start_Forward")
  end)
  cineSeq:ActorSync(kratosActor, {
    Slaves = cineSeq_ActorTable,
    Branch = "BRA_Peak740_ClimbWallPeekOverEnter",
    ReferenceJoint = "Peak740CineJoint"
  })
  cineSeq:WaitForActorFinishMove(kratosActor, "MOV_Peak740_ClimbWallPeekOverEnter")
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StartSequence()
end
function ClimbWallPeekOverExit()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "ClimbWallPeekOverExit")
  local cineSeq_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_Peak740_ClimbWallPeekOverExit"
    }
  }
  cineSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Peak740_ClimbWallPeekOverIdle") or player:IsPlayingMove("MOV_Peak740_ClimbWallPeekOverIdle")
  end)
  cineSeq:ActorSync(kratosActor, {
    Slaves = cineSeq_ActorTable,
    Branch = "BRA_Peak740_ClimbWallPeekOverExit",
    ReferenceJoint = "Peak740CineJoint"
  })
  cineSeq:WaitForActorFinishMove(kratosActor, "MOV_Peak740_ClimbWallPeekOverExit")
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StartSequence()
end
function ClimbWallPeekOverEnter02()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "ClimbWallPeekOverEnter02")
  local cineSeq_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_Peak740_ClimbWallPeekOverEnter"
    }
  }
  cineSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Crack_Climb_H_Corner_Right_Outside") or player:IsPlayingMove("MOV_Crack_Climb_H_Corner_Right_Outside_Stop") or player:IsPlayingMove("MOV_Crack_Climb_H_Corner_Right_Outside_Start") or player:IsPlayingMove("MOV_Crack_Climb_H_Corner_Right_Outside_Start_Forward")
  end)
  cineSeq:ActorSync(kratosActor, {
    Slaves = cineSeq_ActorTable,
    Branch = "BRA_Peak740_ClimbWallPeekOverEnter",
    ReferenceJoint = "Peak740CineJoint02"
  })
  cineSeq:WaitForActorFinishMove(kratosActor, "MOV_Peak740_ClimbWallPeekOverEnter")
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StartSequence()
end
function ClimbWallPeekOverExit02()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "ClimbWallPeekOverExit02")
  local cineSeq_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_Peak740_ClimbWallPeekOverExit"
    }
  }
  cineSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_Peak740_ClimbWallPeekOverIdle") or player:IsPlayingMove("MOV_Peak740_ClimbWallPeekOverIdle")
  end)
  cineSeq:ActorSync(kratosActor, {
    Slaves = cineSeq_ActorTable,
    Branch = "BRA_Peak740_ClimbWallPeekOverExit",
    ReferenceJoint = "Peak740CineJoint02"
  })
  cineSeq:WaitForActorFinishMove(kratosActor, "MOV_Peak740_ClimbWallPeekOverExit")
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StartSequence()
end
function OnStart(level, obj)
  InitializeVariables()
end
