local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCOS = require("camera.camera_oneshot")
local CSL = require("camera.shakelibrary")
local player, son, sonActor, kratosActor, thisLevel
local noBladesMsg = false
local magniModiMsg = false
local cineTimer
local cineIdled = false
local cineTotalTime = 66
local cineIdle01_StopIfLessThan = 22
local cineIdle01_ReleaseTime = 32
local cineIdle02_StopIfLessThan = 49
local cineIdle02_ReleaseTime = 56
local oneShotFirstIdle00, oneShotFirstIdle01, oneShotFirstIdle02, oneShotCameraFreyaHouse
local bStartedPeekingIdle = false
local varClimbPathUnblocked = false
function OnScriptLoaded(level, obj)
  thisLevel = level
  CompassGatewayToggle()
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
end
function OnFirstStart(level)
  GameObjects.TraversePath_RidgeClimbLower:HideTraversePath()
  GameObjects.TraversePath_RidgeClimbUpper:HideTraversePath()
  GameObjects.TraversePath_SummitClimb:HideTraversePath()
  GameObjects.climb_Glyph_Top3:Hide()
  GameObjects.SummitHenge_Jotunheim_vista:Hide()
  GameObjects.rubbleReturnTripONLY:Hide()
  GameObjects.Zone_Disable_SCA_PostMissingGear:HideEntityVolume()
  GameObjects.CollisionPostBaldur:HideCollision()
  GameObjects.CollisionPostBaldur_Destroyed:ShowCollision()
  GameObjects.NGP_Hint:HideEntityVolume()
end
function OnStart(level)
  if varClimbPathUnblocked == true then
    if game.Level.GetVariable("CompletedCineNumber") > 380 then
      GameObjects.FakeClimbInteract.LuaObjectScript.Disable()
      GameObjects.TraversePath_SummitClimb:ShowTraversePath()
    else
      GameObjects.FakeClimbInteract.LuaObjectScript.GetInteractZone():Lock()
    end
  else
    GameObjects.FakeClimbInteract.LuaObjectScript.Disable()
  end
  if game.Level.GetVariable("CompletedCineNumber") > 310 then
    GameObjects.SCA_PostMimirIntro.LuaObjectScript.Disable()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 460 then
    GameObjects.TraversePath_SummitClimbFirst:HideTraversePath()
    GameObjects.climb_Glyph_Top3:Show()
    GameObjects.SummitHenge_Jotunheim_MimirIntro:Hide()
    GameObjects.SummitHenge_Jotunheim_vista:Show()
    GameObjects.rubbleReturnTripONLY:Show()
    GameObjects.vegetationToggle:Hide()
    GameObjects.LeadTheWay_740Ridge.LuaObjectScript.Disable()
    GameObjects.LeadTheWay_740Ridge_Lead.LuaObjectScript.Disable()
    GameObjects.LeadTheWay_740Ridge_Return.LuaObjectScript.Enable()
  end
  if game.Level.GetVariable("CompletedCineNumber") == 460 then
    GameObjects.FastTravelController.LuaObjectScript.LockFastTravelPoint()
    GameObjects.LeadTheWay_740PostSummitCave.LuaObjectScript.Disable()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 470 then
    GameObjects.DeathPlanes:ShowCollision()
    GameObjects.LeadTheWay_740PostSummitCave.LuaObjectScript.Enable()
    GameObjects.FastTravelController.LuaObjectScript.UnlockFastTravelPoint()
    GameObjects.SCA_BlackRuneStone_PostWait.LuaObjectScript.Disable()
    GameObjects.SCA_CrackClimb_Summit_Top.LuaObjectScript.Disable()
    GameObjects.ChiselBlocker_BlackRune:Hide()
  end
  if game.Level.GetVariable("CompletedCineNumber") < 340 then
    GameObjects.Lake01_high:Show()
    GameObjects.Lake02_low:Hide()
    GameObjects.Tower01:Hide()
    GameObjects.Tower02:Hide()
    GameObjects.Tower03:Hide()
    GameObjects.Tower04:Hide()
    GameObjects.Tower05:Hide()
    GameObjects.Tower06:Hide()
    GameObjects.Tower07:Hide()
    GameObjects.Tower08:Hide()
  end
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber < 515 then
    GameObjects.Lake01_high:Hide()
    GameObjects.Lake02_low:Show()
    GameObjects.Tower01:Show()
    GameObjects.Tower02:Show()
    GameObjects.Tower03:Show()
    GameObjects.Tower04:Show()
    GameObjects.Tower05:Hide()
    GameObjects.Tower06:Show()
    GameObjects.Tower07:Show()
    GameObjects.Tower08:Show()
  end
  if game.Level.GetVariable("CompletedCineNumber") < 355 then
    GameObjects.hammer_up:Show()
    GameObjects.hammer_down:Hide()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 355 then
    GameObjects.hammer_up:Hide()
    GameObjects.hammer_down:Show()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 515 then
    GameObjects.Lake01_high:Hide()
    GameObjects.Lake02_low:Show()
    GameObjects.Tower01:Show()
    GameObjects.Tower02:Show()
    GameObjects.Tower03:Show()
    GameObjects.Tower04:Show()
    GameObjects.Tower05:Show()
    GameObjects.Tower06:Show()
    GameObjects.Tower07:Show()
    GameObjects.Tower08:Show()
  end
  SoundOnStart()
end
function OnUpdate(level)
  if cineTimer ~= nil then
    LD.PrintToScreen(tostring(cineTimer:GetElapsedTime()))
  end
  if oneShotCameraFreyaHouse ~= nil then
    oneShotCameraFreyaHouse:Update()
  end
  if oneShotFirstIdle00 ~= nil then
    oneShotFirstIdle00:Update()
  end
  if oneShotFirstIdle01 ~= nil then
    oneShotFirstIdle01:Update()
  end
  if oneShotFirstIdle02 ~= nil then
    oneShotFirstIdle02:Update()
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_MimirClimb_60AXB") then
    if son ~= nil and son:HasMarker("Peeking") then
      game.Camera.SubmitCameraByName("ENV_CrackClimb_MimirClimb_Peeking_60B")
      if bStartedPeekingIdle ~= true and son:IsPlayingMove("MOV_Peak740_ClimbWallPeekOverIdle") then
        timer.StartLevelTimer(1.2, function()
          bStartedPeekingIdle = true
        end)
      end
      if bStartedPeekingIdle == true and cineIdled == true then
        game.Camera.SubmitCameraByName("ENV_CrackClimb_MimirClimb_Peeking_60B_Zoom")
      end
    end
  elseif game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_MimirClimb_70") and son ~= nil and son:HasMarker("Peeking") then
    game.Camera.SubmitCameraByName("ENV_CrackClimb_MimirClimb_Peeking_70A")
  end
end
function LoadCheck_740MimirIntro()
  game.UI.LoadCheck("Peak740_c310_MimirIntro")
end
function LoadCheck_470_BaldurReturns()
  game.UI.LoadCheck("Peak740_c470_BaldurReturns")
end
function LoadCheck_Peak780()
  game.UI.LoadCheck("Peak780_SummitExit")
end
function IdleContext_Clear()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
end
function FreyaForestVistaStart()
  CameraStartFreyaVista()
  timer.StartLevelTimer(1, function()
    game.Audio.PlayBanter("455_BackToTheWitch02")
  end)
end
function SCA_DoorTop_740_Enable()
  if game.Level.GetVariable("CompletedCineNumber") >= 300 then
    GameObjects.SCA_DoorTop_740.LuaObjectScript.Enable()
  end
end
function SCA_DoorTop_730_Enable()
  if game.Level.GetVariable("CompletedCineNumber") >= 300 then
    GameObjects.SCA_DoorTop_730.LuaObjectScript.Enable()
  end
end
function SCA_DoorBottom_740_Enable()
  GameObjects.SCA_DoorBottom_740.LuaObjectScript.Enable()
end
function SCA_DoorBottom_780_Enable()
  GameObjects.SCA_DoorBottom_780.LuaObjectScript.Enable()
end
function SCA_CrackClimb_Lower_Top_Enable()
  GameObjects.SCA_CrackClimb_Lower_Top.LuaObjectScript.Enable()
end
function SCA_CrackClimb_Lower_Bottom_Enable()
  GameObjects.SCA_CrackClimb_Lower_Bottom.LuaObjectScript.Enable()
end
function SCA_CrackClimb_Upper_Top_Enable()
end
function SCA_CrackClimb_Upper_Bottom_Enable()
  GameObjects.SCA_CrackClimb_Upper_Bottom.LuaObjectScript.Enable()
end
function SCA_CrackClimb_Summit_Top_Enable()
  GameObjects.SCA_BlackRuneStone_PostWait.LuaObjectScript.Interrupt()
  GameObjects.SCA_BlackRuneStone_PostWait.LuaObjectScript.Disable()
  GameObjects.SCA_CrackClimb_Summit_Bottom.LuaObjectScript.Interrupt()
  GameObjects.SCA_CrackClimb_Summit_Bottom.LuaObjectScript.Disable()
  GameObjects.SCA_CrackClimb_Summit_Top.LuaObjectScript.Enable()
  GameObjects.LeadTheWay_740PostSummitCave.LuaObjectScript.Disable()
end
function SCA_CrackClimb_Summit_Bottom_Enable()
  GameObjects.SCA_BlackRuneStone_PostWait.LuaObjectScript.Interrupt()
  GameObjects.SCA_BlackRuneStone_PostWait.LuaObjectScript.Disable()
  GameObjects.SCA_CrackClimb_Summit_Top.LuaObjectScript.Interrupt()
  GameObjects.SCA_CrackClimb_Summit_Top.LuaObjectScript.Disable()
  GameObjects.SCA_CrackClimb_Summit_Bottom.LuaObjectScript.Enable()
end
function SCA_BlackRuneStone_PostWait_Enable()
  GameObjects.SCA_BlackRuneStone_PostWait.LuaObjectScript.Enable()
end
function CompassGatewayToggle()
  if game.Wallets.HasResource("HERO", "Blades") then
    game.Compass.SetGatewayMarkerIsOpen("PP_740_Helper10", true)
  else
    game.Compass.SetGatewayMarkerIsOpen("PP_740_Helper10", false)
  end
end
function ShowDebugTable()
  if engine.IsDebug() then
    local debugTable = {}
    debugTable.Title = "Crack Climb Cine Info"
    debugTable.TitleColor = engine.Vector.New(255, 0, 128)
    local timeElapsed = 0
    if cineTimer ~= nil then
      timeElapsed = ClimbCine_GetElapsedTime()
    end
    debugTable[#debugTable + 1] = {
      "Cine Time Elasped: " .. tostring(math.floor(timeElapsed))
    }
    debugTable[#debugTable + 1] = {
      "-----------------------------------------"
    }
    debugTable[#debugTable + 1] = {
      "Stop 1 if elasped is less than: " .. tostring(cineIdle01_StopIfLessThan) .. "s"
    }
    debugTable[#debugTable + 1] = {
      "Stop 1 release time: " .. tostring(cineIdle01_ReleaseTime) .. "s"
    }
    debugTable[#debugTable + 1] = {
      "-----------------------------------------"
    }
    debugTable[#debugTable + 1] = {
      "Stop 2 if elapsed is less than: " .. tostring(cineIdle02_StopIfLessThan) .. "s"
    }
    debugTable[#debugTable + 1] = {
      "Stop 2 release time: " .. tostring(cineIdle02_ReleaseTime) .. "s"
    }
    engine.DrawDebugTable(debugTable)
  end
end
function ZoneReportTheSummit()
  uiCalls.UI_Event_DiscoverLocation("The Summit")
end
function ReturnToSummit()
  uiCalls.UI_Event_DiscoverLocation("The Summit")
  game.SubmitActivityFeedStory("10_PeaksReturn")
end
function EnableRidgeClimb()
  GameObjects.TraversePath_RidgeClimbLower:ShowTraversePath()
  GameObjects.TraversePath_RidgeClimbUpper:ShowTraversePath()
end
function EnableSummitClimb()
  if game.Level.GetVariable("CompletedCineNumber") > 380 then
    GameObjects.TraversePath_SummitClimb:ShowTraversePath()
    GameObjects.FakeClimbInteract.LuaObjectScript.Disable()
    GameObjects.NGP_Hint:HideEntityVolume()
    HideHint_NGP_Gated()
  else
    GameObjects.FakeClimbInteract.LuaObjectScript.Enable()
    GameObjects.FakeClimbInteract.LuaObjectScript.GetInteractZone():Lock()
    GameObjects.NGP_Hint:ShowEntityVolume()
    varClimbPathUnblocked = true
  end
end
function ShowHint_NGP_Gated()
  local varNGP = game.GetNewGamePlus()
  if varNGP == true then
    local varCineNum = game.Level.GetVariable("CompletedCineNumber")
    if varCineNum < 380 and varClimbPathUnblocked == true then
      uiCalls.SendBottomDesignerMessage({
        Text = 44619,
        DisplayTime = 6,
        Critical = true
      })
    end
  end
end
function HideHint_NGP_Gated()
  local varNGP = game.GetNewGamePlus()
  if varNGP == true then
    local varCineNum = game.Level.GetVariable("CompletedCineNumber")
    if varCineNum < 380 and varClimbPathUnblocked == true then
      uiCalls.UI_Event_TurnOffDesignerMessage()
    end
  end
end
function SetSonOccupied()
  local availabilityState = {Unoccupied = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  print("SON OCCUPIED")
  timer.StartLevelTimer(20, SetSonUnoccupied)
end
function SetSonUnoccupied()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  print("SON UNOCCUPIED")
end
function VibrateChest2()
  GameObjects.Loot_LegendaryChest_Vibrate2.LuaObjectScript.Enable()
end
function BurnableChestActivate()
  GameObjects.coffin_tier1_peak740_1.LuaObjectScript.Enable()
end
function CrackClimbBreak()
  CSL.PlayDefaultShake("WaterMovement", 3.2, 0, 3)
  LD.BreakObject(GameObjects.peak740_crack_climb_break_P)
  PlayRockBreakSound()
  ClimbCine_Started()
  local path = game.FindLevel("Peak740_SummitPeak"):FindTraversePath("TraversePath_SummitClimbFirst")
  path:Disable("CrackBreak")
end
function HideDeathplanes()
  GameObjects.DeathPlanes:HideCollision()
  GameObjects.CollisionPostBaldur:ShowCollision()
  GameObjects.CollisionPostBaldur_Destroyed:HideCollision()
  GameObjects.ChiselBlocker_BlackRune:Hide()
end
function RemoveBladesBlockerLower()
  GameObjects.Int_BladesBlockerLower:PlayAnimToEnd()
end
function RemoveBladesBlockerUpper()
  GameObjects.Int_BladesBlockerUpper:PlayAnimToEnd()
end
function GetBool_zoneIdle1()
end
function GetBool_zoneIdle2()
end
function Disable_SCA_PostMimirIntro()
  GameObjects.SCA_PostMimirIntro.LuaObjectScript.Disable()
end
function Disable_SCA_WitchVista()
  GameObjects.SCA_WitchVista.LuaObjectScript.Disable()
end
function PostMissingGear()
  if game.Level.GetVariable("CompletedCineNumber") == 310 then
    GameObjects.SCA_PostMissingGear.LuaObjectScript.Enable()
    GameObjects.Zone_Disable_SCA_PostMissingGear:ShowEntityVolume()
  end
end
function HengeBreak()
  GameObjects.baldur_returns_henge_break:FindSingleGOByName("henge_break_all"):PlayAnimToEnd()
end
function HengeActivate()
  timer.StartLevelTimer(1, function()
    GameObjects.SummitHenge_RevealMagic:FindSingleGOByName("Jotunheim_reveal"):PlayAnimToEnd()
    PlaySoundHengePortalLoop()
  end)
  timer.StartLevelTimer(70, function()
    GameObjects.SummitHenge_RevealMagic:FindSingleGOByName("Jotunheim_reveal"):PlayAnimToEnd(-1)
    StopSoundHengePortalLoop()
  end)
end
function ClimbCine_IdleZone00Triggered()
  game.UI.Idle(true)
  GameObjects.POI_BaldurVsMimir.LuaObjectScript.BaldurVsMimir_Pre2_Play()
  oneShotFirstIdle00 = CCOS.OneShotCamera.New("PLYR_CrackClimb_MimirClimb_FirstIdle_000", 7.5, nil)
  oneShotFirstIdle00:Start()
  timer.StartLevelTimer(2, StartSecondIdleCamera)
  timer.StartLevelTimer(3.4, StartThirdIdleCamera)
  timer.StartLevelTimer(8, function()
    game.UI.Idle(false)
  end)
end
function StartSecondIdleCamera()
  oneShotFirstIdle01 = CCOS.OneShotCamera.New("PLYR_CrackClimb_MimirClimb_FirstIdle_010", 6.2, nil)
  oneShotFirstIdle01:Start()
end
function StartThirdIdleCamera()
  oneShotFirstIdle02 = CCOS.OneShotCamera.New("PLYR_CrackClimb_MimirClimb_FirstIdle_012", 4.2, nil)
  oneShotFirstIdle02:Start()
  oneShotFirstIdle02:SetCallback(DestroyFirstIdleCameras)
end
function ClimbCine_Started()
  if cineTimer == nil then
    cineTimer = timer.StartLevelTimer(cineTotalTime, ClimbCine_Complete)
  end
end
function ClimbCine_GetElapsedTime()
  if cineTimer ~= nil then
    return cineTimer:GetElapsedTime()
  end
  return cineTotalTime
end
function ClimbCine_IdleZone01Triggered()
  if ClimbCine_GetElapsedTime() < cineIdle01_StopIfLessThan and not cineIdled then
    cineIdled = true
    game.UI.Idle(true)
    LD.CallFunctionAfterDelay(ClimbCine_PeakOverExit, cineIdle01_ReleaseTime - ClimbCine_GetElapsedTime())
    GameObjects.Peak740CineGroup:CallScript("ClimbWallPeekOverEnter")
  end
end
function ClimbCine_PeakOverExit()
  if cineIdled then
    cineIdled = false
    game.UI.Idle(false)
    GameObjects.Peak740CineGroup:CallScript("ClimbWallPeekOverExit")
  end
end
function ClimbCine_IdleZone02Triggered()
  if ClimbCine_GetElapsedTime() < cineIdle02_StopIfLessThan and not cineIdled then
    cineIdled = true
    game.UI.Idle(true)
    LD.CallFunctionAfterDelay(ClimbCine_PeakOverExit02, cineIdle02_ReleaseTime - ClimbCine_GetElapsedTime())
    GameObjects.Peak740CineGroup:CallScript("ClimbWallPeekOverEnter02")
  end
end
function ClimbCine_PeakOverExit02()
  if cineIdled then
    cineIdled = false
    game.UI.Idle(false)
    GameObjects.Peak740CineGroup:CallScript("ClimbWallPeekOverExit02")
  end
end
function ClimbCine_Complete()
  if cineTimer ~= nil then
    cineTimer:Stop()
  end
end
function PeaksPass_Obj810()
  LD.CompleteQuest("Quest_PeaksPass_Objective810")
end
function CompassOn()
  game.Compass.SetDesignerForcedHide(false)
end
function CompassOff()
  game.Compass.SetDesignerForcedHide(true)
end
function OnEvaluateLoadGroup_Cinematic()
  if game.Level.GetVariable("CompletedCineNumber") <= 310 then
    return "Trip1"
  elseif game.Level.GetVariable("CompletedCineNumber") > 400 then
    return "Trip2"
  end
end
local windEmitters = {}
local windEvents = {}
local rockEmitter
local doorEvents = {
  OnInteractForward_Center = "SND_AMB_EMIT_Ridge_Enter_Wind_Gust",
  OnInteractForward_Left = "SND_DOOR_Wood_Double_Pry_Apart_Seq_L",
  OnInteractForward_Right = "SND_DOOR_Wood_Double_Pry_Apart_Seq_R",
  OnInteractBackward_Center = "",
  OnInteractBackward_Left = "SND_DOOR_Wood_Double_Pry_Apart_Seq_L",
  OnInteractBackward_Right = "SND_DOOR_Wood_Double_Pry_Apart_Seq_R"
}
local peak2Music = false
local hengePortalEmitter
local hengePortalActiveLoop = "SND_DOOR_Realm_Portal_LP"
function SoundOnStart()
  windEmitters[1] = GameObjects.SNDRidgeWindQuad740:FindSingleSoundEmitterByName("SNDRidgeWindQuad740_1")
  windEmitters[2] = GameObjects.SNDGrpLowRidge740_1:FindSingleSoundEmitterByName("SNDRidgeWindSpline_1")
  windEmitters[3] = GameObjects.SNDGrpLowRidge740_2:FindSingleSoundEmitterByName("SNDRidgeWindSpline_2")
  windEvents[1] = "SND_AMB_EMIT_Ridge_Wind_Quad"
  windEvents[2] = "SND_AMB_EMIT_Ridge_Wind_Gust_LP"
  windEvents[3] = "SND_AMB_EMIT_Ridge_Wind_Gust_LP"
  rockEmitter = GameObjects.SNDRockBreak740:FindSingleSoundEmitterByName("SNDRockBreak740_1")
  GameObjects.HingeDoor_Upper.Child.LuaObjectScript.RegisterOnStartOpenCallback(ToggleRidgeWind)
  GameObjects.SpreadDoor_Rock6m1.Child.LuaObjectScript.RegisterOnStartOpenCallback(ToggleRidgeWindLower)
  GameObjects.HingeDoor_Upper.Child.LuaObjectScript.SoundSetup(doorEvents)
  doorEvents.OnInteractForward_Center = "SND_AMB_EMIT_Wind_Gust_Peak740"
  GameObjects.SpreadDoor_Rock6m1.Child.LuaObjectScript.SoundSetup(doorEvents)
  LD.CallFunctionAfterDelay(StartWindLoop, 0.1)
  hengePortalEmitter = GameObjects.SNDGrpHenge:FindSingleSoundEmitterByName("SNDHengePortal740")
end
function ToggleRidgeWind()
  local player = game.Player.FindPlayer()
  local doorObject = player:GetCurrentInteractObject()
  if doorObject ~= nil then
    local direction = doorObject.LuaObjectScript.GetInteractDirection()
    for i = 1, #windEmitters do
      if direction == "Forward" then
        LD.PlaySound(windEmitters[i], windEvents[i])
      else
        LD.StopSound(windEmitters[i], windEvents[i])
      end
    end
  end
end
function ToggleRidgeWindFromCine()
  for i = 1, #windEmitters do
    LD.PlaySound(windEmitters[i], windEvents[i])
  end
  GameObjects.HingeDoor_Upper.Child.LuaObjectScript.PlaySoundOnInteract_Forward()
end
function ToggleRidgeWindLower()
  local player = game.Player.FindPlayer()
  local doorObject = player:GetCurrentInteractObject()
  if doorObject ~= nil then
    local direction = doorObject.LuaObjectScript.GetInteractDirection()
    for i = 1, #windEmitters do
      if direction == "Backward" then
        LD.PlaySound(windEmitters[i], windEvents[i])
      else
        LD.StopSound(windEmitters[i], windEvents[i])
      end
    end
  end
end
function PlayRockBreakSound()
  LD.PlaySound(rockEmitter, "SND_AMB_EMIT_PeaksPass_Rock_Crumble")
end
function StartWindLoop()
  local player = game.Player.FindPlayer()
  print("Player level: ", tostring(player.GroundLevel))
  if player.GroundLevel == thisLevel then
    print("Here we gooooo")
    for i = 1, #windEmitters do
      LD.PlaySoundAfterDelay(windEmitters[i], windEvents[i], 0.1)
    end
  end
end
function SummitPeak2Music()
  if game.Level.GetVariable("CompletedCineNumber") >= 460 and game.Level.GetVariable("CompletedCineNumber") < 470 and peak2Music == false then
    game.Audio.StartMusic("SND_MX_PEAK2_summit_ridge")
    peak2Music = true
  end
end
function revisitMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 490 then
    game.Audio.StartCheckpointedMusic("SND_MX_PEAK_revisit_explore_in")
  end
end
function PlaySoundHengePortalLoop()
  LD.PlaySound(hengePortalEmitter, hengePortalActiveLoop)
end
function StopSoundHengePortalLoop()
  LD.StopSound(hengePortalEmitter, hengePortalActiveLoop)
end
function CameraStartFreyaVista()
  local player = game.Player.FindPlayer()
  local cameraSubmitTime = 7
  oneShotCameraFreyaHouse = CCOS.OneShotCamera.New("PLYR_Vista_FreyaForest", cameraSubmitTime, nil)
  oneShotCameraFreyaHouse:Start()
  oneShotCameraFreyaHouse:SetCallback(DestroyCameraFreyaVista)
  player:SetMaxSpeedOverride(1.5)
  timer.StartLevelTimer(cameraSubmitTime, function()
    player:ClearMaxSpeedOverride()
  end)
end
function DestroyCameraFreyaVista()
  oneShotCameraFreyaHouse = nil
end
function DestroyFirstIdleCameras()
  oneShotFirstIdle00 = nil
  oneShotFirstIdle01 = nil
  oneShotFirstIdle02 = nil
end
function OnSaveCheckpoint(level)
  local savedInfo = {
    levelstate = checkpoint.Save(),
    varClimbPathUnblocked = varClimbPathUnblocked
  }
  return savedInfo
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  varClimbPathUnblocked = savedInfo.varClimbPathUnblocked or false
end
function Peak740_MimirCinematicCompleted()
  GameObjects.Int_IceFallClimb:Hide()
  GameObjects.Int_IceFallClimb:HideCollision()
  GameObjects.TraversePath_FirstTrip:HideTraversePath()
end
