local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local sonJerkHappened = false
function OnStart(level)
  GameObjects.EntZn_JerkSpeedControl:HideEntityVolume()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    sonJerkHappened = sonJerkHappened
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  sonJerkHappened = savedInfo.sonJerkHappened
end
function SCA_CaveCrawlExit_720_Enable()
  if game.Level.GetVariable("CompletedCineNumber") == 460 and sonJerkHappened == false then
    GameObjects.SCA_CaveCrawlExit_JerkMoment.LuaObjectScript.Enable()
    GameObjects.EntZn_JerkSpeedControl:ShowEntityVolume()
    LD.CallFunctionAfterDelay(function()
      GameObjects.EntZn_JerkSpeedControl:HideEntityVolume()
    end, 5.5)
  else
    GameObjects.SCA_CaveCrawlExit_720.LuaObjectScript.Enable()
  end
end
function SCA_JerkMoment_Disable()
  if game.Level.GetVariable("CompletedCineNumber") == 460 then
    GameObjects.SCA_CaveCrawlExit_JerkMoment.LuaObjectScript.Interrupt()
    sonJerkHappened = true
  end
end
function LoadCheck_Peak720()
  game.UI.LoadCheck("Peak720_SummitAscentHUB")
end
function LoadCheck_Peak500()
  game.UI.LoadCheck("Peak500_ChimneyTop")
end
